/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.kigalisim.ProgressReportCallback;
import org.kigalisim.engine.SingleThreadEngine;
import org.kigalisim.engine.serializer.EngineResult;
import org.kigalisim.lang.interpret.QubecTalkInterpreter;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.machine.SingleThreadPushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.parse.ParseError;
import org.kigalisim.lang.parse.ParseResult;
import org.kigalisim.lang.parse.QubecTalkParser;
import org.kigalisim.lang.program.ParsedApplication;
import org.kigalisim.lang.program.ParsedPolicy;
import org.kigalisim.lang.program.ParsedProgram;
import org.kigalisim.lang.program.ParsedScenario;
import org.kigalisim.lang.program.ParsedSubstance;

public class KigaliSimFacade {
    private static final String DEFAULT_STANZA = "default";

    public static ParseResult parse(String code) {
        QubecTalkParser parser = new QubecTalkParser();
        return parser.parse(code);
    }

    public static ParsedProgram interpret(ParseResult parseResult) {
        QubecTalkInterpreter interpreter = new QubecTalkInterpreter();
        return interpreter.interpret(parseResult);
    }

    public static ParsedProgram parseAndInterpret(String filePath) throws IOException {
        String code = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        ParseResult parseResult = KigaliSimFacade.parse(code);
        return KigaliSimFacade.interpret(parseResult);
    }

    public static int getNumberTotalTrials(ParsedProgram program) {
        int totalTrials = 0;
        for (String scenarioName : program.getScenarios()) {
            ParsedScenario scenario = program.getScenario(scenarioName);
            totalTrials += scenario.getTrials();
        }
        return totalTrials;
    }

    public static Stream<EngineResult> runScenario(ParsedProgram program, String scenarioName, ProgressReportCallback progressCallback) {
        if (!program.getScenarios().contains(scenarioName)) {
            throw new IllegalArgumentException("Scenario not found: " + scenarioName);
        }
        ParsedScenario scenario = program.getScenario(scenarioName);
        int totalTrials = KigaliSimFacade.getNumberTotalTrials(program);
        int completedTrialsBeforeScenario = 0;
        for (String otherScenarioName : program.getScenarios()) {
            if (otherScenarioName.equals(scenarioName)) break;
            completedTrialsBeforeScenario += program.getScenario(otherScenarioName).getTrials();
        }
        int numTrials = scenario.getTrials();
        Stream<EngineResult> results = Stream.empty();
        for (int i = 0; i < numTrials; ++i) {
            results = Stream.concat(results, KigaliSimFacade.runTrial(program, scenario, i + 1));
            if (progressCallback == null) continue;
            int completedTrials = completedTrialsBeforeScenario + i + 1;
            double progress = (double)completedTrials / (double)totalTrials;
            progressCallback.reportProgress(progress);
        }
        return results;
    }

    public static String getDetailedErrorMessage(ParseResult parseResult) {
        if (!parseResult.hasErrors()) {
            return null;
        }
        List<ParseError> errors = parseResult.getErrors();
        if (errors.isEmpty()) {
            return "Unknown parsing error occurred";
        }
        ParseError firstError = errors.get(0);
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Syntax error at line ").append(firstError.getLine());
        errorMessage.append(": ").append(firstError.getMessage());
        if (errors.size() > 1) {
            errorMessage.append(" (and ").append(errors.size() - 1).append(" more error(s))");
        }
        return errorMessage.toString();
    }

    public static boolean validate(String filePath) {
        try {
            String code = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            ParseResult parseResult = KigaliSimFacade.parse(code);
            if (parseResult.hasErrors()) {
                System.err.println("Validation failed: Parse errors detected");
                return false;
            }
            KigaliSimFacade.interpret(parseResult);
            return true;
        }
        catch (Exception e) {
            System.err.println("Validation failed: " + e.getMessage());
            return false;
        }
    }

    private static void executePolicy(ParsedPolicy policy, PushDownMachine machine) {
        String stanzaName = policy.getName();
        machine.getEngine().setStanza(stanzaName);
        for (String applicationName : policy.getApplications()) {
            ParsedApplication application = policy.getApplication(applicationName);
            machine.getEngine().setApplication(applicationName);
            for (String substanceName : application.getSubstances()) {
                ParsedSubstance substance = application.getSubstance(substanceName);
                machine.getEngine().setSubstance(substanceName);
                for (Operation operation : substance.getOperations()) {
                    try {
                        operation.execute(machine);
                    }
                    catch (Exception e) {
                        System.err.println("Error executing operation: " + e.getMessage());
                        e.printStackTrace();
                        throw e;
                    }
                }
            }
        }
    }

    private static Stream<EngineResult> runTrial(ParsedProgram program, ParsedScenario scenario, int trialNumber) {
        int startYear = scenario.getStartYear();
        int endYear = scenario.getEndYear();
        SingleThreadEngine engine = new SingleThreadEngine(startYear, endYear);
        engine.setScenarioName(scenario.getName());
        engine.setTrialNumber(trialNumber);
        SingleThreadPushDownMachine machine = new SingleThreadPushDownMachine(engine);
        ArrayList<EngineResult> results = new ArrayList<EngineResult>();
        while (!engine.getIsDone()) {
            ParsedPolicy defaultPolicy = program.getPolicy(DEFAULT_STANZA);
            KigaliSimFacade.executePolicy(defaultPolicy, machine);
            for (String policyName : scenario.getPolicies()) {
                ParsedPolicy policy = program.getPolicy(policyName);
                KigaliSimFacade.executePolicy(policy, machine);
            }
            List<EngineResult> yearResults = engine.getResults();
            results.addAll(yearResults);
            engine.incrementYear();
        }
        return results.stream();
    }

    public static String convertResultsToCsv(List<EngineResult> results) {
        if (results.isEmpty()) {
            return "";
        }
        int estimatedCapacity = 450 + results.size() * 430;
        StringBuilder csvBuilder = new StringBuilder(estimatedCapacity);
        csvBuilder.append("scenario,trial,year,application,substance,domestic,import,recycle,").append("domesticConsumption,importConsumption,recycleConsumption,population,").append("populationNew,rechargeEmissions,eolEmissions,initialChargeEmissions,energyConsumption,").append("export,exportConsumption,importInitialChargeValue,").append("importInitialChargeConsumption,importPopulation,").append("exportInitialChargeValue,exportInitialChargeConsumption,").append("bankKg,bankTCO2e,bankChangeKg,bankChangeTCO2e\n");
        for (EngineResult result : results) {
            csvBuilder.append(result.getScenarioName()).append(',').append(result.getTrialNumber()).append(',').append(result.getYear()).append(',').append(result.getApplication()).append(',').append(result.getSubstance()).append(',').append(result.getDomestic().getValue()).append(',').append(result.getImport().getValue()).append(',').append(result.getRecycle().getValue()).append(',').append(result.getDomesticConsumption().getValue()).append(',').append(result.getImportConsumption().getValue()).append(',').append(result.getRecycleConsumption().getValue()).append(',').append(result.getPopulation().getValue()).append(',').append(result.getPopulationNew().getValue()).append(',').append(result.getRechargeEmissions().getValue()).append(',').append(result.getEolEmissions().getValue()).append(',').append(result.getInitialChargeEmissions().getValue()).append(',').append(result.getEnergyConsumption().getValue()).append(',').append(result.getExport().getValue()).append(',').append(result.getExportConsumption().getValue()).append(',').append(result.getTradeSupplement().getImportInitialChargeValue().getValue()).append(',').append(result.getTradeSupplement().getImportInitialChargeConsumption().getValue()).append(',').append(result.getTradeSupplement().getImportPopulation().getValue()).append(',').append(result.getTradeSupplement().getExportInitialChargeValue().getValue()).append(',').append(result.getTradeSupplement().getExportInitialChargeConsumption().getValue()).append(',').append(result.getBankKg().getValue()).append(',').append(result.getBankTco2e().getValue()).append(',').append(result.getBankChangeKg().getValue()).append(',').append(result.getBankChangeTco2e().getValue()).append('\n');
        }
        return csvBuilder.toString();
    }
}

