/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kigalisim.KigaliSimFacade;
import org.kigalisim.ProgressReportCallback;
import org.kigalisim.engine.serializer.EngineResult;
import org.kigalisim.lang.parse.ParseResult;
import org.kigalisim.lang.program.ParsedProgram;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSExport;

public class KigaliWasmSimFacade {
    @JSExport
    public static String getVersion() {
        return "0.1.3";
    }

    @JSBody(params={"progress"}, script="if (typeof reportProgress === 'function') { reportProgress(progress); }")
    private static native void reportProgressToJavaScript(double var0);

    @JSExport
    public static String execute(String code) {
        try {
            ParseResult parseResult = KigaliSimFacade.parse(code);
            if (parseResult.hasErrors()) {
                String detailedError = KigaliSimFacade.getDetailedErrorMessage(parseResult);
                return "Error: " + detailedError + "\n\n";
            }
            ParsedProgram program = KigaliSimFacade.interpret(parseResult);
            ArrayList<EngineResult> allResults = new ArrayList<EngineResult>();
            ProgressReportCallback progressCallback = progress -> KigaliWasmSimFacade.reportProgressToJavaScript(progress);
            for (String scenarioName : program.getScenarios()) {
                List scenarioResults = KigaliSimFacade.runScenario(program, scenarioName, progressCallback).collect(Collectors.toList());
                allResults.addAll(scenarioResults);
            }
            String csvResults = KigaliSimFacade.convertResultsToCsv(allResults);
            return "OK\n\n" + csvResults;
        }
        catch (Exception e) {
            return "Error: " + e.getMessage() + "\n\n";
        }
    }

    @JSExport
    public static String executeScenario(String code, String scenarioName) {
        try {
            ParseResult parseResult = KigaliSimFacade.parse(code);
            if (parseResult.hasErrors()) {
                String detailedError = KigaliSimFacade.getDetailedErrorMessage(parseResult);
                return "Error: " + detailedError + "\n\n";
            }
            ParsedProgram program = KigaliSimFacade.interpret(parseResult);
            if (!program.getScenarios().contains(scenarioName)) {
                return "Error: Scenario not found: " + scenarioName + "\n\n";
            }
            ProgressReportCallback progressCallback = progress -> KigaliWasmSimFacade.reportProgressToJavaScript(progress);
            List<EngineResult> scenarioResults = KigaliSimFacade.runScenario(program, scenarioName, progressCallback).collect(Collectors.toList());
            String csvResults = KigaliSimFacade.convertResultsToCsv(scenarioResults);
            return "OK\n\n" + csvResults;
        }
        catch (Exception e) {
            return "Error: " + e.getMessage() + "\n\n";
        }
    }

    public static void main(String[] args) {
    }
}

