/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.command;

import java.util.Optional;
import org.kigalisim.lang.program.ParsedProgram;

public class CommandInterpretResult {
    private final Optional<ParsedProgram> program;
    private final Optional<String> errorMessage;

    public CommandInterpretResult() {
        this.program = Optional.empty();
        this.errorMessage = Optional.empty();
    }

    public CommandInterpretResult(ParsedProgram program) {
        this.program = Optional.of(program);
        this.errorMessage = Optional.empty();
    }

    public CommandInterpretResult(String errorMessage) {
        this.program = Optional.empty();
        this.errorMessage = Optional.of(errorMessage);
    }

    public Optional<ParsedProgram> getProgram() {
        return this.program;
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getIsSuccess() {
        return this.program.isPresent();
    }

    public boolean getIsFailure() {
        return this.errorMessage.isPresent();
    }
}

