/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.kigalisim.KigaliSimFacade;
import org.kigalisim.ProgressReportCallback;
import org.kigalisim.command.CommandInterpretResult;
import org.kigalisim.engine.serializer.EngineResult;
import org.kigalisim.lang.parse.ParseResult;
import org.kigalisim.lang.program.ParsedProgram;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run a simulation file"})
public class RunCommand
implements Callable<Integer> {
    private static final int FILE_NOT_FOUND_ERROR = 1;
    private static final int PARSE_ERROR = 2;
    private static final int SIMULATION_NOT_FOUND_ERROR = 3;
    private static final int EXECUTION_ERROR = 4;
    private static final int CSV_WRITE_ERROR = 5;
    private static final int INVALID_REPLICATES_ERROR = 6;
    @CommandLine.Parameters(index="0", description={"Path to QubecTalk file to run"})
    private File file;
    @CommandLine.Option(names={"-o", "--output"}, description={"Path to CSV output file"}, required=true)
    private File csvOutputFile;
    @CommandLine.Option(names={"-r", "--replicates"}, description={"Number of times to run each scenario (default: 1)"}, defaultValue="1")
    private int replicates;

    @Override
    public Integer call() {
        if (!this.file.exists()) {
            System.err.println("Could not find file: " + String.valueOf(this.file));
            return 1;
        }
        if (this.replicates < 1) {
            System.err.println("Replicates must be at least 1, got: " + this.replicates);
            return 6;
        }
        CommandInterpretResult interpretResult = this.interpret(this.file);
        if (interpretResult.getIsFailure()) {
            System.err.println(interpretResult.getErrorMessage().orElse("Unknown error"));
            return 2;
        }
        ParsedProgram program = interpretResult.getProgram().orElseThrow();
        Stream<EngineResult> allResults = this.runAndStreamResults(program, x -> {});
        List<EngineResult> resultsList = allResults.collect(Collectors.toList());
        System.out.println();
        Optional<String> writeError = this.writeResultsToCsv(resultsList, this.csvOutputFile);
        if (writeError.isPresent()) {
            System.err.println(writeError.get());
            return 5;
        }
        System.out.println("Successfully ran all simulations and wrote results to " + String.valueOf(this.csvOutputFile));
        return 0;
    }

    private Stream<EngineResult> runAndStreamResults(ParsedProgram program, ProgressReportCallback progressCallback) {
        return ((Stream)program.getScenarios().stream().parallel()).flatMap(scenarioName -> IntStream.range(0, this.replicates).boxed().flatMap(replicateIndex -> {
            System.out.println("Running scenario '" + scenarioName);
            return KigaliSimFacade.runScenario(program, scenarioName, progressCallback);
        }));
    }

    private ParsedProgram interpretUnsafe(File file) throws IOException {
        String code = new String(Files.readAllBytes(file.toPath()));
        ParseResult parseResult = KigaliSimFacade.parse(code);
        if (parseResult.hasErrors()) {
            String detailedError = KigaliSimFacade.getDetailedErrorMessage(parseResult);
            throw new RuntimeException("Failed to parse QubecTalk code:\n" + detailedError);
        }
        return KigaliSimFacade.interpret(parseResult);
    }

    private CommandInterpretResult interpret(File file) {
        try {
            ParsedProgram program = this.interpretUnsafe(file);
            return new CommandInterpretResult(program);
        }
        catch (IOException e) {
            return new CommandInterpretResult("Could not read file: " + String.valueOf(file) + "\nError: " + e.getMessage());
        }
        catch (RuntimeException e) {
            return new CommandInterpretResult("Failed to interpret QubecTalk code at " + String.valueOf(file) + "\nInterpretation error: " + e.getMessage());
        }
    }

    private void writeResultsToCsvUnsafe(List<EngineResult> resultsList, File csvOutputFile) throws IOException {
        String csvContent = KigaliSimFacade.convertResultsToCsv(resultsList);
        try (FileWriter writer = new FileWriter(csvOutputFile);){
            writer.write(csvContent);
        }
    }

    private Optional<String> writeResultsToCsv(List<EngineResult> resultsList, File csvOutputFile) {
        try {
            this.writeResultsToCsvUnsafe(resultsList, csvOutputFile);
            return Optional.empty();
        }
        catch (IOException e) {
            return Optional.of("Failed to write CSV output to " + String.valueOf(csvOutputFile) + "\nError: " + e.getMessage());
        }
    }
}

