/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.command;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.Callable;
import org.kigalisim.KigaliSimFacade;
import org.kigalisim.command.CommandInterpretResult;
import org.kigalisim.lang.parse.ParseResult;
import picocli.CommandLine;

@CommandLine.Command(name="validate", description={"Validate a simulation file"})
public class ValidateCommand
implements Callable<Integer> {
    private static final int FILE_NOT_FOUND_ERROR = 1;
    private static final int VALIDATION_ERROR = 2;
    @CommandLine.Parameters(index="0", description={"Path to QubecTalk file to validate"})
    private File file;

    @Override
    public Integer call() {
        if (!this.file.exists()) {
            System.err.println("Could not find file: " + String.valueOf(this.file));
            return 1;
        }
        CommandInterpretResult interpretResult = this.interpret(this.file);
        if (interpretResult.getIsFailure()) {
            System.err.println(interpretResult.getErrorMessage().orElse("Unknown error"));
            return 2;
        }
        System.out.println("Validated QubecTalk code at " + String.valueOf(this.file));
        return 0;
    }

    private void interpretUnsafe(File file) throws IOException {
        String code = new String(Files.readAllBytes(file.toPath()));
        ParseResult parseResult = KigaliSimFacade.parse(code);
        if (parseResult.hasErrors()) {
            String detailedError = KigaliSimFacade.getDetailedErrorMessage(parseResult);
            throw new RuntimeException("Failed to parse QubecTalk code:\n" + detailedError);
        }
        KigaliSimFacade.interpret(parseResult);
    }

    private CommandInterpretResult interpret(File file) {
        try {
            this.interpretUnsafe(file);
            return new CommandInterpretResult();
        }
        catch (IOException e) {
            return new CommandInterpretResult("Could not read file: " + String.valueOf(file) + "\nError: " + e.getMessage());
        }
        catch (RuntimeException e) {
            return new CommandInterpretResult("Validation failed for QubecTalk code at " + String.valueOf(file) + "\nInterpretation error: " + e.getMessage());
        }
    }
}

