/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcKitBuilder;
import org.kigalisim.engine.recalc.RecalcOperation;
import org.kigalisim.engine.recalc.RecalcOperationBuilder;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.serializer.EngineResult;
import org.kigalisim.engine.serializer.EngineResultSerializer;
import org.kigalisim.engine.state.ConverterStateGetter;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimpleUseKey;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.SimulationStateUpdateBuilder;
import org.kigalisim.engine.state.SubstanceInApplicationId;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.ChangeExecutor;
import org.kigalisim.engine.support.DisplaceExecutor;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.EquipmentChangeUtil;
import org.kigalisim.engine.support.ExceptionsGenerator;
import org.kigalisim.engine.support.LimitExecutor;
import org.kigalisim.engine.support.ReplaceExecutor;
import org.kigalisim.engine.support.SetExecutor;
import org.kigalisim.engine.support.StreamUpdateExecutor;
import org.kigalisim.engine.support.StreamUpdateShortcuts;
import org.kigalisim.lang.operation.RecoverOperation;

public class SingleThreadEngine
implements Engine {
    private static final boolean OPTIMIZE_RECALCS = true;
    private static final String NO_APP_OR_SUBSTANCE_MESSAGE = "Tried %s without application and substance%s.";
    private final int startYear;
    private final int endYear;
    private String scenarioName;
    private int trialNumber;
    private final ConverterStateGetter stateGetter;
    private final UnitConverter unitConverter;
    private final SimulationState simulationState;
    private final ChangeExecutor changeExecutor;
    private final EquipmentChangeUtil equipmentChangeUtil;
    private final StreamUpdateExecutor streamUpdateExecutor;
    private final StreamUpdateShortcuts streamUpdateShortcuts;
    private final ReplaceExecutor replaceExecutor;
    private final DisplaceExecutor displaceExecutor;
    private final LimitExecutor limitExecutor;
    private Scope scope;

    public SingleThreadEngine(int startYear, int endYear) {
        int startYearRearrange = Math.min(startYear, endYear);
        int endYearRearrange = Math.max(startYear, endYear);
        this.startYear = startYearRearrange;
        this.endYear = endYearRearrange;
        this.scenarioName = "";
        this.trialNumber = 0;
        this.stateGetter = new ConverterStateGetter(this);
        this.unitConverter = new UnitConverter(this.stateGetter);
        this.simulationState = new SimulationState(new OverridingConverterStateGetter(this.stateGetter), this.unitConverter);
        this.simulationState.setCurrentYear(startYear);
        this.changeExecutor = new ChangeExecutor(this);
        this.equipmentChangeUtil = new EquipmentChangeUtil(this);
        this.streamUpdateExecutor = new StreamUpdateExecutor(this);
        this.streamUpdateShortcuts = new StreamUpdateShortcuts(this);
        this.replaceExecutor = new ReplaceExecutor(this);
        this.displaceExecutor = new DisplaceExecutor(this);
        this.limitExecutor = new LimitExecutor(this);
        this.scope = new Scope();
    }

    @Override
    public int getStartYear() {
        return this.startYear;
    }

    @Override
    public int getEndYear() {
        return this.endYear;
    }

    @Override
    public String getScenarioName() {
        return this.scenarioName;
    }

    @Override
    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    @Override
    public int getTrialNumber() {
        return this.trialNumber;
    }

    @Override
    public void setTrialNumber(int trialNumber) {
        this.trialNumber = trialNumber;
    }

    @Override
    public void setStanza(String newStanza) {
        this.scope = this.scope.getWithStanza(newStanza);
    }

    @Override
    public void setApplication(String newApplication) {
        this.scope = this.scope.getWithApplication(newApplication);
    }

    @Override
    public void setSubstance(String newSubstance, boolean checkValid) {
        this.scope = this.scope.getWithSubstance(newSubstance);
        if (checkValid) {
            boolean knownSubstance = this.simulationState.hasSubstance(this.scope);
            if (!knownSubstance) {
                throw new RuntimeException("Tried accessing unknown app / substance pair: " + this.scope.getApplication() + ", " + newSubstance);
            }
        } else {
            this.simulationState.ensureSubstance(this.scope);
        }
    }

    @Override
    public void setSubstance(String newSubstance) {
        this.setSubstance(newSubstance, false);
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public ConverterStateGetter getStateGetter() {
        return this.stateGetter;
    }

    @Override
    public UnitConverter getUnitConverter() {
        return this.unitConverter;
    }

    @Override
    public SimulationState getStreamKeeper() {
        return this.simulationState;
    }

    @Override
    public void incrementYear() {
        if (this.getIsDone()) {
            throw new RuntimeException("Already completed.");
        }
        this.simulationState.incrementYear();
    }

    @Override
    public int getYear() {
        return this.simulationState.getCurrentYear();
    }

    @Override
    public boolean getIsDone() {
        return this.simulationState.getCurrentYear() > this.endYear;
    }

    @Override
    public void executeStreamUpdate(StreamUpdate update) {
        Optional<YearMatcher> yearMatcher = update.getYearMatcher();
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        Optional<UseKey> key = update.getKey();
        UseKey keyEffective = key.orElse(this.scope);
        String application = keyEffective.getApplication();
        String substance = keyEffective.getSubstance();
        if (application == null || substance == null) {
            this.raiseNoAppOrSubstance("setting stream", " specified");
        }
        this.streamUpdateExecutor.execute(update);
    }

    @Override
    public void setStream(String name, EngineNumber value, Optional<YearMatcher> yearMatcher) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        if ("equipment".equals(name)) {
            this.equipmentChangeUtil.handleSet(value);
        } else if ("sales".equals(name)) {
            SetExecutor setExecutor = new SetExecutor(this);
            setExecutor.handleSalesSet(this.scope, name, value, yearMatcher);
        } else {
            StreamUpdate update = new StreamUpdateBuilder().setName(name).setValue(value).setYearMatcher(yearMatcher).inferSubtractRecycling().build();
            this.executeStreamUpdate(update);
        }
    }

    @Override
    public void enable(String name, Optional<YearMatcher> yearMatcher) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        Scope keyEffective = this.scope;
        String application = keyEffective.getApplication();
        String substance = keyEffective.getSubstance();
        if (application == null || substance == null) {
            this.raiseNoAppOrSubstance("enabling stream", " specified");
        }
        if ("domestic".equals(name) || "import".equals(name) || "export".equals(name)) {
            this.simulationState.markStreamAsEnabled(keyEffective, name);
        }
    }

    @Override
    public EngineNumber getStream(String name, Optional<UseKey> useKey, Optional<String> conversion) {
        UseKey effectiveKey = useKey.orElse(this.scope);
        EngineNumber value = this.simulationState.getStream(effectiveKey, name);
        return conversion.map(conv -> this.unitConverter.convert(value, (String)conv)).orElse(value);
    }

    @Override
    public EngineNumber getStream(String name) {
        return this.getStream(name, Optional.of(this.scope), Optional.empty());
    }

    @Override
    public EngineNumber getStreamFor(UseKey key, String stream) {
        return this.simulationState.getStream(key, stream);
    }

    @Override
    public void defineVariable(String name) {
        if ("yearsElapsed".equals(name) || "yearAbsolute".equals(name)) {
            throw new RuntimeException("Cannot override yearsElapsed or yearAbsolute.");
        }
        this.scope.defineVariable(name);
    }

    @Override
    public EngineNumber getVariable(String name) {
        return switch (name) {
            case "yearsElapsed" -> new EngineNumber(BigDecimal.valueOf(this.simulationState.getCurrentYear() - this.startYear), "years");
            case "yearAbsolute" -> new EngineNumber(BigDecimal.valueOf(this.simulationState.getCurrentYear()), "year");
            default -> this.scope.getVariable(name);
        };
    }

    @Override
    public void setVariable(String name, EngineNumber value) {
        if ("yearsElapsed".equals(name) || "yearAbsolute".equals(name)) {
            throw new RuntimeException("Cannot set yearsElapsed or yearAbsolute.");
        }
        this.scope.setVariable(name, value);
    }

    @Override
    public EngineNumber getInitialCharge(String stream) {
        if ("sales".equals(stream)) {
            try {
                return this.getSalesWeightedInitialCharge();
            }
            catch (IllegalStateException e) {
                return new EngineNumber(BigDecimal.ZERO, "kg / unit");
            }
        }
        return this.getRawInitialChargeFor(this.scope, stream);
    }

    private EngineNumber getSalesWeightedInitialCharge() {
        SalesStreamDistribution distribution = this.simulationState.getDistribution(this.scope, false);
        BigDecimal domesticWeight = distribution.getPercentDomestic();
        BigDecimal importWeight = distribution.getPercentImport();
        EngineNumber domesticInitialChargeRaw = this.getRawInitialChargeFor(this.scope, "domestic");
        EngineNumber domesticInitialCharge = this.unitConverter.convert(domesticInitialChargeRaw, "kg / unit");
        EngineNumber importInitialChargeRaw = this.getRawInitialChargeFor(this.scope, "import");
        EngineNumber importInitialCharge = this.unitConverter.convert(importInitialChargeRaw, "kg / unit");
        BigDecimal domesticWeighted = domesticInitialCharge.getValue().multiply(domesticWeight);
        BigDecimal importWeighted = importInitialCharge.getValue().multiply(importWeight);
        BigDecimal weightedSum = domesticWeighted.add(importWeighted);
        return new EngineNumber(weightedSum, "kg / unit");
    }

    @Override
    public EngineNumber getRawInitialChargeFor(UseKey useKey, String stream) {
        return this.simulationState.getInitialCharge(useKey, stream);
    }

    @Override
    public void setInitialCharge(EngineNumber value, String stream, YearMatcher yearMatcher) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        if ("sales".equals(stream)) {
            this.simulationState.setInitialCharge(this.scope, "domestic", value);
            this.simulationState.setInitialCharge(this.scope, "import", value);
        } else {
            this.simulationState.setInitialCharge(this.scope, stream, value);
        }
        boolean useExplicitRecharge = this.getShouldUseExplicitRecharge(stream);
        RecalcOperation operation = new RecalcOperationBuilder().setUseExplicitRecharge(useExplicitRecharge).setRecalcKit(this.createRecalcKit()).recalcPopulationChange().build();
        operation.execute(this);
    }

    private Optional<String> getLastSalesUnits(UseKey useKey) {
        EngineNumber lastValue = this.simulationState.getLastSpecifiedValue(useKey, "sales");
        return lastValue != null ? Optional.of(lastValue.getUnits()) : Optional.empty();
    }

    private boolean getShouldUseExplicitRecharge(String stream) {
        return switch (stream) {
            case "sales" -> {
                Optional<String> lastUnits = this.getLastSalesUnits(this.scope);
                if (lastUnits.isEmpty() || !lastUnits.get().startsWith("unit")) {
                    yield true;
                }
                yield false;
            }
            case "domestic", "import" -> {
                Optional<String> lastUnits = this.getLastSalesUnits(this.scope);
                if (!lastUnits.isPresent() || !lastUnits.get().startsWith("unit")) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @Override
    public EngineNumber getRechargeVolume() {
        return this.simulationState.getRechargePopulation(this.scope);
    }

    @Override
    public EngineNumber getRechargeIntensity() {
        return this.simulationState.getRechargeIntensity(this.scope);
    }

    @Override
    public void recharge(EngineNumber volume, EngineNumber intensity, YearMatcher yearMatcher) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        String application = this.scope.getApplication();
        String substance = this.scope.getSubstance();
        if (application == null || substance == null) {
            this.raiseNoAppOrSubstance("recalculating population change", " specified");
        }
        this.simulationState.accumulateRecharge(this.scope, volume, intensity);
        boolean isCarryOver = this.getIsCarryOver(this.scope);
        if (isCarryOver) {
            EngineNumber lastSalesValue = this.simulationState.getLastSpecifiedValue(this.scope, "sales");
            StreamUpdate update = new StreamUpdateBuilder().setName("sales").setValue(lastSalesValue).setKey(this.scope).build();
            this.executeStreamUpdate(update);
            return;
        }
        Optional<String> lastUnits = this.getLastSalesUnits(this.scope);
        boolean useExplicitRecharge = !lastUnits.isPresent() || !lastUnits.get().startsWith("unit");
        RecalcOperation operation = new RecalcOperationBuilder().setUseExplicitRecharge(useExplicitRecharge).setRecalcKit(this.createRecalcKit()).recalcPopulationChange().thenPropagateToSales().thenPropagateToConsumption().build();
        operation.execute(this);
        if (useExplicitRecharge) {
            SimulationStateUpdate clearImplicitRechargeStream = new SimulationStateUpdateBuilder().setUseKey(this.scope).setName("implicitRecharge").setValue(new EngineNumber(BigDecimal.ZERO, "kg")).setSubtractRecycling(false).build();
            this.simulationState.update(clearImplicitRechargeStream);
        }
    }

    @Override
    public void retire(EngineNumber amount, YearMatcher yearMatcher) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        this.simulationState.setRetirementRate(this.scope, amount);
        RecalcOperationBuilder builder = new RecalcOperationBuilder().setRecalcKit(this.createRecalcKit()).recalcRetire();
        if (this.hasUnitBasedSalesSpecifications()) {
            builder = builder.thenPropagateToSales();
        }
        RecalcOperation operation = builder.build();
        operation.execute(this);
    }

    @Override
    public EngineNumber getRetirementRate() {
        return this.simulationState.getRetirementRate(this.scope);
    }

    @Override
    public void recycle(EngineNumber recoveryWithUnits, EngineNumber yieldWithUnits, YearMatcher yearMatcher, RecoverOperation.RecoveryStage stage) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        this.simulationState.setRecoveryRate(this.scope, recoveryWithUnits, stage);
        this.simulationState.setYieldRate(this.scope, yieldWithUnits, stage);
        RecalcOperation operation = new RecalcOperationBuilder().setRecalcKit(this.createRecalcKit()).recalcSales().thenPropagateToPopulationChange().thenPropagateToConsumption().build();
        operation.execute(this);
    }

    @Override
    public void setInductionRate(EngineNumber inductionRate, RecoverOperation.RecoveryStage stage) {
        if (inductionRate != null) {
            if (!"%".equals(inductionRate.getUnits())) {
                throw new IllegalArgumentException("Induction rate must have percentage units, got: " + inductionRate.getUnits());
            }
            double ratePercent = inductionRate.getValue().doubleValue();
            if (ratePercent < 0.0 || ratePercent > 100.0) {
                throw new IllegalArgumentException("Induction rate must be between 0% and 100%, got: " + ratePercent + "%");
            }
            this.simulationState.setInductionRate(this.scope, inductionRate, stage);
        } else {
            this.resetInductionRate(stage);
        }
    }

    @Override
    public void resetInductionRate(RecoverOperation.RecoveryStage stage) {
        EngineNumber defaultInductionRate = new EngineNumber(new BigDecimal("100"), "%");
        this.simulationState.setInductionRate(this.scope, defaultInductionRate, stage);
    }

    @Override
    public void equals(EngineNumber amount, YearMatcher yearMatcher) {
        RecalcOperation operation;
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        String units = amount.getUnits();
        boolean isGhg = units.startsWith("tCO2e") || units.startsWith("kgCO2e");
        boolean isKwh = units.startsWith("kwh");
        if (isGhg) {
            this.simulationState.setGhgIntensity(this.scope, amount);
            operation = new RecalcOperationBuilder().setScopeEffective(this.scope).setRecalcKit(this.createRecalcKit()).recalcRechargeEmissions().thenPropagateToEolEmissions().build();
            operation.execute(this);
        } else if (isKwh) {
            this.simulationState.setEnergyIntensity(this.scope, amount);
        } else {
            throw new RuntimeException("Cannot equals " + amount.getUnits());
        }
        operation = new RecalcOperationBuilder().setRecalcKit(this.createRecalcKit()).recalcConsumption().build();
        operation.execute(this);
    }

    @Override
    public EngineNumber getGhgIntensity(UseKey useKey) {
        return this.simulationState.getGhgIntensity(useKey);
    }

    @Override
    public EngineNumber getEqualsGhgIntensity() {
        return this.simulationState.getGhgIntensity(this.scope);
    }

    @Override
    public EngineNumber getEqualsGhgIntensityFor(UseKey useKey) {
        return this.simulationState.getGhgIntensity(useKey);
    }

    @Override
    public EngineNumber getEqualsEnergyIntensity() {
        return this.simulationState.getEnergyIntensity(this.scope);
    }

    @Override
    public EngineNumber getEqualsEnergyIntensityFor(UseKey useKey) {
        return this.simulationState.getEnergyIntensity(useKey);
    }

    @Override
    public void changeStream(String stream, EngineNumber amount, YearMatcher yearMatcher) {
        this.changeStream(stream, amount, yearMatcher, null);
    }

    @Override
    public void changeStream(String stream, EngineNumber amount, YearMatcher yearMatcher, UseKey useKey) {
        if ("equipment".equals(stream)) {
            this.handleEquipmentChange(amount, yearMatcher);
            return;
        }
        UseKey useKeyEffective = useKey == null ? this.scope : useKey;
        this.changeExecutor.executeChange(stream, amount, yearMatcher, useKeyEffective);
    }

    private void handleEquipmentChange(EngineNumber amount, YearMatcher yearMatcher) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        this.equipmentChangeUtil.handleChange(amount);
    }

    @Override
    public void cap(String stream, EngineNumber amount, YearMatcher yearMatcher, String displaceTarget) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        if ("equipment".equals(stream)) {
            this.equipmentChangeUtil.handleCap(amount, displaceTarget);
            return;
        }
        this.limitExecutor.executeCap(stream, amount, yearMatcher, displaceTarget);
    }

    @Override
    public void floor(String stream, EngineNumber amount, YearMatcher yearMatcher, String displaceTarget) {
        if (!this.getIsInRange(yearMatcher)) {
            return;
        }
        if ("equipment".equals(stream)) {
            this.equipmentChangeUtil.handleFloor(amount, displaceTarget);
            return;
        }
        this.limitExecutor.executeFloor(stream, amount, yearMatcher, displaceTarget);
    }

    @Override
    public void replace(EngineNumber amountRaw, String stream, String destinationSubstance, YearMatcher yearMatcher) {
        this.replaceExecutor.execute(amountRaw, stream, destinationSubstance, yearMatcher);
    }

    @Override
    public List<EngineResult> getResults() {
        List<SubstanceInApplicationId> substances = this.simulationState.getRegisteredSubstances();
        EngineResultSerializer serializer = new EngineResultSerializer(this, this.stateGetter);
        return substances.stream().map(substanceId -> {
            String application = substanceId.getApplication();
            String substance = substanceId.getSubstance();
            int year = this.simulationState.getCurrentYear();
            return serializer.getResult(new SimpleUseKey(application, substance), year);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean getOptimizeRecalcs() {
        return true;
    }

    private boolean getIsInRange(YearMatcher yearMatcher) {
        return EngineSupportUtils.getIsInRange(yearMatcher, this.simulationState.getCurrentYear());
    }

    private boolean getIsInRange(Optional<YearMatcher> yearMatcher) {
        return EngineSupportUtils.getIsInRange(yearMatcher, this.simulationState.getCurrentYear());
    }

    private void raiseNoAppOrSubstance(String operation, String suffix) {
        ExceptionsGenerator.raiseNoAppOrSubstance(operation, suffix);
    }

    private RecalcKit createRecalcKit() {
        return new RecalcKitBuilder().setStreamKeeper(this.simulationState).setUnitConverter(this.unitConverter).setStateGetter(this.stateGetter).build();
    }

    private EngineNumber useIfZeroOrElse(EngineNumber branchVal, EngineNumber trueVal, EngineNumber falseVal) {
        boolean valueIsZero = this.isZero(branchVal);
        return valueIsZero ? trueVal : falseVal;
    }

    private boolean isZero(EngineNumber target) {
        return this.isZero(target.getValue());
    }

    private boolean isZero(BigDecimal target) {
        return target.compareTo(BigDecimal.ZERO) == 0;
    }

    private boolean getIsCarryOver(UseKey scope) {
        return !this.simulationState.isSalesIntentFreshlySet(scope) && EngineSupportUtils.hasUnitBasedSalesSpecifications(this.simulationState, scope);
    }

    private boolean hasUnitBasedSalesSpecifications() {
        return EngineSupportUtils.hasUnitBasedSalesSpecifications(this.simulationState, this.scope);
    }

    private BigDecimal calculateAvailableRecycling(UseKey scope) {
        EngineNumber priorPopulationRaw = this.simulationState.getStream(scope, "priorEquipment");
        if (priorPopulationRaw == null) {
            return BigDecimal.ZERO;
        }
        EngineNumber retirementRate = this.simulationState.getRetirementRate(scope);
        EngineNumber rechargePopulation = this.simulationState.getRechargePopulation(scope);
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this, "sales");
        EngineNumber priorPopulation = unitConverter.convert(priorPopulationRaw, "units");
        BigDecimal retirementRateDecimal = retirementRate.getValue().divide(BigDecimal.valueOf(100L));
        BigDecimal rechargePopulationDecimal = rechargePopulation.getValue().divide(BigDecimal.valueOf(100L));
        EngineNumber retiredPopulationRaw = this.simulationState.getStream(scope, "retired");
        EngineNumber retiredPopulation = unitConverter.convert(retiredPopulationRaw, "units");
        BigDecimal retiredUnits = retiredPopulation.getValue();
        BigDecimal eolRecycling = this.calculateRecyclingForStage(scope, retiredUnits, RecoverOperation.RecoveryStage.EOL, unitConverter);
        BigDecimal rechargedUnits = priorPopulation.getValue().multiply(rechargePopulationDecimal);
        BigDecimal rechargeRecycling = this.calculateRecyclingForStage(scope, rechargedUnits, RecoverOperation.RecoveryStage.RECHARGE, unitConverter);
        BigDecimal totalRecycling = eolRecycling.add(rechargeRecycling);
        return totalRecycling;
    }

    private BigDecimal calculateRecyclingForStage(UseKey scope, BigDecimal availableUnits, RecoverOperation.RecoveryStage stage, UnitConverter unitConverter) {
        EngineNumber recoveryRate = this.simulationState.getRecoveryRate(scope, stage);
        EngineNumber yieldRate = this.simulationState.getYieldRate(scope, stage);
        BigDecimal recoveryRateDecimal = recoveryRate.getValue().divide(BigDecimal.valueOf(100L));
        BigDecimal yieldRateDecimal = yieldRate.getValue().divide(BigDecimal.valueOf(100L));
        BigDecimal recoveredUnits = availableUnits.multiply(recoveryRateDecimal);
        BigDecimal recycledUnits = recoveredUnits.multiply(yieldRateDecimal);
        EngineNumber initialCharge = this.simulationState.getInitialCharge(scope, "import");
        EngineNumber initialChargeKg = unitConverter.convert(initialCharge, "kg / unit");
        BigDecimal recycledKg = recycledUnits.multiply(initialChargeKg.getValue());
        return recycledKg;
    }

    private void updateLastSpecifiedValueAfterRecycling() {
        EngineNumber currentImport;
        UnitConverter unitConverter;
        EngineNumber currentDomestic;
        boolean hasVolumeImport;
        EngineNumber lastDomestic = this.simulationState.getLastSpecifiedValue(this.scope, "domestic");
        EngineNumber lastImport = this.simulationState.getLastSpecifiedValue(this.scope, "import");
        boolean hasVolumeDomestic = lastDomestic != null && !lastDomestic.hasEquipmentUnits();
        boolean bl = hasVolumeImport = lastImport != null && !lastImport.hasEquipmentUnits();
        if (!hasVolumeDomestic && !hasVolumeImport) {
            return;
        }
        EngineNumber recycleAmount = this.getStream("recycle");
        if (recycleAmount == null || recycleAmount.getValue().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (hasVolumeDomestic && (currentDomestic = this.getStream("domestic")) != null) {
            unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this, "domestic");
            EngineNumber domesticInOriginalUnits = unitConverter.convert(currentDomestic, lastDomestic.getUnits());
            this.simulationState.setLastSpecifiedValue(this.scope, "domestic", domesticInOriginalUnits);
        }
        if (hasVolumeImport && (currentImport = this.getStream("import")) != null) {
            unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this, "import");
            EngineNumber importInOriginalUnits = unitConverter.convert(currentImport, lastImport.getUnits());
            this.simulationState.setLastSpecifiedValue(this.scope, "import", importInOriginalUnits);
        }
    }
}

