/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.ConsumptionCalculator;
import org.kigalisim.engine.support.ExceptionsGenerator;

public class ConsumptionRecalcStrategy
implements RecalcStrategy {
    private final Optional<UseKey> scope;

    public ConsumptionRecalcStrategy(Optional<UseKey> scope) {
        this.scope = scope;
    }

    @Override
    public void execute(Engine target, RecalcKit kit) {
        UseKey scopeEffective = this.scope.orElse(target.getScope());
        String application = scopeEffective.getApplication();
        String substance = scopeEffective.getSubstance();
        if (application == null || substance == null) {
            ExceptionsGenerator.raiseNoAppOrSubstance("recalculating consumption", "");
        }
        ConsumptionCalculator calculator = new ConsumptionCalculator();
        SimulationState simulationState = kit.getStreamKeeper();
        EngineNumber ghgIntensity = simulationState.getGhgIntensity(scopeEffective);
        calculator.setConsumptionRaw(ghgIntensity);
        calculator.setStreamName("consumption");
        calculator.execute(target);
    }
}

