/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.SimulationStateUpdateBuilder;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.ExceptionsGenerator;

public class EolEmissionsRecalcStrategy
implements RecalcStrategy {
    private final Optional<UseKey> scope;

    public EolEmissionsRecalcStrategy(Optional<UseKey> scope) {
        this.scope = scope;
    }

    @Override
    public void execute(Engine target, RecalcKit kit) {
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(kit.getStateGetter());
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        UseKey scopeEffective = this.scope.orElse(target.getScope());
        if (scopeEffective.getApplication() == null || scopeEffective.getSubstance() == null) {
            ExceptionsGenerator.raiseNoAppOrSubstance("recalculating EOL emissions change", "");
        }
        SimulationState simulationState = kit.getStreamKeeper();
        EngineNumber currentRetiredRaw = simulationState.getStream(scopeEffective, "retired");
        EngineNumber currentRetired = unitConverter.convert(currentRetiredRaw, "units");
        EngineNumber priorRetiredRaw = simulationState.getStream(scopeEffective, "priorRetired");
        EngineNumber priorRetired = unitConverter.convert(priorRetiredRaw, "units");
        BigDecimal amountRetiredThisYear = currentRetired.getValue().subtract(priorRetired.getValue());
        EngineNumber amount = new EngineNumber(amountRetiredThisYear, "units");
        EngineNumber eolGhg = unitConverter.convert(amount, "tCO2e");
        SimulationStateUpdate eolEmissionsStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("eolEmissions").setValue(eolGhg).setSubtractRecycling(false).build();
        simulationState.update(eolEmissionsStream);
    }
}

