/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.recalc.RechargeEmissionsRecalcStrategy;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.StateGetter;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.DivisionHelper;
import org.kigalisim.engine.support.ExceptionsGenerator;
import org.kigalisim.engine.support.RechargeVolumeCalculator;

public class PopulationChangeRecalcStrategy
implements RecalcStrategy {
    private final Optional<UseKey> scope;
    private final Optional<Boolean> useExplicitRecharge;

    public PopulationChangeRecalcStrategy(Optional<UseKey> scope, Optional<Boolean> useExplicitRecharge) {
        this.scope = scope;
        this.useExplicitRecharge = useExplicitRecharge;
    }

    @Override
    public void execute(Engine target, RecalcKit kit) {
        StateGetter baseStateGetter = kit.getStateGetter();
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(baseStateGetter);
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        UseKey scopeEffective = this.scope.orElse(target.getScope());
        boolean useExplicitRechargeEffective = this.useExplicitRecharge.orElse(true);
        String application = scopeEffective.getApplication();
        String substance = scopeEffective.getSubstance();
        if (application == null || substance == null) {
            ExceptionsGenerator.raiseNoAppOrSubstance("recalculating population change", "");
        }
        EngineNumber priorPopulationRaw = target.getStream("priorEquipment", Optional.of(scopeEffective), Optional.empty());
        EngineNumber priorPopulation = unitConverter.convert(priorPopulationRaw, "units");
        stateGetter.setPopulation(priorPopulation);
        EngineNumber substanceSalesRaw = target.getStream("sales", Optional.of(scopeEffective), Optional.empty());
        EngineNumber substanceSales = unitConverter.convert(substanceSalesRaw, "kg");
        EngineNumber explicitRechargeVolume = RechargeVolumeCalculator.calculateRechargeVolume(scopeEffective, kit.getStateGetter(), kit.getStreamKeeper(), target);
        EngineNumber implicitRechargeRaw = target.getStream("implicitRecharge", Optional.of(scopeEffective), Optional.empty());
        EngineNumber implicitRecharge = unitConverter.convert(implicitRechargeRaw, "kg");
        BigDecimal rechargeKg = useExplicitRechargeEffective ? explicitRechargeVolume.getValue() : implicitRecharge.getValue();
        BigDecimal salesKg = substanceSales.getValue();
        BigDecimal availableForNewUnitsKg = salesKg.subtract(rechargeKg);
        EngineNumber initialChargeRaw = target.getInitialCharge("sales");
        EngineNumber initialCharge = unitConverter.convert(initialChargeRaw, "kg / unit");
        BigDecimal initialChargeKgUnit = initialCharge.getValue();
        BigDecimal deltaUnits = DivisionHelper.divideWithZero(availableForNewUnitsKg, initialChargeKgUnit);
        EngineNumber newUnitsMarginal = new EngineNumber(deltaUnits, "units");
        BigDecimal priorPopulationUnits = priorPopulation.getValue();
        BigDecimal newUnits = priorPopulationUnits.add(deltaUnits);
        boolean newUnitsNegative = newUnits.compareTo(BigDecimal.ZERO) < 0;
        BigDecimal newUnitsAllowed = newUnitsNegative ? BigDecimal.ZERO : newUnits;
        EngineNumber newUnitsEffective = new EngineNumber(newUnitsAllowed, "units");
        StreamUpdate equipmentUpdate = new StreamUpdateBuilder().setName("equipment").setValue(newUnitsEffective).setKey(scopeEffective).setPropagateChanges(false).build();
        target.executeStreamUpdate(equipmentUpdate);
        StreamUpdate newEquipmentUpdate = new StreamUpdateBuilder().setName("newEquipment").setValue(newUnitsMarginal).setKey(scopeEffective).setPropagateChanges(false).build();
        target.executeStreamUpdate(newEquipmentUpdate);
        RechargeEmissionsRecalcStrategy rechargeStrategy = new RechargeEmissionsRecalcStrategy(Optional.of(scopeEffective));
        rechargeStrategy.execute(target, kit);
    }
}

