/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.util.Optional;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.StateGetter;

public class RecalcKitBuilder {
    private Optional<SimulationState> simulationState = Optional.empty();
    private Optional<UnitConverter> unitConverter = Optional.empty();
    private Optional<StateGetter> stateGetter = Optional.empty();

    public RecalcKitBuilder setStreamKeeper(SimulationState simulationState) {
        this.simulationState = Optional.of(simulationState);
        return this;
    }

    public RecalcKitBuilder setUnitConverter(UnitConverter unitConverter) {
        this.unitConverter = Optional.of(unitConverter);
        return this;
    }

    public RecalcKitBuilder setStateGetter(StateGetter stateGetter) {
        this.stateGetter = Optional.of(stateGetter);
        return this;
    }

    public RecalcKit build() {
        if (this.simulationState.isEmpty()) {
            throw new IllegalStateException("SimulationState is required");
        }
        if (this.unitConverter.isEmpty()) {
            throw new IllegalStateException("UnitConverter is required");
        }
        if (this.stateGetter.isEmpty()) {
            throw new IllegalStateException("StateGetter is required");
        }
        return new RecalcKit(this.simulationState.get(), this.unitConverter.get(), this.stateGetter.get());
    }
}

