/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.util.List;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;

public class RecalcOperation {
    private final List<RecalcStrategy> strategies;
    private final RecalcKit recalcKit;
    private final boolean shouldResetSalesIntent;

    public RecalcOperation(List<RecalcStrategy> strategies, RecalcKit recalcKit, boolean shouldResetSalesIntent) {
        if (recalcKit == null) {
            throw new IllegalArgumentException("RecalcKit is required");
        }
        this.strategies = strategies;
        this.recalcKit = recalcKit;
        this.shouldResetSalesIntent = shouldResetSalesIntent;
    }

    public void execute(Engine target) {
        for (RecalcStrategy strategy : this.strategies) {
            strategy.execute(target, this.recalcKit);
        }
        if (this.shouldResetSalesIntent) {
            target.getStreamKeeper().resetSalesIntentFlag(target.getScope());
        }
    }
}

