/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kigalisim.engine.recalc.ConsumptionRecalcStrategy;
import org.kigalisim.engine.recalc.EolEmissionsRecalcStrategy;
import org.kigalisim.engine.recalc.PopulationChangeRecalcStrategy;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcOperation;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.recalc.RechargeEmissionsRecalcStrategy;
import org.kigalisim.engine.recalc.RetireRecalcStrategy;
import org.kigalisim.engine.recalc.SalesRecalcStrategy;
import org.kigalisim.engine.state.UseKey;

public class RecalcOperationBuilder {
    private Optional<UseKey> scopeEffective = Optional.empty();
    private Optional<Boolean> useExplicitRecharge = Optional.empty();
    private Optional<RecalcKit> recalcKit = Optional.empty();
    private final List<RecalcStrategy> strategies = new ArrayList<RecalcStrategy>();
    private boolean hasInitialRecalc = false;
    private boolean includesSalesModification = false;

    public RecalcOperationBuilder setScopeEffective(UseKey scope) {
        this.scopeEffective = Optional.ofNullable(scope);
        return this;
    }

    public RecalcOperationBuilder setUseExplicitRecharge(Boolean useExplicitRecharge) {
        this.useExplicitRecharge = Optional.ofNullable(useExplicitRecharge);
        return this;
    }

    public RecalcOperationBuilder setRecalcKit(RecalcKit recalcKit) {
        this.recalcKit = Optional.ofNullable(recalcKit);
        return this;
    }

    public RecalcOperationBuilder recalcPopulationChange() {
        if (this.hasInitialRecalc) {
            throw new IllegalStateException("Only one recalc method can be called - use thenPropagate methods for subsequent operations");
        }
        this.strategies.add(new PopulationChangeRecalcStrategy(this.scopeEffective, this.useExplicitRecharge));
        this.hasInitialRecalc = true;
        return this;
    }

    public RecalcOperationBuilder recalcConsumption() {
        if (this.hasInitialRecalc) {
            throw new IllegalStateException("Only one recalc method can be called - use thenPropagate methods for subsequent operations");
        }
        this.strategies.add(new ConsumptionRecalcStrategy(this.scopeEffective));
        this.hasInitialRecalc = true;
        return this;
    }

    public RecalcOperationBuilder recalcSales() {
        if (this.hasInitialRecalc) {
            throw new IllegalStateException("Only one recalc method can be called - use thenPropagate methods for subsequent operations");
        }
        this.strategies.add(new SalesRecalcStrategy(this.scopeEffective));
        this.hasInitialRecalc = true;
        this.includesSalesModification = true;
        return this;
    }

    public RecalcOperationBuilder recalcRechargeEmissions() {
        if (this.hasInitialRecalc) {
            throw new IllegalStateException("Only one recalc method can be called - use thenPropagate methods for subsequent operations");
        }
        this.strategies.add(new RechargeEmissionsRecalcStrategy(this.scopeEffective));
        this.hasInitialRecalc = true;
        return this;
    }

    public RecalcOperationBuilder recalcEolEmissions() {
        if (this.hasInitialRecalc) {
            throw new IllegalStateException("Only one recalc method can be called - use thenPropagate methods for subsequent operations");
        }
        this.strategies.add(new EolEmissionsRecalcStrategy(this.scopeEffective));
        this.hasInitialRecalc = true;
        return this;
    }

    public RecalcOperationBuilder recalcRetire() {
        if (this.hasInitialRecalc) {
            throw new IllegalStateException("Only one recalc method can be called - use thenPropagate methods for subsequent operations");
        }
        this.strategies.add(new RetireRecalcStrategy(this.scopeEffective));
        this.hasInitialRecalc = true;
        return this;
    }

    public RecalcOperationBuilder thenPropagateToPopulationChange() {
        if (!this.hasInitialRecalc) {
            throw new IllegalStateException("Must call a recalc method before using thenPropagate methods");
        }
        PopulationChangeRecalcStrategy newStrategy = new PopulationChangeRecalcStrategy(this.scopeEffective, this.useExplicitRecharge);
        this.strategies.add(newStrategy);
        return this;
    }

    public RecalcOperationBuilder thenPropagateToConsumption() {
        if (!this.hasInitialRecalc) {
            throw new IllegalStateException("Must call a recalc method before using thenPropagate methods");
        }
        this.strategies.add(new ConsumptionRecalcStrategy(this.scopeEffective));
        return this;
    }

    public RecalcOperationBuilder thenPropagateToSales() {
        if (!this.hasInitialRecalc) {
            throw new IllegalStateException("Must call a recalc method before using thenPropagate methods");
        }
        this.strategies.add(new SalesRecalcStrategy(this.scopeEffective));
        this.includesSalesModification = true;
        return this;
    }

    public RecalcOperationBuilder thenPropagateToRechargeEmissions() {
        if (!this.hasInitialRecalc) {
            throw new IllegalStateException("Must call a recalc method before using thenPropagate methods");
        }
        this.strategies.add(new RechargeEmissionsRecalcStrategy(this.scopeEffective));
        return this;
    }

    public RecalcOperationBuilder thenPropagateToEolEmissions() {
        if (!this.hasInitialRecalc) {
            throw new IllegalStateException("Must call a recalc method before using thenPropagate methods");
        }
        this.strategies.add(new EolEmissionsRecalcStrategy(this.scopeEffective));
        return this;
    }

    public RecalcOperationBuilder thenPropagateToRetire() {
        if (!this.hasInitialRecalc) {
            throw new IllegalStateException("Must call a recalc method before using thenPropagate methods");
        }
        this.strategies.add(new RetireRecalcStrategy(this.scopeEffective));
        return this;
    }

    public RecalcOperation build() {
        if (this.strategies.isEmpty()) {
            throw new IllegalStateException("Must configure at least one recalculation strategy");
        }
        if (!this.recalcKit.isPresent()) {
            throw new IllegalStateException("RecalcKit is required");
        }
        return new RecalcOperation(new ArrayList<RecalcStrategy>(this.strategies), this.recalcKit.get(), this.includesSalesModification);
    }
}

