/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.RechargeVolumeCalculator;

public class RechargeEmissionsRecalcStrategy
implements RecalcStrategy {
    private final Optional<UseKey> scope;

    public RechargeEmissionsRecalcStrategy(Optional<UseKey> scope) {
        this.scope = scope;
    }

    @Override
    public void execute(Engine target, RecalcKit kit) {
        UseKey scopeEffective = this.scope.orElse(target.getScope());
        EngineNumber rechargeVolume = RechargeVolumeCalculator.calculateRechargeVolume(scopeEffective, kit.getStateGetter(), kit.getStreamKeeper(), target);
        UnitConverter unitConverter = kit.getUnitConverter();
        EngineNumber rechargeGhg = unitConverter.convert(rechargeVolume, "tCO2e");
        StreamUpdate update = new StreamUpdateBuilder().setName("rechargeEmissions").setValue(rechargeGhg).setKey(scopeEffective).setPropagateChanges(false).build();
        target.executeStreamUpdate(update);
    }
}

