/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.ConsumptionRecalcStrategy;
import org.kigalisim.engine.recalc.EolEmissionsRecalcStrategy;
import org.kigalisim.engine.recalc.PopulationChangeRecalcStrategy;
import org.kigalisim.engine.recalc.PostRetireNewLevels;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.recalc.RetireBackgroundInfo;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.SimulationStateUpdateBuilder;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.ExceptionsGenerator;

public class RetireRecalcStrategy
implements RecalcStrategy {
    private final Optional<UseKey> scope;

    public RetireRecalcStrategy(Optional<UseKey> scope) {
        this.scope = scope;
    }

    private RetireBackgroundInfo getCurrentState(UseKey scopeEffective, SimulationState simulationState, UnitConverter unitConverter) {
        EngineNumber basePopulation;
        boolean firstRetire;
        EngineNumber currentPriorRaw = simulationState.getStream(scopeEffective, "priorEquipment");
        EngineNumber currentPrior = unitConverter.convert(currentPriorRaw, "units");
        EngineNumber currentEquipmentRaw = simulationState.getStream(scopeEffective, "equipment");
        EngineNumber currentEquipment = unitConverter.convert(currentEquipmentRaw, "units");
        EngineNumber currentRetiredRaw = simulationState.getStream(scopeEffective, "retired");
        EngineNumber currentRetired = unitConverter.convert(currentRetiredRaw, "units");
        Optional<EngineNumber> basePopulationOpt = simulationState.getRetirementBasePopulation(scopeEffective);
        boolean bl = firstRetire = !basePopulationOpt.isPresent();
        if (firstRetire) {
            basePopulation = currentPrior;
            simulationState.setRetirementBasePopulation(scopeEffective, basePopulation);
        } else {
            basePopulation = basePopulationOpt.get();
        }
        return new RetireBackgroundInfo(currentPrior, currentEquipment, currentRetired, basePopulation, firstRetire);
    }

    private EngineNumber calculateDelta(UseKey scopeEffective, SimulationState simulationState, UnitConverter unitConverter, OverridingConverterStateGetter stateGetter, RetireBackgroundInfo backgroundInfo) {
        EngineNumber cumulativeRateRaw = simulationState.getRetirementRate(scopeEffective);
        stateGetter.setPopulation(backgroundInfo.getBasePopulation());
        EngineNumber cumulativeAmount = unitConverter.convert(cumulativeRateRaw, "units");
        stateGetter.clearPopulation();
        Optional<EngineNumber> appliedAmountOpt = simulationState.getAppliedRetirementAmount(scopeEffective);
        EngineNumber appliedAmount = appliedAmountOpt.orElse(new EngineNumber(BigDecimal.ZERO, "units"));
        BigDecimal deltaValue = cumulativeAmount.getValue().subtract(appliedAmount.getValue());
        EngineNumber delta = new EngineNumber(deltaValue, "units");
        return delta;
    }

    private PostRetireNewLevels calculateNewLevels(EngineNumber delta, RetireBackgroundInfo backgroundInfo) {
        BigDecimal newPriorValue = backgroundInfo.getCurrentPrior().getValue().subtract(delta.getValue());
        BigDecimal newEquipmentValue = backgroundInfo.getCurrentEquipment().getValue().subtract(delta.getValue());
        BigDecimal newRetiredValue = backgroundInfo.getCurrentRetired().getValue().add(delta.getValue());
        EngineNumber newPrior = new EngineNumber(newPriorValue, "units");
        EngineNumber newEquipment = new EngineNumber(newEquipmentValue, "units");
        EngineNumber newRetired = new EngineNumber(newRetiredValue, "units");
        return new PostRetireNewLevels(newPrior, newEquipment, newRetired);
    }

    private void updateEquipmentStreams(UseKey scopeEffective, SimulationState simulationState, PostRetireNewLevels newLevels) {
        SimulationStateUpdate priorEquipmentStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("priorEquipment").setValue(newLevels.getNewPrior()).setSubtractRecycling(false).setInvalidatePriorEquipment(false).build();
        simulationState.update(priorEquipmentStream);
        SimulationStateUpdate equipmentStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("equipment").setValue(newLevels.getNewEquipment()).setSubtractRecycling(false).build();
        simulationState.update(equipmentStream);
    }

    private void updateRetiredStream(UseKey scopeEffective, SimulationState simulationState, PostRetireNewLevels newLevels) {
        SimulationStateUpdate retiredStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("retired").setValue(newLevels.getNewRetired()).setSubtractRecycling(false).build();
        simulationState.update(retiredStream);
    }

    private void updateGhgAccounting(Engine target, UseKey scopeEffective, RecalcKit kit) {
        EolEmissionsRecalcStrategy eolStrategy = new EolEmissionsRecalcStrategy(Optional.of(scopeEffective));
        eolStrategy.execute(target, kit);
    }

    private void propagateChanges(Engine target, RecalcKit kit) {
        PopulationChangeRecalcStrategy populationStrategy = new PopulationChangeRecalcStrategy(Optional.empty(), Optional.empty());
        populationStrategy.execute(target, kit);
        ConsumptionRecalcStrategy consumptionStrategy = new ConsumptionRecalcStrategy(Optional.empty());
        consumptionStrategy.execute(target, kit);
    }

    @Override
    public void execute(Engine target, RecalcKit kit) {
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(kit.getStateGetter());
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        UseKey scopeEffective = this.scope.orElse(target.getScope());
        String application = scopeEffective.getApplication();
        String substance = scopeEffective.getSubstance();
        if (application == null || substance == null) {
            ExceptionsGenerator.raiseNoAppOrSubstance("recalculating population change", "");
        }
        SimulationState simulationState = kit.getStreamKeeper();
        RetireBackgroundInfo backgroundInfo = this.getCurrentState(scopeEffective, simulationState, unitConverter);
        EngineNumber delta = this.calculateDelta(scopeEffective, simulationState, unitConverter, stateGetter, backgroundInfo);
        PostRetireNewLevels newLevels = this.calculateNewLevels(delta, backgroundInfo);
        this.updateEquipmentStreams(scopeEffective, simulationState, newLevels);
        this.updateRetiredStream(scopeEffective, simulationState, newLevels);
        EngineNumber cumulativeRateRaw = simulationState.getRetirementRate(scopeEffective);
        stateGetter.setPopulation(backgroundInfo.getBasePopulation());
        EngineNumber cumulativeAmount = unitConverter.convert(cumulativeRateRaw, "units");
        stateGetter.clearPopulation();
        simulationState.setAppliedRetirementAmount(scopeEffective, cumulativeAmount);
        this.updateGhgAccounting(target, scopeEffective, kit);
        this.propagateChanges(target, kit);
    }
}

