/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcStrategy;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.SimulationStateUpdateBuilder;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.ExceptionsGenerator;
import org.kigalisim.lang.operation.RecoverOperation;

public class SalesRecalcStrategy
implements RecalcStrategy {
    private final Optional<UseKey> scope;

    public SalesRecalcStrategy(Optional<UseKey> scope) {
        this.scope = scope;
    }

    @Override
    public void execute(Engine target, RecalcKit kit) {
        UseKey scopeEffective = this.scope.orElse(target.getScope());
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(kit.getStateGetter());
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        if (scopeEffective.getApplication() == null || scopeEffective.getSubstance() == null) {
            ExceptionsGenerator.raiseNoAppOrSubstance("recalculating sales", "");
        }
        SimulationState simulationState = kit.getStreamKeeper();
        EngineNumber rechargeBase = this.initializeRechargeBase(scopeEffective, simulationState, unitConverter, target);
        EngineNumber rechargeVolume = this.calculateTotalRecharge(scopeEffective, simulationState, stateGetter, unitConverter, rechargeBase);
        EngineNumber initialChargeRaw = target.getInitialCharge("sales");
        EngineNumber initialCharge = unitConverter.convert(initialChargeRaw, "kg / unit");
        EngineNumber eolVolumeConverted = this.calculateEolRecyclingVolume(scopeEffective, simulationState, stateGetter, unitConverter, initialCharge);
        BigDecimal eolRecycledKg = this.calculateRecyclingForStage(simulationState, stateGetter, unitConverter, scopeEffective, eolVolumeConverted, RecoverOperation.RecoveryStage.EOL);
        BigDecimal rechargeRecycledKg = this.calculateRecyclingForStage(simulationState, stateGetter, unitConverter, scopeEffective, rechargeVolume, RecoverOperation.RecoveryStage.RECHARGE);
        stateGetter.clearPopulation();
        EngineNumber volumeForNew = this.calculateNewEquipmentNeeds(stateGetter, unitConverter, kit.getUnitConverter(), initialCharge);
        EngineNumber priorPopulationRaw = target.getStream("priorEquipment", Optional.of(scopeEffective), Optional.empty());
        EngineNumber priorPopulation = unitConverter.convert(priorPopulationRaw, "units");
        stateGetter.setPopulation(priorPopulation);
        stateGetter.clearAmortizedUnitVolume();
        stateGetter.clearVolume();
        SalesStreamDistribution distribution = simulationState.getDistribution(scopeEffective);
        this.updateRecyclingStreams(scopeEffective, simulationState, eolRecycledKg, rechargeRecycledKg);
        EngineNumber implicitRechargeRaw = target.getStream("implicitRecharge", Optional.of(scopeEffective), Optional.empty());
        EngineNumber implicitRecharge = unitConverter.convert(implicitRechargeRaw, "kg");
        BigDecimal implicitRechargeKg = implicitRecharge.getValue();
        BigDecimal requiredKg = this.calculateTotalDemand(rechargeVolume, volumeForNew, implicitRechargeKg);
        boolean hasUnitBasedSpecs = this.getHasUnitBasedSpecs(simulationState, scopeEffective, implicitRechargeKg);
        BigDecimal totalRequiredKg = this.calculateRequiredVirginMaterial(requiredKg, eolRecycledKg, rechargeRecycledKg, simulationState, scopeEffective, hasUnitBasedSpecs);
        BigDecimal newDomesticKg = distribution.getPercentDomestic().multiply(totalRequiredKg);
        BigDecimal newImportKg = distribution.getPercentImport().multiply(totalRequiredKg);
        this.updateSalesStreams(target, scopeEffective, newDomesticKg, newImportKg, distribution, hasUnitBasedSpecs, initialCharge, stateGetter, unitConverter);
    }

    private boolean getHasUnitBasedSpecs(SimulationState simulationState, UseKey scopeEffective, BigDecimal implicitRechargeKg) {
        boolean hasUnitBasedSpecs = EngineSupportUtils.hasUnitBasedSalesSpecifications(simulationState, scopeEffective);
        return hasUnitBasedSpecs ? implicitRechargeKg.compareTo(BigDecimal.ZERO) > 0 : false;
    }

    private BigDecimal calculateRecyclingForStage(SimulationState simulationState, OverridingConverterStateGetter stateGetter, UnitConverter unitConverter, UseKey scopeEffective, EngineNumber baseVolume, RecoverOperation.RecoveryStage stage) {
        stateGetter.setVolume(baseVolume);
        EngineNumber recoveryVolumeRaw = simulationState.getRecoveryRate(scopeEffective, stage);
        EngineNumber recoveryVolume = unitConverter.convert(recoveryVolumeRaw, "kg");
        stateGetter.clearVolume();
        stateGetter.setVolume(recoveryVolume);
        EngineNumber recycledVolumeRaw = simulationState.getYieldRate(scopeEffective, stage);
        EngineNumber recycledVolume = unitConverter.convert(recycledVolumeRaw, "kg");
        stateGetter.clearVolume();
        return recycledVolume.getValue();
    }

    private BigDecimal getEffectiveInductionRate(SimulationState simulationState, UseKey scopeEffective, RecoverOperation.RecoveryStage stage, boolean hasUnitBasedSpecs) {
        boolean wasExplicitlySet;
        EngineNumber inductionRate = simulationState.getInductionRate(scopeEffective, stage);
        boolean bl = wasExplicitlySet = inductionRate != null;
        if (wasExplicitlySet) {
            return inductionRate.getValue().divide(BigDecimal.valueOf(100L), MathContext.DECIMAL128);
        }
        if (hasUnitBasedSpecs) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.ONE;
    }

    private EngineNumber initializeRechargeBase(UseKey scopeEffective, SimulationState simulationState, UnitConverter unitConverter, Engine target) {
        EngineNumber rechargeBase;
        boolean firstRecharge;
        Optional<EngineNumber> rechargeBaseOpt = simulationState.getRechargeBasePopulation(scopeEffective);
        boolean bl = firstRecharge = !rechargeBaseOpt.isPresent();
        if (firstRecharge) {
            EngineNumber currentPriorRaw = target.getStream("priorEquipment", Optional.of(scopeEffective), Optional.empty());
            EngineNumber currentPrior = unitConverter.convert(currentPriorRaw, "units");
            simulationState.setRechargeBasePopulation(scopeEffective, currentPrior);
            rechargeBase = currentPrior;
        } else {
            rechargeBase = rechargeBaseOpt.get();
        }
        return rechargeBase;
    }

    private EngineNumber calculateTotalRecharge(UseKey scopeEffective, SimulationState simulationState, OverridingConverterStateGetter stateGetter, UnitConverter unitConverter, EngineNumber rechargeBase) {
        stateGetter.setPopulation(rechargeBase);
        EngineNumber rechargePopRaw = simulationState.getRechargePopulation(scopeEffective);
        EngineNumber totalRechargeUnits = unitConverter.convert(rechargePopRaw, "units");
        stateGetter.clearPopulation();
        stateGetter.setPopulation(totalRechargeUnits);
        EngineNumber rechargeIntensityRaw = simulationState.getRechargeIntensity(scopeEffective);
        EngineNumber totalRechargeVolume = unitConverter.convert(rechargeIntensityRaw, "kg");
        return totalRechargeVolume;
    }

    private EngineNumber calculateEolRecyclingVolume(UseKey scopeEffective, SimulationState simulationState, OverridingConverterStateGetter stateGetter, UnitConverter unitConverter, EngineNumber initialCharge) {
        EngineNumber retiredPopulationRaw = simulationState.getStream(scopeEffective, "retired");
        EngineNumber retiredPopulation = unitConverter.convert(retiredPopulationRaw, "units");
        stateGetter.setPopulation(retiredPopulation);
        EngineNumber eolVolumeRaw = simulationState.getStream(scopeEffective, "retired");
        EngineNumber eolVolume = unitConverter.convert(eolVolumeRaw, "kg");
        BigDecimal eolVolumeKg = retiredPopulation.getValue().multiply(initialCharge.getValue());
        EngineNumber eolVolumeConverted = new EngineNumber(eolVolumeKg, "kg");
        stateGetter.clearPopulation();
        return eolVolumeConverted;
    }

    private EngineNumber calculateNewEquipmentNeeds(OverridingConverterStateGetter stateGetter, UnitConverter unitConverter, UnitConverter converter, EngineNumber initialCharge) {
        stateGetter.setAmortizedUnitVolume(initialCharge);
        EngineNumber populationChangeRaw = stateGetter.getPopulationChange(converter);
        EngineNumber populationChange = unitConverter.convert(populationChangeRaw, "units");
        EngineNumber volumeForNew = unitConverter.convert(populationChange, "kg");
        return volumeForNew;
    }

    private void updateRecyclingStreams(UseKey scopeEffective, SimulationState simulationState, BigDecimal eolRecycledKg, BigDecimal rechargeRecycledKg) {
        EngineNumber newRecycleEolValue = new EngineNumber(eolRecycledKg, "kg");
        EngineNumber newRecycleRechargeValue = new EngineNumber(rechargeRecycledKg, "kg");
        SimulationStateUpdate recycleEolStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("recycleEol").setValue(newRecycleEolValue).setSubtractRecycling(false).build();
        simulationState.update(recycleEolStream);
        SimulationStateUpdate recycleRechargeStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("recycleRecharge").setValue(newRecycleRechargeValue).setSubtractRecycling(false).build();
        simulationState.update(recycleRechargeStream);
        BigDecimal recycledKg = eolRecycledKg.add(rechargeRecycledKg);
        EngineNumber newRecycleValue = new EngineNumber(recycledKg, "kg");
        SimulationStateUpdate recycleStream = new SimulationStateUpdateBuilder().setUseKey(scopeEffective).setName("recycle").setValue(newRecycleValue).setSubtractRecycling(false).build();
        simulationState.update(recycleStream);
    }

    private BigDecimal calculateTotalDemand(EngineNumber rechargeVolume, EngineNumber newEquipmentVolume, BigDecimal implicitRechargeKg) {
        BigDecimal totalDemand = rechargeVolume.getValue().add(newEquipmentVolume.getValue());
        BigDecimal requiredKg = totalDemand.subtract(implicitRechargeKg);
        return requiredKg;
    }

    private BigDecimal calculateRequiredVirginMaterial(BigDecimal totalDemand, BigDecimal eolRecycledKg, BigDecimal rechargeRecycledKg, SimulationState simulationState, UseKey scopeEffective, boolean hasUnitBasedSpecs) {
        BigDecimal totalRequiredKg;
        if (hasUnitBasedSpecs) {
            BigDecimal inductionRatioEol = this.getEffectiveInductionRate(simulationState, scopeEffective, RecoverOperation.RecoveryStage.EOL, hasUnitBasedSpecs);
            BigDecimal inductionRatioRecharge = this.getEffectiveInductionRate(simulationState, scopeEffective, RecoverOperation.RecoveryStage.RECHARGE, hasUnitBasedSpecs);
            BigDecimal eolInducedKg = eolRecycledKg.multiply(inductionRatioEol);
            BigDecimal rechargeInducedKg = rechargeRecycledKg.multiply(inductionRatioRecharge);
            BigDecimal inducedDemandKg = eolInducedKg.add(rechargeInducedKg);
            totalRequiredKg = totalDemand.add(inducedDemandKg);
        } else {
            BigDecimal inductionRatioEol = this.getEffectiveInductionRate(simulationState, scopeEffective, RecoverOperation.RecoveryStage.EOL, hasUnitBasedSpecs);
            BigDecimal inductionRatioRecharge = this.getEffectiveInductionRate(simulationState, scopeEffective, RecoverOperation.RecoveryStage.RECHARGE, hasUnitBasedSpecs);
            BigDecimal totalRecycledKg = eolRecycledKg.add(rechargeRecycledKg);
            totalRequiredKg = totalDemand.subtract(totalRecycledKg);
            BigDecimal eolInducedKg = eolRecycledKg.multiply(inductionRatioEol);
            BigDecimal rechargeInducedKg = rechargeRecycledKg.multiply(inductionRatioRecharge);
            BigDecimal totalInducedKg = eolInducedKg.add(rechargeInducedKg);
            totalRequiredKg = totalRequiredKg.add(totalInducedKg);
            totalRequiredKg = totalRequiredKg.max(BigDecimal.ZERO);
        }
        return totalRequiredKg;
    }

    private void updateSalesStreams(Engine target, UseKey scopeEffective, BigDecimal domesticKg, BigDecimal importKg, SalesStreamDistribution distribution, boolean hasUnitBasedSpecs, EngineNumber initialCharge, OverridingConverterStateGetter stateGetter, UnitConverter unitConverter) {
        boolean hasImports;
        boolean hasDomestic = distribution.getPercentDomestic().compareTo(BigDecimal.ZERO) > 0;
        boolean bl = hasImports = distribution.getPercentImport().compareTo(BigDecimal.ZERO) > 0;
        if (hasUnitBasedSpecs) {
            stateGetter.setAmortizedUnitVolume(initialCharge);
            if (hasDomestic) {
                EngineNumber newDomesticUnits = unitConverter.convert(new EngineNumber(domesticKg, "kg"), "units");
                StreamUpdate domesticUpdate = new StreamUpdateBuilder().setName("domestic").setValue(newDomesticUnits).setKey(scopeEffective).setPropagateChanges(false).setSubtractRecycling(hasUnitBasedSpecs).setDistribution(distribution).build();
                target.executeStreamUpdate(domesticUpdate);
            }
            if (hasImports) {
                EngineNumber newImportUnits = unitConverter.convert(new EngineNumber(importKg, "kg"), "units");
                StreamUpdate importUpdate = new StreamUpdateBuilder().setName("import").setValue(newImportUnits).setKey(scopeEffective).setPropagateChanges(false).setSubtractRecycling(hasUnitBasedSpecs).setDistribution(distribution).build();
                target.executeStreamUpdate(importUpdate);
            }
            stateGetter.clearAmortizedUnitVolume();
        } else {
            if (hasDomestic) {
                EngineNumber newDomestic = new EngineNumber(domesticKg, "kg");
                StreamUpdate domesticUpdate = new StreamUpdateBuilder().setName("domestic").setValue(newDomestic).setKey(scopeEffective).setPropagateChanges(false).setSubtractRecycling(hasUnitBasedSpecs).setDistribution(distribution).build();
                target.executeStreamUpdate(domesticUpdate);
            }
            if (hasImports) {
                EngineNumber newImport = new EngineNumber(importKg, "kg");
                StreamUpdate importUpdate = new StreamUpdateBuilder().setName("import").setValue(newImport).setKey(scopeEffective).setPropagateChanges(false).setSubtractRecycling(hasUnitBasedSpecs).setDistribution(distribution).build();
                target.executeStreamUpdate(importUpdate);
            }
        }
    }
}

