/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.recalc.SalesStreamDistribution;

public class SalesStreamDistributionBuilder {
    private Optional<EngineNumber> domesticSales = Optional.empty();
    private Optional<EngineNumber> importSales = Optional.empty();
    private Optional<EngineNumber> exportSales = Optional.empty();
    private Optional<Boolean> domesticEnabled = Optional.empty();
    private Optional<Boolean> importEnabled = Optional.empty();
    private Optional<Boolean> exportEnabled = Optional.empty();
    private Optional<Boolean> includeExports = Optional.empty();

    public SalesStreamDistributionBuilder setDomesticSales(EngineNumber domesticSales) {
        this.domesticSales = Optional.of(domesticSales);
        return this;
    }

    public SalesStreamDistributionBuilder setImportSales(EngineNumber importSales) {
        this.importSales = Optional.of(importSales);
        return this;
    }

    public SalesStreamDistributionBuilder setDomesticEnabled(boolean domesticEnabled) {
        this.domesticEnabled = Optional.of(domesticEnabled);
        return this;
    }

    public SalesStreamDistributionBuilder setImportEnabled(boolean importEnabled) {
        this.importEnabled = Optional.of(importEnabled);
        return this;
    }

    public SalesStreamDistributionBuilder setExportSales(EngineNumber exportSales) {
        this.exportSales = Optional.of(exportSales);
        return this;
    }

    public SalesStreamDistributionBuilder setExportEnabled(boolean exportEnabled) {
        this.exportEnabled = Optional.of(exportEnabled);
        return this;
    }

    public SalesStreamDistributionBuilder setIncludeExports(boolean includeExports) {
        this.includeExports = Optional.of(includeExports);
        return this;
    }

    public SalesStreamDistribution build() {
        this.checkReadyToConstruct();
        BigDecimal domesticSalesKg = this.domesticSales.get().getValue();
        BigDecimal importSalesKg = this.importSales.get().getValue();
        BigDecimal exportSalesKg = this.exportSales.get().getValue();
        boolean includeExportsFlag = this.includeExports.get();
        if (!includeExportsFlag) {
            BigDecimal totalSalesKg = domesticSalesKg.add(importSalesKg);
            if (totalSalesKg.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal percentDomestic = domesticSalesKg.divide(totalSalesKg, MathContext.DECIMAL128);
                BigDecimal percentImport = importSalesKg.divide(totalSalesKg, MathContext.DECIMAL128);
                return new SalesStreamDistribution(percentDomestic, percentImport, BigDecimal.ZERO);
            }
            if (this.domesticEnabled.get().booleanValue() && !this.importEnabled.get().booleanValue()) {
                return new SalesStreamDistribution(BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
            }
            if (this.importEnabled.get().booleanValue() && !this.domesticEnabled.get().booleanValue()) {
                return new SalesStreamDistribution(BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO);
            }
            if (this.domesticEnabled.get().booleanValue() && this.importEnabled.get().booleanValue()) {
                return new SalesStreamDistribution(new BigDecimal("0.5"), new BigDecimal("0.5"), BigDecimal.ZERO);
            }
            throw new IllegalStateException("Cannot calculate sales distribution: no streams have been enabled. Use 'set import' or 'set domestic' statements to enable streams before operations like 'recharge' that require sales recalculation.");
        }
        BigDecimal totalSalesKg = domesticSalesKg.add(importSalesKg).add(exportSalesKg);
        if (totalSalesKg.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal percentDomestic = domesticSalesKg.divide(totalSalesKg, MathContext.DECIMAL128);
            BigDecimal percentImport = importSalesKg.divide(totalSalesKg, MathContext.DECIMAL128);
            BigDecimal percentExport = exportSalesKg.divide(totalSalesKg, MathContext.DECIMAL128);
            return new SalesStreamDistribution(percentDomestic, percentImport, percentExport);
        }
        int enabledCount = 0;
        if (this.domesticEnabled.get().booleanValue()) {
            ++enabledCount;
        }
        if (this.importEnabled.get().booleanValue()) {
            ++enabledCount;
        }
        if (this.exportEnabled.get().booleanValue()) {
            ++enabledCount;
        }
        if (enabledCount == 0) {
            throw new IllegalStateException("Cannot calculate sales distribution: no streams have been enabled. Use 'set import', 'set domestic', or 'set export' statements to enable streams before operations like 'recharge' that require sales recalculation.");
        }
        BigDecimal equalShare = BigDecimal.ONE.divide(BigDecimal.valueOf(enabledCount), MathContext.DECIMAL128);
        return new SalesStreamDistribution(this.domesticEnabled.get() != false ? equalShare : BigDecimal.ZERO, this.importEnabled.get() != false ? equalShare : BigDecimal.ZERO, this.exportEnabled.get() != false ? equalShare : BigDecimal.ZERO);
    }

    private void checkReadyToConstruct() {
        this.checkValid(this.domesticSales, "domesticSales");
        this.checkValid(this.importSales, "importSales");
        this.checkValid(this.exportSales, "exportSales");
        this.checkValid(this.domesticEnabled, "domesticEnabled");
        this.checkValid(this.importEnabled, "importEnabled");
        this.checkValid(this.exportEnabled, "exportEnabled");
        this.checkValid(this.includeExports, "includeExports");
    }

    private void checkValid(Optional<?> value, String name) {
        if (value.isEmpty()) {
            throw new IllegalStateException("Could not make sales stream distribution because " + name + " was not given.");
        }
    }
}

