/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.recalc;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;

public final class StreamUpdateBuilder {
    private String name;
    private EngineNumber value;
    private Optional<YearMatcher> yearMatcher = Optional.empty();
    private Optional<UseKey> key = Optional.empty();
    private boolean propagateChanges = true;
    private Optional<String> unitsToRecord = Optional.empty();
    private boolean subtractRecycling = true;
    private boolean forceUseFullRecharge = false;
    private Optional<SalesStreamDistribution> distribution = Optional.empty();

    public StreamUpdateBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public StreamUpdateBuilder setValue(EngineNumber value) {
        this.value = value;
        return this;
    }

    public StreamUpdateBuilder setYearMatcher(Optional<YearMatcher> yearMatcher) {
        this.yearMatcher = yearMatcher;
        return this;
    }

    public StreamUpdateBuilder setKey(UseKey key) {
        this.key = Optional.of(key);
        return this;
    }

    public StreamUpdateBuilder clearKey() {
        this.key = Optional.empty();
        return this;
    }

    public StreamUpdateBuilder setPropagateChanges(boolean propagateChanges) {
        this.propagateChanges = propagateChanges;
        return this;
    }

    public StreamUpdateBuilder setUnitsToRecord(String unitsToRecord) {
        this.unitsToRecord = Optional.of(unitsToRecord);
        return this;
    }

    public StreamUpdateBuilder clearUnitsToRecord() {
        this.unitsToRecord = Optional.empty();
        return this;
    }

    public StreamUpdateBuilder setSubtractRecycling(boolean subtractRecycling) {
        this.subtractRecycling = subtractRecycling;
        return this;
    }

    public StreamUpdateBuilder setForceUseFullRecharge(boolean forceUseFullRecharge) {
        this.forceUseFullRecharge = forceUseFullRecharge;
        return this;
    }

    public StreamUpdateBuilder setDistribution(SalesStreamDistribution distribution) {
        this.distribution = Optional.of(distribution);
        return this;
    }

    public StreamUpdateBuilder clearDistribution() {
        this.distribution = Optional.empty();
        return this;
    }

    public StreamUpdateBuilder inferSubtractRecycling() {
        if (this.name == null || this.value == null) {
            throw new RuntimeException("Name and value must be set before calling inferSubtractRecycling");
        }
        boolean subtractRecycling = !EngineSupportUtils.isSalesSubstream(this.name) || "units".equals(this.value.getUnits());
        return this.setSubtractRecycling(subtractRecycling);
    }

    public StreamUpdate build() {
        if (this.name == null || this.value == null) {
            throw new IllegalStateException("Name and value are required");
        }
        return new StreamUpdate(this.name, this.value, this.yearMatcher, this.key, this.propagateChanges, this.unitsToRecord, this.subtractRecycling, this.forceUseFullRecharge, this.distribution);
    }
}

