/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.serializer;

import java.math.BigDecimal;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.serializer.EngineResultBuilder;
import org.kigalisim.engine.serializer.TradeSupplement;

public class EngineResult {
    private final String application;
    private final String substance;
    private final int year;
    private final String scenarioName;
    private final int trialNumber;
    private final EngineNumber domesticValue;
    private final EngineNumber importValue;
    private final EngineNumber recycleValue;
    private final EngineNumber domesticConsumptionValue;
    private final EngineNumber importConsumptionValue;
    private final EngineNumber recycleConsumptionValue;
    private final EngineNumber populationValue;
    private final EngineNumber populationNew;
    private final EngineNumber rechargeEmissions;
    private final EngineNumber eolEmissions;
    private final EngineNumber initialChargeEmissions;
    private final EngineNumber energyConsumption;
    private final EngineNumber exportValue;
    private final EngineNumber exportConsumptionValue;
    private final TradeSupplement tradeSupplement;
    private final EngineNumber bankKg;
    private final EngineNumber bankTco2e;
    private final EngineNumber bankChangeKg;
    private final EngineNumber bankChangeTco2e;

    public EngineResult(EngineResultBuilder builder) {
        this.application = builder.getApplication();
        this.substance = builder.getSubstance();
        this.year = builder.getYear();
        this.scenarioName = builder.getScenarioName();
        this.trialNumber = builder.getTrialNumber();
        this.domesticValue = builder.getDomesticValue();
        this.importValue = builder.getImportValue();
        this.recycleValue = builder.getRecycleValue();
        this.domesticConsumptionValue = builder.getDomesticConsumptionValue();
        this.importConsumptionValue = builder.getImportConsumptionValue();
        this.recycleConsumptionValue = builder.getRecycleConsumptionValue();
        this.populationValue = builder.getPopulationValue();
        this.populationNew = builder.getPopulationNew();
        this.rechargeEmissions = builder.getRechargeEmissions();
        this.eolEmissions = builder.getEolEmissions();
        this.initialChargeEmissions = builder.getInitialChargeEmissions();
        this.energyConsumption = builder.getEnergyConsumption();
        this.exportValue = builder.getExportValue();
        this.exportConsumptionValue = builder.getExportConsumptionValue();
        this.tradeSupplement = builder.getTradeSupplement();
        this.bankKg = builder.getBankKg();
        this.bankTco2e = builder.getBankTco2e();
        this.bankChangeKg = builder.getBankChangeKg();
        this.bankChangeTco2e = builder.getBankChangeTco2e();
    }

    public String getApplication() {
        return this.application;
    }

    public String getSubstance() {
        return this.substance;
    }

    public int getYear() {
        return this.year;
    }

    public EngineNumber getDomestic() {
        return this.domesticValue;
    }

    public EngineNumber getImport() {
        return this.importValue;
    }

    public EngineNumber getRecycle() {
        return this.recycleValue;
    }

    public EngineNumber getConsumption() {
        return this.getConsumption(false);
    }

    public EngineNumber getConsumption(boolean includeRecycling) {
        String importUnits;
        String domesticUnits = this.domesticConsumptionValue.getUnits();
        if (!domesticUnits.equals(importUnits = this.importConsumptionValue.getUnits())) {
            throw new IllegalStateException("Could not add incompatible units for consumption.");
        }
        BigDecimal domesticConsumptionRaw = this.domesticConsumptionValue.getValue();
        BigDecimal importConsumptionRaw = this.importConsumptionValue.getValue();
        BigDecimal totalValue = domesticConsumptionRaw.add(importConsumptionRaw);
        if (includeRecycling) {
            String recycleUnits = this.recycleConsumptionValue.getUnits();
            if (!domesticUnits.equals(recycleUnits)) {
                throw new IllegalStateException("Could not add incompatible units for total consumption with recycling.");
            }
            totalValue = totalValue.add(this.recycleConsumptionValue.getValue());
        }
        return new EngineNumber(totalValue, domesticUnits);
    }

    public EngineNumber getDomesticConsumption() {
        return this.domesticConsumptionValue;
    }

    public EngineNumber getImportConsumption() {
        return this.importConsumptionValue;
    }

    public EngineNumber getRecycleConsumption() {
        return this.recycleConsumptionValue;
    }

    public EngineNumber getPopulation() {
        return this.populationValue;
    }

    public EngineNumber getPopulationNew() {
        return this.populationNew;
    }

    public EngineNumber getRechargeEmissions() {
        return this.rechargeEmissions;
    }

    public EngineNumber getEolEmissions() {
        return this.eolEmissions;
    }

    public EngineNumber getInitialChargeEmissions() {
        return this.initialChargeEmissions;
    }

    public EngineNumber getEnergyConsumption() {
        return this.energyConsumption;
    }

    public EngineNumber getExport() {
        return this.exportValue;
    }

    public EngineNumber getExportConsumption() {
        return this.exportConsumptionValue;
    }

    public TradeSupplement getTradeSupplement() {
        return this.tradeSupplement;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public int getTrialNumber() {
        return this.trialNumber;
    }

    public EngineNumber getBankKg() {
        return this.bankKg;
    }

    public EngineNumber getBankTco2e() {
        return this.bankTco2e;
    }

    public EngineNumber getBankChangeKg() {
        return this.bankChangeKg;
    }

    public EngineNumber getBankChangeTco2e() {
        return this.bankChangeTco2e;
    }
}

