/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.serializer;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.serializer.EngineResult;
import org.kigalisim.engine.serializer.TradeSupplement;

public class EngineResultBuilder {
    private Optional<String> application = Optional.empty();
    private Optional<String> substance = Optional.empty();
    private Optional<Integer> year = Optional.empty();
    private Optional<String> scenarioName = Optional.empty();
    private Optional<Integer> trialNumber = Optional.empty();
    private Optional<EngineNumber> domesticValue = Optional.empty();
    private Optional<EngineNumber> importValue = Optional.empty();
    private Optional<EngineNumber> recycleValue = Optional.empty();
    private Optional<EngineNumber> domesticConsumptionValue = Optional.empty();
    private Optional<EngineNumber> importConsumptionValue = Optional.empty();
    private Optional<EngineNumber> recycleConsumptionValue = Optional.empty();
    private Optional<EngineNumber> populationValue = Optional.empty();
    private Optional<EngineNumber> populationNew = Optional.empty();
    private Optional<EngineNumber> rechargeEmissions = Optional.empty();
    private Optional<EngineNumber> eolEmissions = Optional.empty();
    private Optional<EngineNumber> initialChargeEmissions = Optional.empty();
    private Optional<EngineNumber> energyConsumption = Optional.empty();
    private Optional<EngineNumber> exportValue = Optional.empty();
    private Optional<EngineNumber> exportConsumptionValue = Optional.empty();
    private Optional<TradeSupplement> tradeSupplement = Optional.empty();
    private Optional<EngineNumber> bankKg = Optional.empty();
    private Optional<EngineNumber> bankTco2e = Optional.empty();
    private Optional<EngineNumber> bankChangeKg = Optional.empty();
    private Optional<EngineNumber> bankChangeTco2e = Optional.empty();

    public EngineResultBuilder setApplication(String application) {
        this.application = Optional.of(application);
        return this;
    }

    public EngineResultBuilder setSubstance(String substance) {
        this.substance = Optional.of(substance);
        return this;
    }

    public EngineResultBuilder setYear(int year) {
        this.year = Optional.of(year);
        return this;
    }

    public EngineResultBuilder setScenarioName(String scenarioName) {
        this.scenarioName = Optional.of(scenarioName);
        return this;
    }

    public EngineResultBuilder setTrialNumber(int trialNumber) {
        this.trialNumber = Optional.of(trialNumber);
        return this;
    }

    public EngineResultBuilder setDomesticValue(EngineNumber domesticValue) {
        this.domesticValue = Optional.of(domesticValue);
        return this;
    }

    public EngineResultBuilder setImportValue(EngineNumber importValue) {
        this.importValue = Optional.of(importValue);
        return this;
    }

    public EngineResultBuilder setRecycleValue(EngineNumber recycleValue) {
        this.recycleValue = Optional.of(recycleValue);
        return this;
    }

    public EngineResultBuilder setDomesticConsumptionValue(EngineNumber domesticConsumptionValue) {
        this.domesticConsumptionValue = Optional.of(domesticConsumptionValue);
        return this;
    }

    public EngineResultBuilder setImportConsumptionValue(EngineNumber importConsumptionValue) {
        this.importConsumptionValue = Optional.of(importConsumptionValue);
        return this;
    }

    public EngineResultBuilder setRecycleConsumptionValue(EngineNumber recycleConsumptionValue) {
        this.recycleConsumptionValue = Optional.of(recycleConsumptionValue);
        return this;
    }

    public EngineResultBuilder setPopulationValue(EngineNumber populationValue) {
        this.populationValue = Optional.of(populationValue);
        return this;
    }

    public EngineResultBuilder setPopulationNew(EngineNumber populationNew) {
        this.populationNew = Optional.of(populationNew);
        return this;
    }

    public EngineResultBuilder setRechargeEmissions(EngineNumber rechargeEmissions) {
        this.rechargeEmissions = Optional.of(rechargeEmissions);
        return this;
    }

    public EngineResultBuilder setEolEmissions(EngineNumber eolEmissions) {
        this.eolEmissions = Optional.of(eolEmissions);
        return this;
    }

    public EngineResultBuilder setInitialChargeEmissions(EngineNumber initialChargeEmissions) {
        this.initialChargeEmissions = Optional.of(initialChargeEmissions);
        return this;
    }

    public EngineResultBuilder setEnergyConsumption(EngineNumber energyConsumption) {
        this.energyConsumption = Optional.ofNullable(energyConsumption);
        return this;
    }

    public EngineResultBuilder setExportValue(EngineNumber exportValue) {
        this.exportValue = Optional.of(exportValue);
        return this;
    }

    public EngineResultBuilder setExportConsumptionValue(EngineNumber exportConsumptionValue) {
        this.exportConsumptionValue = Optional.of(exportConsumptionValue);
        return this;
    }

    public EngineResultBuilder setTradeSupplement(TradeSupplement tradeSupplement) {
        this.tradeSupplement = Optional.of(tradeSupplement);
        return this;
    }

    public EngineResultBuilder setBankKg(EngineNumber bankKg) {
        this.bankKg = Optional.of(bankKg);
        return this;
    }

    public EngineResultBuilder setBankTco2e(EngineNumber bankTco2e) {
        this.bankTco2e = Optional.of(bankTco2e);
        return this;
    }

    public EngineResultBuilder setBankChangeKg(EngineNumber bankChangeKg) {
        this.bankChangeKg = Optional.of(bankChangeKg);
        return this;
    }

    public EngineResultBuilder setBankChangeTco2e(EngineNumber bankChangeTco2e) {
        this.bankChangeTco2e = Optional.of(bankChangeTco2e);
        return this;
    }

    public String getApplication() {
        return this.application.get();
    }

    public String getSubstance() {
        return this.substance.get();
    }

    public int getYear() {
        return this.year.get();
    }

    public String getScenarioName() {
        return this.scenarioName.get();
    }

    public int getTrialNumber() {
        return this.trialNumber.get();
    }

    public EngineNumber getDomesticValue() {
        return this.domesticValue.get();
    }

    public EngineNumber getImportValue() {
        return this.importValue.get();
    }

    public EngineNumber getRecycleValue() {
        return this.recycleValue.get();
    }

    public EngineNumber getDomesticConsumptionValue() {
        return this.domesticConsumptionValue.get();
    }

    public EngineNumber getImportConsumptionValue() {
        return this.importConsumptionValue.get();
    }

    public EngineNumber getRecycleConsumptionValue() {
        return this.recycleConsumptionValue.get();
    }

    public EngineNumber getPopulationValue() {
        return this.populationValue.get();
    }

    public EngineNumber getPopulationNew() {
        return this.populationNew.get();
    }

    public EngineNumber getRechargeEmissions() {
        return this.rechargeEmissions.get();
    }

    public EngineNumber getEolEmissions() {
        return this.eolEmissions.get();
    }

    public EngineNumber getInitialChargeEmissions() {
        return this.initialChargeEmissions.get();
    }

    public EngineNumber getEnergyConsumption() {
        return this.energyConsumption.get();
    }

    public EngineNumber getExportValue() {
        return this.exportValue.get();
    }

    public EngineNumber getExportConsumptionValue() {
        return this.exportConsumptionValue.get();
    }

    public TradeSupplement getTradeSupplement() {
        return this.tradeSupplement.get();
    }

    public EngineNumber getBankKg() {
        return this.bankKg.get();
    }

    public EngineNumber getBankTco2e() {
        return this.bankTco2e.get();
    }

    public EngineNumber getBankChangeKg() {
        return this.bankChangeKg.get();
    }

    public EngineNumber getBankChangeTco2e() {
        return this.bankChangeTco2e.get();
    }

    public EngineResult build() {
        this.checkReadyToConstruct();
        return new EngineResult(this);
    }

    private void checkReadyToConstruct() {
        this.checkValid(this.application, "application");
        this.checkValid(this.substance, "substance");
        this.checkValid(this.year, "year");
        this.checkValid(this.scenarioName, "scenarioName");
        this.checkValid(this.trialNumber, "trialNumber");
        this.checkValid(this.domesticValue, "domesticValue");
        this.checkValid(this.importValue, "importValue");
        this.checkValid(this.recycleValue, "recycleValue");
        this.checkValid(this.domesticConsumptionValue, "domesticConsumptionValue");
        this.checkValid(this.importConsumptionValue, "importConsumptionValue");
        this.checkValid(this.recycleConsumptionValue, "recycleConsumptionValue");
        this.checkValid(this.populationValue, "populationValue");
        this.checkValid(this.populationNew, "populationNew");
        this.checkValid(this.rechargeEmissions, "rechargeEmissions");
        this.checkValid(this.eolEmissions, "eolEmissions");
        this.checkValid(this.initialChargeEmissions, "initialChargeEmissions");
        this.checkValid(this.energyConsumption, "energyConsumption");
        this.checkValid(this.exportValue, "exportValue");
        this.checkValid(this.exportConsumptionValue, "exportConsumptionValue");
        this.checkValid(this.tradeSupplement, "tradeSupplement");
        this.checkValid(this.bankKg, "bankKg");
        this.checkValid(this.bankTco2e, "bankTco2e");
        this.checkValid(this.bankChangeKg, "bankChangeKg");
        this.checkValid(this.bankChangeTco2e, "bankChangeTco2e");
    }

    private void checkValid(Optional<?> value, String name) {
        if (value.isEmpty()) {
            throw new IllegalStateException("Could not make engine result because " + name + " was not given.");
        }
    }
}

