/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.serializer;

import java.math.BigDecimal;
import java.math.MathContext;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.serializer.EngineResult;
import org.kigalisim.engine.serializer.EngineResultBuilder;
import org.kigalisim.engine.serializer.TradeSupplement;
import org.kigalisim.engine.state.ConverterStateGetter;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.UseKey;

public class EngineResultSerializer {
    private final Engine engine;
    private final ConverterStateGetter stateGetter;

    public EngineResultSerializer(Engine engine, ConverterStateGetter stateGetter) {
        this.engine = engine;
        this.stateGetter = stateGetter;
    }

    public EngineResult getResult(UseKey useKey, int year) {
        EngineResultBuilder builder = new EngineResultBuilder();
        builder.setApplication(useKey.getApplication());
        builder.setSubstance(useKey.getSubstance());
        builder.setYear(year);
        builder.setScenarioName(this.engine.getScenarioName());
        builder.setTrialNumber(this.engine.getTrialNumber());
        this.parseMainBody(builder, useKey);
        this.parseTradeSupplement(builder, useKey);
        this.calculateBankValues(builder, useKey);
        return builder.build();
    }

    private void parseMainBody(EngineResultBuilder builder, UseKey useKey) {
        EngineNumber energyConsumptionValue;
        boolean hasDataForEnergy;
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(this.stateGetter);
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        EngineNumber recycleRaw = this.engine.getStreamFor(useKey, "recycle");
        EngineNumber recycleValue = unitConverter.convert(recycleRaw, "kg");
        builder.setRecycleValue(recycleValue);
        EngineNumber populationValue = this.engine.getStreamFor(useKey, "equipment");
        EngineNumber energyIntensity = this.engine.getEqualsEnergyIntensityFor(useKey);
        boolean bl = hasDataForEnergy = populationValue != null && energyIntensity != null;
        if (hasDataForEnergy) {
            OverridingConverterStateGetter energyStateGetter = new OverridingConverterStateGetter(stateGetter);
            energyStateGetter.setEnergyIntensity(energyIntensity);
            UnitConverter energyUnitConverter = new UnitConverter(energyStateGetter);
            energyConsumptionValue = energyUnitConverter.convert(populationValue, "kwh");
        } else {
            energyConsumptionValue = new EngineNumber(BigDecimal.ZERO, "kwh");
        }
        builder.setEnergyConsumption(energyConsumptionValue);
        builder.setPopulationValue(populationValue);
        EngineNumber populationNew = this.engine.getStreamFor(useKey, "newEquipment");
        builder.setPopulationNew(populationNew);
        EngineNumber eolEmissions = this.engine.getStreamFor(useKey, "eolEmissions");
        builder.setEolEmissions(eolEmissions);
        EngineNumber initialChargeEmissions = this.calculateInitialChargeEmissions(useKey);
        builder.setInitialChargeEmissions(initialChargeEmissions);
        EngineNumber manufactureRaw = this.engine.getStreamFor(useKey, "domestic");
        EngineNumber importRaw = this.engine.getStreamFor(useKey, "import");
        EngineNumber manufactureValue = unitConverter.convert(manufactureRaw, "kg");
        EngineNumber importValue = unitConverter.convert(importRaw, "kg");
        BigDecimal manufactureKg = manufactureValue.getValue();
        BigDecimal importKg = importValue.getValue();
        BigDecimal recycleKg = recycleValue.getValue();
        BigDecimal nonRecycleSalesKg = manufactureKg.add(importKg);
        boolean noSales = nonRecycleSalesKg.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal percentManufacture = noSales ? BigDecimal.ONE : manufactureKg.divide(nonRecycleSalesKg, MathContext.DECIMAL128);
        BigDecimal percentImport = BigDecimal.ONE.subtract(percentManufacture);
        builder.setDomesticValue(manufactureValue);
        builder.setImportValue(importValue);
        EngineNumber consumptionByVolume = this.getConsumptionByVolume(useKey, unitConverter);
        EngineNumber domesticConsumptionValue = this.getConsumptionForVolume(manufactureValue, consumptionByVolume, stateGetter, unitConverter);
        builder.setDomesticConsumptionValue(domesticConsumptionValue);
        EngineNumber importConsumptionValue = this.getConsumptionForVolume(importValue, consumptionByVolume, stateGetter, unitConverter);
        builder.setImportConsumptionValue(importConsumptionValue);
        EngineNumber exportRaw = this.engine.getStreamFor(useKey, "export");
        EngineNumber exportValue = exportRaw == null ? new EngineNumber(BigDecimal.ZERO, "kg") : unitConverter.convert(exportRaw, "kg");
        builder.setExportValue(exportValue);
        EngineNumber exportConsumptionValue = this.getConsumptionForVolume(exportValue, consumptionByVolume, stateGetter, unitConverter);
        builder.setExportConsumptionValue(exportConsumptionValue);
        EngineNumber recycleConsumptionValue = this.getConsumptionForVolume(recycleValue, consumptionByVolume, stateGetter, unitConverter);
        builder.setRecycleConsumptionValue(recycleConsumptionValue);
        EngineNumber rechargeEmissions = this.engine.getStreamFor(useKey, "rechargeEmissions");
        OverridingConverterStateGetter clearStateGetter = new OverridingConverterStateGetter(this.stateGetter);
        UnitConverter clearUnitConverter = new UnitConverter(clearStateGetter);
        EngineNumber rechargeEmissionsConvert = clearUnitConverter.convert(rechargeEmissions, "tCO2e");
        EngineNumber rechargeEmissionsOffset = new EngineNumber(rechargeEmissionsConvert.getValue().subtract(recycleConsumptionValue.getValue()), "tCO2e");
        builder.setRechargeEmissions(rechargeEmissionsOffset);
    }

    private void calculateBankValues(EngineResultBuilder builder, UseKey useKey) {
        EngineNumber priorBankTco2e;
        EngineNumber priorBankKg;
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(this.stateGetter);
        EngineNumber initialCharge = this.engine.getRawInitialChargeFor(useKey, "domestic");
        if (initialCharge == null || initialCharge.getValue().compareTo(BigDecimal.ZERO) == 0) {
            initialCharge = this.engine.getRawInitialChargeFor(useKey, "import");
        }
        stateGetter.setAmortizedUnitVolume(initialCharge);
        EngineNumber ghgIntensity = this.engine.getGhgIntensity(useKey);
        stateGetter.setSubstanceConsumption(ghgIntensity);
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        EngineNumber equipment = this.engine.getStreamFor(useKey, "equipment");
        EngineNumber bankKg = unitConverter.convert(equipment, "kg");
        EngineNumber bankTco2e = unitConverter.convert(equipment, "tCO2e");
        EngineNumber priorEquipment = this.engine.getStreamFor(useKey, "priorEquipment");
        if (priorEquipment == null) {
            priorBankKg = new EngineNumber(BigDecimal.ZERO, "kg");
            priorBankTco2e = new EngineNumber(BigDecimal.ZERO, "tCO2e");
        } else {
            priorBankKg = unitConverter.convert(priorEquipment, "kg");
            priorBankTco2e = unitConverter.convert(priorEquipment, "tCO2e");
        }
        BigDecimal changeKg = bankKg.getValue().subtract(priorBankKg.getValue());
        BigDecimal changeTco2e = bankTco2e.getValue().subtract(priorBankTco2e.getValue());
        EngineNumber bankChangeKg = new EngineNumber(changeKg, "kg");
        EngineNumber bankChangeTco2e = new EngineNumber(changeTco2e, "tCO2e");
        builder.setBankKg(bankKg);
        builder.setBankTco2e(bankTco2e);
        builder.setBankChangeKg(bankChangeKg);
        builder.setBankChangeTco2e(bankChangeTco2e);
    }

    private EngineNumber getConsumptionByVolume(UseKey useKey, UnitConverter unitConverter) {
        EngineNumber consumptionRaw = this.engine.getGhgIntensity(useKey);
        String units = consumptionRaw.getUnits();
        if (units.endsWith("kg") || units.endsWith("mt")) {
            return consumptionRaw;
        }
        return unitConverter.convert(consumptionRaw, "tCO2e / kg");
    }

    private EngineNumber getConsumptionForVolume(EngineNumber volume, EngineNumber consumptionByVolume, OverridingConverterStateGetter stateGetter, UnitConverter unitConverter) {
        if (volume.getValue().compareTo(BigDecimal.ZERO) == 0) {
            return new EngineNumber(BigDecimal.ZERO, "tCO2e");
        }
        stateGetter.setVolume(volume);
        return unitConverter.convert(consumptionByVolume, "tCO2e");
    }

    private void parseTradeSupplement(EngineResultBuilder builder, UseKey useKey) {
        EngineNumber recycleRecharge;
        BigDecimal recycleRechargeKg;
        BigDecimal totalDomesticValueKg;
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(this.stateGetter);
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        EngineNumber ghgIntensity = this.engine.getEqualsGhgIntensityFor(useKey);
        stateGetter.setSubstanceConsumption(ghgIntensity);
        EngineNumber importInitialChargeUnit = this.engine.getRawInitialChargeFor(useKey, "import");
        stateGetter.setAmortizedUnitVolume(importInitialChargeUnit);
        if (this.isPerUnit(ghgIntensity)) {
            this.handlePerUnitTradeSupplement(builder);
            return;
        }
        EngineNumber totalImportValue = this.engine.getStreamFor(useKey, "import");
        EngineNumber totalDomesticValue = this.engine.getStreamFor(useKey, "domestic");
        EngineNumber totalRechargeEmissions = this.engine.getStreamFor(useKey, "rechargeEmissions");
        BigDecimal totalImportValueKg = unitConverter.convert(totalImportValue, "kg").getValue();
        BigDecimal totalKg = totalImportValueKg.add(totalDomesticValueKg = unitConverter.convert(totalDomesticValue, "kg").getValue());
        BigDecimal proportionImport = totalKg.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : totalImportValueKg.divide(totalKg, MathContext.DECIMAL128);
        BigDecimal totalRechargeKg = unitConverter.convert(totalRechargeEmissions, "kg").getValue();
        BigDecimal virginRechargeKg = totalRechargeKg.subtract(recycleRechargeKg = unitConverter.convert(recycleRecharge = this.engine.getStreamFor(useKey, "recycleRecharge"), "kg").getValue());
        if (virginRechargeKg.compareTo(BigDecimal.ZERO) < 0) {
            virginRechargeKg = BigDecimal.ZERO;
        }
        BigDecimal importRechargeKg = proportionImport.multiply(virginRechargeKg);
        BigDecimal importForInitialChargeKg = totalImportValueKg.subtract(importRechargeKg);
        EngineNumber value = new EngineNumber(importForInitialChargeKg, "kg");
        EngineNumber consumption = unitConverter.convert(value, "tCO2e");
        EngineNumber population = unitConverter.convert(value, "units");
        EngineNumber zeroValue = new EngineNumber(BigDecimal.ZERO, "kg");
        EngineNumber zeroConsumption = new EngineNumber(BigDecimal.ZERO, "tCO2e");
        TradeSupplement tradeSupplement = new TradeSupplement(value, consumption, population, zeroValue, zeroConsumption);
        builder.setTradeSupplement(tradeSupplement);
    }

    private EngineNumber getInKg(UseKey useKey, String streamName, UnitConverter unitConverter) {
        EngineNumber value = this.engine.getStreamFor(useKey, streamName);
        if (value == null) {
            return new EngineNumber(BigDecimal.ZERO, "kg");
        }
        return unitConverter.convert(value, "kg");
    }

    private EngineNumber calculateInitialChargeEmissions(UseKey useKey) {
        OverridingConverterStateGetter scopedStateGetter = new OverridingConverterStateGetter(this.stateGetter);
        EngineNumber ghgIntensity = this.engine.getGhgIntensity(useKey);
        scopedStateGetter.setSubstanceConsumption(ghgIntensity);
        UnitConverter scopedConverter = new UnitConverter(scopedStateGetter);
        if (this.isPerUnit(ghgIntensity)) {
            return this.calculatePerUnitInitialChargeEmissions(useKey, ghgIntensity, scopedConverter);
        }
        return this.calculatePerVolumeInitialChargeEmissions(useKey, ghgIntensity, scopedConverter);
    }

    private EngineNumber calculatePerUnitInitialChargeEmissions(UseKey useKey, EngineNumber ghgIntensity, UnitConverter scopedConverter) {
        EngineNumber newPopulation = this.engine.getStreamFor(useKey, "newEquipment");
        if (newPopulation == null) {
            return new EngineNumber(BigDecimal.ZERO, "tCO2e");
        }
        EngineNumber populationInUnits = scopedConverter.convert(newPopulation, "units");
        OverridingConverterStateGetter emissionsStateGetter = new OverridingConverterStateGetter(this.stateGetter);
        emissionsStateGetter.setPopulation(populationInUnits);
        emissionsStateGetter.setSubstanceConsumption(ghgIntensity);
        UnitConverter emissionsConverter = new UnitConverter(emissionsStateGetter);
        return emissionsConverter.convert(ghgIntensity, "tCO2e");
    }

    private EngineNumber calculatePerVolumeInitialChargeEmissions(UseKey useKey, EngineNumber ghgIntensity, UnitConverter scopedConverter) {
        EngineNumber domesticKg = this.getInKg(useKey, "domestic", scopedConverter);
        EngineNumber importKg = this.getInKg(useKey, "import", scopedConverter);
        EngineNumber exportKg = this.getInKg(useKey, "export", scopedConverter);
        EngineNumber rechargeKg = this.getInKg(useKey, "rechargeEmissions", scopedConverter);
        BigDecimal totalSales = domesticKg.getValue().add(importKg.getValue()).add(exportKg.getValue());
        BigDecimal initialChargeVolume = totalSales.subtract(rechargeKg.getValue());
        if (initialChargeVolume.compareTo(BigDecimal.ZERO) < 0) {
            initialChargeVolume = BigDecimal.ZERO;
        }
        EngineNumber volumeNumber = new EngineNumber(initialChargeVolume, "kg");
        OverridingConverterStateGetter emissionsStateGetter = new OverridingConverterStateGetter(this.stateGetter);
        emissionsStateGetter.setVolume(volumeNumber);
        emissionsStateGetter.setSubstanceConsumption(ghgIntensity);
        UnitConverter emissionsConverter = new UnitConverter(emissionsStateGetter);
        return emissionsConverter.convert(ghgIntensity, "tCO2e");
    }

    private void handlePerUnitTradeSupplement(EngineResultBuilder builder) {
        EngineNumber zeroValue = new EngineNumber(BigDecimal.ZERO, "kg");
        EngineNumber zeroConsumption = new EngineNumber(BigDecimal.ZERO, "tCO2e");
        EngineNumber zeroPopulation = new EngineNumber(BigDecimal.ZERO, "units");
        TradeSupplement tradeSupplement = new TradeSupplement(zeroValue, zeroConsumption, zeroPopulation, zeroValue, zeroConsumption);
        builder.setTradeSupplement(tradeSupplement);
    }

    private boolean isPerUnit(EngineNumber ghgIntensity) {
        String normalizedUnits = ghgIntensity.getUnits().replaceAll("\\s+", "");
        String[] unitPieces = normalizedUnits.split("/");
        return unitPieces.length > 1 && ("unit".equals(unitPieces[1]) || "units".equals(unitPieces[1]));
    }
}

