/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.math.BigDecimal;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.state.StateGetter;

public class ConverterStateGetter
implements StateGetter {
    private final Engine engine;

    public ConverterStateGetter(Engine engine) {
        this.engine = engine;
    }

    @Override
    public EngineNumber getSubstanceConsumption() {
        return this.engine.getEqualsGhgIntensity();
    }

    @Override
    public EngineNumber getEnergyIntensity() {
        return this.engine.getEqualsEnergyIntensity();
    }

    @Override
    public EngineNumber getAmortizedUnitVolume() {
        return this.engine.getInitialCharge("sales");
    }

    @Override
    public EngineNumber getPopulation() {
        return this.engine.getStream("equipment");
    }

    @Override
    public EngineNumber getYearsElapsed() {
        return new EngineNumber(BigDecimal.ONE, "year");
    }

    @Override
    public EngineNumber getGhgConsumption() {
        return this.engine.getStream("consumption");
    }

    @Override
    public EngineNumber getEnergyConsumption() {
        return this.engine.getStream("energy");
    }

    @Override
    public EngineNumber getVolume() {
        return this.engine.getStream("sales");
    }

    @Override
    public EngineNumber getAmortizedUnitConsumption() {
        boolean unitsExpected;
        EngineNumber consumption = this.getGhgConsumption();
        EngineNumber population = this.getPopulation();
        BigDecimal ratioValue = consumption.getValue().divide(population.getValue());
        String populationUnits = population.getUnits();
        String consumptionUnits = consumption.getUnits();
        boolean populationUnitsExpected = this.getIsUnits(populationUnits);
        boolean consumptionUnitsExpected = "tCO2e".equals(consumptionUnits);
        boolean bl = unitsExpected = populationUnitsExpected && consumptionUnitsExpected;
        if (!unitsExpected) {
            throw new RuntimeException("Unexpected units for getAmortizedUnitConsumption.");
        }
        String ratioUnits = consumptionUnits + " / " + populationUnits;
        return new EngineNumber(ratioValue, ratioUnits);
    }

    private boolean getIsUnits(String populationUnits) {
        return "unit".equals(populationUnits) || "units".equals(populationUnits);
    }

    @Override
    public EngineNumber getPopulationChange(UnitConverter unitConverter) {
        EngineNumber priorEquipmentRaw = this.engine.getStream("priorEquipment");
        EngineNumber newEquipmentRaw = this.engine.getStream("equipment");
        EngineNumber priorEquipment = unitConverter.convert(priorEquipmentRaw, "units");
        EngineNumber newEquipment = unitConverter.convert(newEquipmentRaw, "units");
        BigDecimal deltaValue = newEquipment.getValue().subtract(priorEquipment.getValue());
        return new EngineNumber(deltaValue, "units");
    }
}

