/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.util.HashMap;
import java.util.Map;

public final class EngineConstants {
    public static final int GLOBAL_CONTEXT = 0;
    public static final int STANZA_CONTEXT = 1;
    public static final int APPLICATION_CONTEXT = 2;
    public static final int SUBSTANCE_CONTEXT = 3;
    private static final Map<String, String> STREAM_BASE_UNITS = EngineConstants.createStreamBaseUnits();

    private static Map<String, String> createStreamBaseUnits() {
        HashMap<String, String> units = new HashMap<String, String>();
        units.put("domestic", "kg");
        units.put("import", "kg");
        units.put("export", "kg");
        units.put("sales", "kg");
        units.put("energy", "kwh");
        units.put("recycle", "kg");
        units.put("recycleRecharge", "kg");
        units.put("recycleEol", "kg");
        units.put("inductionEol", "kg");
        units.put("inductionRecharge", "kg");
        units.put("induction", "kg");
        units.put("consumption", "tCO2e");
        units.put("rechargeEmissions", "tCO2e");
        units.put("eolEmissions", "tCO2e");
        units.put("equipment", "units");
        units.put("priorEquipment", "units");
        units.put("newEquipment", "units");
        units.put("retired", "units");
        units.put("priorRetired", "units");
        units.put("implicitRecharge", "kg");
        units.put("age", "years");
        return units;
    }

    public static String getBaseUnits(String streamName) {
        return STREAM_BASE_UNITS.get(streamName);
    }

    private EngineConstants() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }
}

