/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.state.StateGetter;

public class OverridingConverterStateGetter
implements StateGetter {
    private final StateGetter innerGetter;
    private Optional<EngineNumber> energyIntensity;
    private Optional<EngineNumber> amortizedUnitVolume;
    private Optional<EngineNumber> population;
    private Optional<EngineNumber> yearsElapsed;
    private Optional<EngineNumber> totalConsumption;
    private Optional<EngineNumber> energyConsumption;
    private Optional<EngineNumber> volume;
    private Optional<EngineNumber> amortizedUnitConsumption;
    private Optional<EngineNumber> populationChange;
    private Optional<EngineNumber> substanceConsumption;

    public OverridingConverterStateGetter(StateGetter innerGetter) {
        this.innerGetter = innerGetter;
        this.energyIntensity = Optional.empty();
        this.amortizedUnitVolume = Optional.empty();
        this.population = Optional.empty();
        this.yearsElapsed = Optional.empty();
        this.totalConsumption = Optional.empty();
        this.energyConsumption = Optional.empty();
        this.volume = Optional.empty();
        this.amortizedUnitConsumption = Optional.empty();
        this.populationChange = Optional.empty();
        this.substanceConsumption = Optional.empty();
    }

    public void setTotal(String streamName, EngineNumber value) {
        switch (streamName) {
            case "sales": 
            case "domestic": 
            case "import": 
            case "export": {
                this.setVolume(value);
                break;
            }
            case "equipment": 
            case "priorEquipment": {
                this.setPopulation(value);
                break;
            }
            case "consumption": {
                this.setConsumption(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized stream name: " + streamName);
            }
        }
    }

    public void setSubstanceConsumption(EngineNumber newValue) {
        this.substanceConsumption = Optional.of(newValue);
    }

    @Override
    public EngineNumber getSubstanceConsumption() {
        if (this.substanceConsumption.isPresent()) {
            return this.substanceConsumption.get();
        }
        return this.innerGetter.getSubstanceConsumption();
    }

    public void setEnergyIntensity(EngineNumber newValue) {
        this.energyIntensity = Optional.of(newValue);
    }

    @Override
    public EngineNumber getEnergyIntensity() {
        if (this.energyIntensity.isPresent()) {
            return this.energyIntensity.get();
        }
        return this.innerGetter.getEnergyIntensity();
    }

    public void setAmortizedUnitVolume(EngineNumber newValue) {
        this.amortizedUnitVolume = Optional.of(newValue);
    }

    public void clearAmortizedUnitVolume() {
        this.amortizedUnitVolume = Optional.empty();
    }

    @Override
    public EngineNumber getAmortizedUnitVolume() {
        if (this.amortizedUnitVolume.isPresent()) {
            return this.amortizedUnitVolume.get();
        }
        return this.innerGetter.getAmortizedUnitVolume();
    }

    public void setPopulation(EngineNumber newValue) {
        this.population = Optional.of(newValue);
    }

    public void clearPopulation() {
        this.population = Optional.empty();
    }

    @Override
    public EngineNumber getPopulation() {
        if (this.population.isPresent()) {
            return this.population.get();
        }
        return this.innerGetter.getPopulation();
    }

    public void setYearsElapsed(EngineNumber newValue) {
        this.yearsElapsed = Optional.of(newValue);
    }

    @Override
    public EngineNumber getYearsElapsed() {
        if (this.yearsElapsed.isPresent()) {
            return this.yearsElapsed.get();
        }
        return this.innerGetter.getYearsElapsed();
    }

    public void setConsumption(EngineNumber newValue) {
        this.totalConsumption = Optional.of(newValue);
    }

    public void setEnergyConsumption(EngineNumber newValue) {
        this.energyConsumption = Optional.of(newValue);
    }

    @Override
    public EngineNumber getGhgConsumption() {
        if (this.totalConsumption.isPresent()) {
            return this.totalConsumption.get();
        }
        return this.innerGetter.getGhgConsumption();
    }

    @Override
    public EngineNumber getEnergyConsumption() {
        if (this.energyConsumption.isPresent()) {
            return this.energyConsumption.get();
        }
        return this.innerGetter.getEnergyConsumption();
    }

    public void setVolume(EngineNumber newValue) {
        this.volume = Optional.of(newValue);
    }

    public void clearVolume() {
        this.volume = Optional.empty();
    }

    @Override
    public EngineNumber getVolume() {
        if (this.volume.isPresent()) {
            return this.volume.get();
        }
        return this.innerGetter.getVolume();
    }

    public void setAmortizedUnitConsumption(EngineNumber newValue) {
        this.amortizedUnitConsumption = Optional.of(newValue);
    }

    @Override
    public EngineNumber getAmortizedUnitConsumption() {
        if (this.amortizedUnitConsumption.isPresent()) {
            return this.amortizedUnitConsumption.get();
        }
        return this.innerGetter.getAmortizedUnitConsumption();
    }

    public void setPopulationChange(EngineNumber newValue) {
        this.populationChange = Optional.of(newValue);
    }

    @Override
    public EngineNumber getPopulationChange(UnitConverter unitConverter) {
        if (this.populationChange.isPresent()) {
            return this.populationChange.get();
        }
        return this.innerGetter.getPopulationChange(unitConverter);
    }
}

