/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.math.BigDecimal;
import java.math.MathContext;
import org.kigalisim.engine.number.EngineNumber;

public class RechargeInformation {
    private final EngineNumber population;
    private final EngineNumber intensity;

    public RechargeInformation(EngineNumber population, EngineNumber intensity) {
        this.population = population;
        this.intensity = intensity;
    }

    public EngineNumber getPopulation() {
        return this.population;
    }

    public EngineNumber getIntensity() {
        return this.intensity;
    }

    public RechargeInformation add(EngineNumber newPopulation, EngineNumber newIntensity) {
        boolean differentIntensityUnits;
        boolean differentPopulationUnits;
        boolean priorZero = this.population.getValue().equals(BigDecimal.ZERO);
        if (priorZero) {
            return new RechargeInformation(newPopulation, newIntensity);
        }
        boolean bl = differentPopulationUnits = !this.population.getUnits().equals(newPopulation.getUnits());
        if (differentPopulationUnits) {
            throw new RuntimeException("Cannot mix units for recharge.");
        }
        boolean bl2 = differentIntensityUnits = !this.intensity.getUnits().equals(newIntensity.getUnits());
        if (differentIntensityUnits) {
            throw new RuntimeException("Cannot mix units for recharge.");
        }
        BigDecimal currentWeight = this.population.getValue().abs();
        BigDecimal addedWeight = newPopulation.getValue().abs();
        BigDecimal weightedIntensity = this.calculateWeightedIntensity(currentWeight, addedWeight, newIntensity);
        BigDecimal accumulatedPopulation = this.population.getValue().add(newPopulation.getValue());
        return new RechargeInformation(new EngineNumber(accumulatedPopulation, newPopulation.getUnits()), new EngineNumber(weightedIntensity, newIntensity.getUnits()));
    }

    private BigDecimal calculateWeightedIntensity(BigDecimal currentWeight, BigDecimal addedWeight, EngineNumber newIntensity) {
        boolean noPriorPopulation;
        boolean bl = noPriorPopulation = currentWeight.compareTo(BigDecimal.ZERO) == 0;
        if (noPriorPopulation) {
            return newIntensity.getValue();
        }
        BigDecimal totalWeight = currentWeight.add(addedWeight);
        return currentWeight.multiply(this.intensity.getValue()).add(addedWeight.multiply(newIntensity.getValue())).divide(totalWeight, MathContext.DECIMAL128);
    }
}

