/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.VariableManager;

public class Scope
implements UseKey {
    private final Optional<String> stanza;
    private final Optional<String> application;
    private final Optional<String> substance;
    private final VariableManager variableManager;
    private volatile Optional<String> key;

    public Scope(String stanza, String application, String substance) {
        this(stanza, application, substance, null);
    }

    public Scope(String stanza, String application, String substance, VariableManager variableManager) {
        this.stanza = Optional.ofNullable(stanza);
        this.application = Optional.ofNullable(application);
        this.substance = Optional.ofNullable(substance);
        this.key = Optional.empty();
        if (substance != null && application == null) {
            throw new IllegalArgumentException("Cannot specify substance without application.");
        }
        if (application != null && stanza == null) {
            throw new IllegalArgumentException("Cannot specify application without stanza.");
        }
        if (variableManager == null) {
            int contextLevel = this.calculateContextLevel(stanza, application, substance);
            this.variableManager = new VariableManager(contextLevel);
        } else {
            this.variableManager = variableManager;
        }
    }

    public Scope() {
        this(null, null, null, null);
    }

    public String getStanza() {
        return this.stanza.orElse(null);
    }

    public Optional<String> getStanzaOptional() {
        return this.stanza;
    }

    @Override
    public String getApplication() {
        return this.application.orElse(null);
    }

    public Optional<String> getApplicationOptional() {
        return this.application;
    }

    @Override
    public String getSubstance() {
        return this.substance.orElse(null);
    }

    public Optional<String> getSubstanceOptional() {
        return this.substance;
    }

    public Scope getWithSubstance(String newSubstance) {
        if (this.application.isEmpty()) {
            throw new IllegalStateException("Not able to set substance without application.");
        }
        return new Scope(this.stanza.orElse(null), this.application.orElse(null), newSubstance, this.variableManager.getWithLevel(3));
    }

    public Scope getWithApplication(String newApplication) {
        if (this.stanza.isEmpty()) {
            throw new IllegalStateException("Not able to set application without stanza.");
        }
        return new Scope(this.stanza.orElse(null), newApplication, null, this.variableManager.getWithLevel(2));
    }

    public Scope getWithStanza(String newStanza) {
        return new Scope(newStanza, null, null, this.variableManager.getWithLevel(1));
    }

    public void defineVariable(String name) {
        this.variableManager.defineVariable(name);
    }

    public void setVariable(String name, EngineNumber value) {
        this.variableManager.setVariable(name, value);
    }

    public EngineNumber getVariable(String name) {
        return this.variableManager.getVariable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKey() {
        Optional<String> localKey = this.key;
        if (localKey.isEmpty()) {
            Scope scope = this;
            synchronized (scope) {
                localKey = this.key;
                if (localKey.isEmpty()) {
                    StringBuilder keyBuilder = new StringBuilder();
                    keyBuilder.append(this.application.orElse("-"));
                    keyBuilder.append("\t");
                    keyBuilder.append(this.substance.orElse("-"));
                    String computedKey = keyBuilder.toString();
                    this.key = localKey = Optional.of(computedKey);
                }
            }
        }
        return localKey.get();
    }

    private int calculateContextLevel(String stanza, String application, String substance) {
        int contextLevel = 0;
        if (stanza != null) {
            ++contextLevel;
        }
        if (application != null) {
            ++contextLevel;
        }
        if (substance != null) {
            ++contextLevel;
        }
        return contextLevel;
    }
}

