/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.recalc.SalesStreamDistributionBuilder;
import org.kigalisim.engine.state.EngineConstants;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.SimpleUseKey;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.StreamParameterization;
import org.kigalisim.engine.state.SubstanceInApplicationId;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.lang.operation.RecoverOperation;

public class SimulationState {
    private static final boolean CHECK_NAN_STATE = false;
    private static final BigDecimal BASE_CHANGE_TOLERANCE = new BigDecimal("0.0001");
    private static final BigDecimal HUNDRED_PERCENT = BigDecimal.valueOf(100L);
    public static final EngineNumber ZERO_VOLUME = new EngineNumber(BigDecimal.ZERO, "kg");
    private final Map<String, StreamParameterization> substances = new HashMap<String, StreamParameterization>();
    private final Map<String, EngineNumber> streams = new HashMap<String, EngineNumber>();
    private final OverridingConverterStateGetter stateGetter;
    private final UnitConverter unitConverter;
    private int currentYear;

    public SimulationState(OverridingConverterStateGetter stateGetter, UnitConverter unitConverter) {
        this.stateGetter = stateGetter;
        this.unitConverter = unitConverter;
    }

    public List<SubstanceInApplicationId> getRegisteredSubstances() {
        return this.substances.keySet().stream().map(key -> {
            boolean bothKeysOk;
            boolean correctKeyLength;
            String[] keyComponents = key.split("\t");
            boolean bl = correctKeyLength = keyComponents.length == 2;
            if (!correctKeyLength) {
                return null;
            }
            boolean firstKeyOk = keyComponents[0] != null && !keyComponents[0].trim().isEmpty();
            boolean secondKeyOk = keyComponents[1] != null && !keyComponents[1].trim().isEmpty();
            boolean bl2 = bothKeysOk = firstKeyOk && secondKeyOk;
            if (!bothKeysOk) {
                return null;
            }
            return new SubstanceInApplicationId(keyComponents[0], keyComponents[1]);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasSubstance(UseKey useKey) {
        String key = this.getKey(useKey);
        return this.substances.containsKey(key);
    }

    public void ensureSubstance(UseKey useKey) {
        String key = this.getKey(useKey);
        if (this.substances.containsKey(key)) {
            return;
        }
        StreamParameterization parameterization = new StreamParameterization();
        this.substances.put(key, parameterization);
        this.ensureSubstanceSales(useKey);
        this.ensureSubstanceConsumption(useKey);
        this.ensureSubstancePopulation(useKey);
        this.ensureSubstanceEmissions(useKey);
        this.ensureSubstanceRecharge(useKey);
        this.ensureSubstanceAge(useKey);
    }

    private void ensureSubstanceSales(UseKey useKey) {
        String domesticKey = this.getKey(useKey, "domestic");
        this.streams.put(domesticKey, ZERO_VOLUME);
        String importKey = this.getKey(useKey, "import");
        this.streams.put(importKey, ZERO_VOLUME);
        String exportKey = this.getKey(useKey, "export");
        this.streams.put(exportKey, ZERO_VOLUME);
        String recycleRechargeKey = this.getKey(useKey, "recycleRecharge");
        this.streams.put(recycleRechargeKey, new EngineNumber(BigDecimal.ZERO, "kg"));
        String recycleEolKey = this.getKey(useKey, "recycleEol");
        this.streams.put(recycleEolKey, new EngineNumber(BigDecimal.ZERO, "kg"));
        String inductionEolKey = this.getKey(useKey, "inductionEol");
        this.streams.put(inductionEolKey, new EngineNumber(BigDecimal.ZERO, "kg"));
        String inductionRechargeKey = this.getKey(useKey, "inductionRecharge");
        this.streams.put(inductionRechargeKey, new EngineNumber(BigDecimal.ZERO, "kg"));
    }

    private void ensureSubstanceConsumption(UseKey useKey) {
        String consumptionKey = this.getKey(useKey, "consumption");
        this.streams.put(consumptionKey, new EngineNumber(BigDecimal.ZERO, "tCO2e"));
    }

    private void ensureSubstancePopulation(UseKey useKey) {
        String equipmentKey = this.getKey(useKey, "equipment");
        this.streams.put(equipmentKey, new EngineNumber(BigDecimal.ZERO, "units"));
        String priorEquipmentKey = this.getKey(useKey, "priorEquipment");
        this.streams.put(priorEquipmentKey, new EngineNumber(BigDecimal.ZERO, "units"));
        String newEquipmentKey = this.getKey(useKey, "newEquipment");
        this.streams.put(newEquipmentKey, new EngineNumber(BigDecimal.ZERO, "units"));
        String retiredKey = this.getKey(useKey, "retired");
        this.streams.put(retiredKey, new EngineNumber(BigDecimal.ZERO, "units"));
        String priorRetiredKey = this.getKey(useKey, "priorRetired");
        this.streams.put(priorRetiredKey, new EngineNumber(BigDecimal.ZERO, "units"));
    }

    private void ensureSubstanceEmissions(UseKey useKey) {
        String rechargeEmissionsKey = this.getKey(useKey, "rechargeEmissions");
        this.streams.put(rechargeEmissionsKey, new EngineNumber(BigDecimal.ZERO, "tCO2e"));
        String eolEmissionsKey = this.getKey(useKey, "eolEmissions");
        this.streams.put(eolEmissionsKey, new EngineNumber(BigDecimal.ZERO, "tCO2e"));
    }

    private void ensureSubstanceRecharge(UseKey useKey) {
        String implicitRechargeKey = this.getKey(useKey, "implicitRecharge");
        this.streams.put(implicitRechargeKey, new EngineNumber(BigDecimal.ZERO, "kg"));
    }

    private void ensureSubstanceAge(UseKey useKey) {
        String ageKey = this.getKey(useKey, "age");
        this.streams.put(ageKey, new EngineNumber(BigDecimal.ZERO, "years"));
    }

    public void update(SimulationStateUpdate stateUpdate) {
        boolean isSimpleSet;
        UseKey useKey = stateUpdate.getUseKey();
        String name = stateUpdate.getName();
        EngineNumber value = stateUpdate.getValue();
        String key = this.getKey(useKey);
        this.ensureSubstanceOrThrow(key, "update(SimulationStateUpdate)");
        this.ensureStreamKnown(name);
        this.assertStreamEnabled(useKey, name, value);
        if (stateUpdate.getInvalidatesPriorEquipment()) {
            this.updatePriorEquipmentBase(useKey, name, value);
        }
        boolean subtractRecycling = stateUpdate.getSubtractRecycling();
        Optional<SalesStreamDistribution> distribution = stateUpdate.getDistribution();
        boolean isUsedSalesSubstream = "domestic".equals(name) || "import".equals(name);
        boolean bl = isSimpleSet = !subtractRecycling && isUsedSalesSubstream;
        if (isSimpleSet) {
            this.setSimpleStream(useKey, name, value);
            return;
        }
        switch (name) {
            case "sales": {
                this.setStreamForSales(useKey, name, value);
                break;
            }
            case "domestic": 
            case "import": {
                this.setStreamSalesSubstream(useKey, name, value, distribution);
                break;
            }
            case "recycle": {
                this.setStreamForRecycle(useKey, name, value);
                break;
            }
            default: {
                if (this.getIsSettingVolumeByUnits(name, value)) {
                    this.setStreamForSalesWithUnits(useKey, name, value);
                    break;
                }
                this.setSimpleStream(useKey, name, value);
            }
        }
    }

    private void setStreamSalesSubstream(UseKey useKey, String name, EngineNumber value, Optional<SalesStreamDistribution> distribution) {
        EngineNumber valueConverted = this.unitConverter.convert(value, "kg");
        BigDecimal amountKg = valueConverted.getValue();
        if (!this.hasStreamsEnabled(useKey)) {
            throw new IllegalStateException("Cannot set sales stream: no streams have been enabled. Use 'set " + name + "' or other stream statements to enable streams before operations that require sales recalculation.");
        }
        EngineNumber recycleAmountRaw = this.getStream(useKey, "recycle");
        EngineNumber recycleAmount = this.unitConverter.convert(recycleAmountRaw, "kg");
        BigDecimal recycleKg = recycleAmount != null ? recycleAmount.getValue() : BigDecimal.ZERO;
        SalesStreamDistribution streamDistribution = distribution.isPresent() ? distribution.get() : this.getDistribution(useKey);
        BigDecimal substreamPercent = "domestic".equals(name) ? streamDistribution.getPercentDomestic() : streamDistribution.getPercentImport();
        BigDecimal substreamRecycling = recycleKg.multiply(substreamPercent);
        BigDecimal netAmount = amountKg.subtract(substreamRecycling);
        if (netAmount.compareTo(BigDecimal.ZERO) < 0) {
            netAmount = BigDecimal.ZERO;
        }
        EngineNumber netAmountToSet = new EngineNumber(netAmount, "kg");
        this.setSimpleStream(useKey, name, netAmountToSet);
    }

    public EngineNumber getStream(UseKey useKey, String name) {
        this.ensureStreamKnown(name);
        return switch (name) {
            case "sales" -> this.getStreamSales(useKey);
            case "recycle" -> this.getStreamRecycle(useKey);
            case "induction" -> this.getStreamInduction(useKey);
            default -> this.getStreamDirect(useKey, name);
        };
    }

    private EngineNumber getStreamSales(UseKey useKey) {
        EngineNumber domesticAmountRaw = this.getStream(useKey, "domestic");
        EngineNumber importAmountRaw = this.getStream(useKey, "import");
        EngineNumber recycleAmountRaw = this.getStream(useKey, "recycle");
        EngineNumber domesticAmount = this.unitConverter.convert(domesticAmountRaw, "kg");
        EngineNumber importAmount = this.unitConverter.convert(importAmountRaw, "kg");
        EngineNumber recycleAmount = this.unitConverter.convert(recycleAmountRaw, "kg");
        BigDecimal domesticAmountValue = domesticAmount.getValue();
        BigDecimal importAmountValue = importAmount.getValue();
        BigDecimal recycleAmountValue = recycleAmount.getValue();
        BigDecimal newTotal = domesticAmountValue.add(importAmountValue).add(recycleAmountValue);
        return new EngineNumber(newTotal, "kg");
    }

    private EngineNumber getStreamRecycle(UseKey useKey) {
        EngineNumber recycleRechargeAmountRaw = this.getStream(useKey, "recycleRecharge");
        EngineNumber recycleEolAmountRaw = this.getStream(useKey, "recycleEol");
        EngineNumber recycleRechargeAmount = this.unitConverter.convert(recycleRechargeAmountRaw, "kg");
        EngineNumber recycleEolAmount = this.unitConverter.convert(recycleEolAmountRaw, "kg");
        BigDecimal recycleRechargeAmountValue = recycleRechargeAmount.getValue();
        BigDecimal recycleEolAmountValue = recycleEolAmount.getValue();
        BigDecimal newTotal = recycleRechargeAmountValue.add(recycleEolAmountValue);
        return new EngineNumber(newTotal, "kg");
    }

    private EngineNumber getStreamInduction(UseKey useKey) {
        return this.getTotalInductionStream(useKey);
    }

    private EngineNumber getStreamDirect(UseKey useKey, String name) {
        EngineNumber result = this.streams.get(this.getKey(useKey, name));
        if (result == null) {
            this.throwSubstanceMissing("getStream", useKey.getApplication(), useKey.getSubstance());
        }
        return result;
    }

    public boolean isKnownStream(UseKey useKey, String name) {
        return this.streams.containsKey(this.getKey(useKey, name));
    }

    public EngineNumber getInductionStream(UseKey useKey, RecoverOperation.RecoveryStage stage) {
        String streamName = this.getInductionStreamName(stage);
        return this.getStream(useKey, streamName);
    }

    private void setInductionStream(UseKey useKey, RecoverOperation.RecoveryStage stage, EngineNumber value) {
        String streamName = this.getInductionStreamName(stage);
        String key = this.getKey(useKey);
        this.ensureSubstanceOrThrow(key, "setInductionStream");
        this.ensureStreamKnown(streamName);
        this.assertStreamEnabled(useKey, streamName, value);
        this.setSimpleStream(useKey, streamName, value);
    }

    public EngineNumber getTotalInductionStream(UseKey useKey) {
        EngineNumber inductionEol = this.getInductionStream(useKey, RecoverOperation.RecoveryStage.EOL);
        EngineNumber inductionRecharge = this.getInductionStream(useKey, RecoverOperation.RecoveryStage.RECHARGE);
        EngineNumber eolConverted = this.unitConverter.convert(inductionEol, "kg");
        EngineNumber rechargeConverted = this.unitConverter.convert(inductionRecharge, "kg");
        BigDecimal total = eolConverted.getValue().add(rechargeConverted.getValue());
        return new EngineNumber(total, "kg");
    }

    private String getInductionStreamName(RecoverOperation.RecoveryStage stage) {
        return switch (stage) {
            default -> throw new MatchException(null, null);
            case RecoverOperation.RecoveryStage.EOL -> "inductionEol";
            case RecoverOperation.RecoveryStage.RECHARGE -> "inductionRecharge";
        };
    }

    public SalesStreamDistribution getDistribution(UseKey useKey) {
        return this.getDistribution(useKey, false);
    }

    public SalesStreamDistribution getDistribution(UseKey useKey, boolean includeExports) {
        EngineNumber domesticValueRaw = this.getStream(useKey, "domestic");
        EngineNumber importValueRaw = this.getStream(useKey, "import");
        EngineNumber exportValueRaw = this.getStream(useKey, "export");
        EngineNumber domesticValue = this.unitConverter.convert(domesticValueRaw, "kg");
        EngineNumber importValue = this.unitConverter.convert(importValueRaw, "kg");
        EngineNumber exportValue = exportValueRaw == null ? new EngineNumber(BigDecimal.ZERO, "kg") : this.unitConverter.convert(exportValueRaw, "kg");
        boolean domesticEnabled = this.hasStreamBeenEnabled(useKey, "domestic");
        boolean importEnabled = this.hasStreamBeenEnabled(useKey, "import");
        boolean exportEnabled = this.hasStreamBeenEnabled(useKey, "export");
        return new SalesStreamDistributionBuilder().setDomesticSales(domesticValue).setImportSales(importValue).setExportSales(exportValue).setDomesticEnabled(domesticEnabled).setImportEnabled(importEnabled).setExportEnabled(exportEnabled).setIncludeExports(includeExports).build();
    }

    public boolean hasStreamsEnabled(UseKey useKey) {
        return this.hasStreamBeenEnabled(useKey, "domestic") || this.hasStreamBeenEnabled(useKey, "import") || this.hasStreamBeenEnabled(useKey, "export");
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public void setCurrentYear(int year) {
        this.currentYear = year;
    }

    public void incrementYear() {
        SimpleUseKey useKey;
        String substance;
        String application;
        String[] keyPieces;
        ++this.currentYear;
        for (String key : this.substances.keySet()) {
            keyPieces = key.split("\t");
            application = keyPieces[0];
            substance = keyPieces[1];
            useKey = new SimpleUseKey(application, substance);
            EngineNumber equipment = this.getStream(useKey, "equipment");
            this.setSimpleStream(useKey, "priorEquipment", equipment);
            EngineNumber retired = this.getStream(useKey, "retired");
            this.setSimpleStream(useKey, "priorRetired", retired);
            EngineNumber priorEquipmentValue = this.getStream(useKey, "priorEquipment");
            EngineNumber currentEquipmentValue = this.getStream(useKey, "equipment");
            EngineNumber currentAge = this.getStream(useKey, "age");
            EngineNumber priorEquipmentUnits = this.unitConverter.convert(priorEquipmentValue, "units");
            EngineNumber currentEquipmentUnits = this.unitConverter.convert(currentEquipmentValue, "units");
            BigDecimal priorAgeWeight = priorEquipmentUnits.getValue();
            BigDecimal addedEquipment = currentEquipmentUnits.getValue().subtract(priorEquipmentUnits.getValue());
            BigDecimal addedAgeWeight = addedEquipment.max(BigDecimal.ZERO);
            BigDecimal priorAgeYears = currentAge.getValue().add(BigDecimal.ONE);
            BigDecimal priorAgeWeighted = priorAgeYears.multiply(priorAgeWeight);
            BigDecimal addedAgeWeighted = addedAgeWeight;
            BigDecimal totalWeight = priorAgeWeight.add(addedAgeWeight);
            boolean isZero = totalWeight.compareTo(BigDecimal.ZERO) == 0;
            BigDecimal newAge = isZero ? BigDecimal.ZERO : priorAgeWeighted.add(addedAgeWeighted).divide(totalWeight, MathContext.DECIMAL128);
            this.setSimpleStream(useKey, "age", new EngineNumber(newAge, "years"));
        }
        for (StreamParameterization parameterization : this.substances.values()) {
            parameterization.resetStateAtTimestep();
        }
        this.redistributeRecyclingToSales();
        this.redistributeInductionFromSales();
        for (String key : this.substances.keySet()) {
            keyPieces = key.split("\t");
            application = keyPieces[0];
            substance = keyPieces[1];
            useKey = new SimpleUseKey(application, substance);
            this.setSimpleStream(useKey, "recycleRecharge", new EngineNumber(BigDecimal.ZERO, "kg"));
            this.setSimpleStream(useKey, "recycleEol", new EngineNumber(BigDecimal.ZERO, "kg"));
            this.setSimpleStream(useKey, "inductionEol", new EngineNumber(BigDecimal.ZERO, "kg"));
            this.setSimpleStream(useKey, "inductionRecharge", new EngineNumber(BigDecimal.ZERO, "kg"));
        }
    }

    public void setGhgIntensity(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setGhgIntensity(newValue);
    }

    public void setEnergyIntensity(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setEnergyIntensity(newValue);
    }

    public EngineNumber getGhgIntensity(UseKey useKey) {
        String key = this.getKey(useKey);
        StreamParameterization parameterization = this.substances.get(key);
        if (parameterization == null) {
            this.throwSubstanceMissing("getGhgIntensity", useKey.getApplication(), useKey.getSubstance());
        }
        return parameterization.getGhgIntensity();
    }

    public EngineNumber getEnergyIntensity(UseKey useKey) {
        String key = this.getKey(useKey);
        StreamParameterization parameterization = this.substances.get(key);
        if (parameterization == null) {
            this.throwSubstanceMissing("getEnergyIntensity", useKey.getApplication(), useKey.getSubstance());
        }
        return parameterization.getEnergyIntensity();
    }

    public void setInitialCharge(UseKey useKey, String substream, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setInitialCharge(substream, newValue);
    }

    public EngineNumber getInitialCharge(UseKey useKey, String substream) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getInitialCharge(substream);
    }

    public void setRechargePopulation(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRechargePopulation(newValue);
    }

    public EngineNumber getRechargePopulation(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRechargePopulation();
    }

    public void setRechargeIntensity(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRechargeIntensity(newValue);
    }

    public EngineNumber getRechargeIntensity(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRechargeIntensity();
    }

    public void accumulateRecharge(UseKey useKey, EngineNumber population, EngineNumber intensity) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.accumulateRecharge(population, intensity);
    }

    public Optional<EngineNumber> getRechargeBasePopulation(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRechargeBasePopulation();
    }

    public void setRechargeBasePopulation(UseKey useKey, EngineNumber value) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRechargeBasePopulation(value);
    }

    public Optional<EngineNumber> getAppliedRechargeAmount(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getAppliedRechargeAmount();
    }

    public void setAppliedRechargeAmount(UseKey useKey, EngineNumber value) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setAppliedRechargeAmount(value);
    }

    public boolean isRecyclingCalculatedThisStep(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.isRecyclingCalculatedThisStep();
    }

    public void setRecyclingCalculatedThisStep(UseKey useKey, boolean calculated) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRecyclingCalculatedThisStep(calculated);
    }

    public void setRecoveryRate(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        EngineNumber existingRecovery = parameterization.getRecoveryRate();
        if (existingRecovery.getValue().compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber existingRecoveryPercent = this.unitConverter.convert(existingRecovery, "%");
            EngineNumber newRecoveryPercent = this.unitConverter.convert(newValue, "%");
            BigDecimal combinedRecovery = existingRecoveryPercent.getValue().add(newRecoveryPercent.getValue());
            parameterization.setRecoveryRate(new EngineNumber(combinedRecovery, "%"));
        } else {
            parameterization.setRecoveryRate(newValue);
        }
    }

    public void setRecoveryRate(UseKey useKey, EngineNumber newValue, RecoverOperation.RecoveryStage stage) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        EngineNumber existingRecovery = parameterization.getRecoveryRate(stage);
        if (existingRecovery.getValue().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal newRate = existingRecovery.getValue().add(newValue.getValue());
            EngineNumber combinedRate = new EngineNumber(newRate, "%");
            parameterization.setRecoveryRate(combinedRate, stage);
            return;
        }
        parameterization.setRecoveryRate(newValue, stage);
    }

    public EngineNumber getRecoveryRate(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRecoveryRate();
    }

    public EngineNumber getRecoveryRate(UseKey useKey, RecoverOperation.RecoveryStage stage) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRecoveryRate(stage);
    }

    public void setYieldRate(UseKey useKey, EngineNumber newValue) {
        this.setYieldRate(useKey, newValue, RecoverOperation.RecoveryStage.RECHARGE);
    }

    public void setYieldRate(UseKey useKey, EngineNumber newValue, RecoverOperation.RecoveryStage stage) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        EngineNumber existingYield = parameterization.getYieldRate(stage);
        if (existingYield.getValue().compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber existingYieldPercent = this.unitConverter.convert(existingYield, "%");
            EngineNumber newYieldPercent = this.unitConverter.convert(newValue, "%");
            BigDecimal combinedYield = existingYieldPercent.getValue().add(newYieldPercent.getValue()).divide(BigDecimal.valueOf(2L), MathContext.DECIMAL128);
            parameterization.setYieldRate(new EngineNumber(combinedYield, "%"), stage);
        } else {
            parameterization.setYieldRate(newValue, stage);
        }
    }

    public EngineNumber getYieldRate(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getYieldRate();
    }

    public EngineNumber getYieldRate(UseKey useKey, RecoverOperation.RecoveryStage stage) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getYieldRate(stage);
    }

    public void setInductionRate(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setInductionRate(newValue);
    }

    public void setInductionRate(UseKey useKey, EngineNumber newValue, RecoverOperation.RecoveryStage stage) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setInductionRate(newValue, stage);
    }

    public EngineNumber getInductionRate(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getInductionRate();
    }

    public EngineNumber getInductionRate(UseKey useKey, RecoverOperation.RecoveryStage stage) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getInductionRate(stage);
    }

    public void setRetirementRate(UseKey useKey, EngineNumber newValue) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRetirementRate(newValue);
    }

    public EngineNumber getRetirementRate(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRetirementRate();
    }

    public Optional<EngineNumber> getRetirementBasePopulation(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRetirementBasePopulation();
    }

    public void setRetirementBasePopulation(UseKey useKey, EngineNumber value) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRetirementBasePopulation(value);
    }

    public Optional<EngineNumber> getAppliedRetirementAmount(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getAppliedRetirementAmount();
    }

    public void setAppliedRetirementAmount(UseKey useKey, EngineNumber value) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setAppliedRetirementAmount(value);
    }

    public boolean getHasReplacementThisStep(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getHasReplacementThisStep();
    }

    public void setHasReplacementThisStep(UseKey useKey, boolean value) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setHasReplacementThisStep(value);
    }

    public boolean getRetireCalculatedThisStep(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getRetireCalculatedThisStep();
    }

    public void setRetireCalculatedThisStep(UseKey useKey, boolean calculated) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setRetireCalculatedThisStep(calculated);
    }

    public void setLastSpecifiedValue(UseKey useKey, String streamName, EngineNumber value) {
        String key = this.getKey(useKey);
        StreamParameterization parameterization = this.substances.get(key);
        if (parameterization == null) {
            this.throwSubstanceMissing("setLastSpecifiedValue", useKey.getApplication(), useKey.getSubstance());
        }
        parameterization.setLastSpecifiedValue(streamName, value);
    }

    public EngineNumber getLastSpecifiedValue(UseKey useKey, String streamName) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.getLastSpecifiedValue(streamName);
    }

    public boolean hasLastSpecifiedValue(UseKey useKey, String streamName) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.hasLastSpecifiedValue(streamName);
    }

    public boolean isSalesIntentFreshlySet(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.isSalesIntentFreshlySet();
    }

    public void resetSalesIntentFlag(UseKey useKey) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.setSalesIntentFreshlySet(false);
    }

    public boolean hasStreamBeenEnabled(UseKey useKey, String streamName) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        return parameterization.hasStreamBeenEnabled(streamName);
    }

    public void markStreamAsEnabled(UseKey useKey, String streamName) {
        StreamParameterization parameterization = this.getParameterization(useKey);
        parameterization.markStreamAsEnabled(streamName);
    }

    private StreamParameterization getParameterization(UseKey scope) {
        String key = this.getKey(scope);
        StreamParameterization result = this.substances.get(key);
        if (result == null) {
            this.throwSubstanceMissing("getParameterization", scope.getApplication(), scope.getSubstance());
        }
        return result;
    }

    private String getKey(UseKey useKey) {
        return useKey.getKey();
    }

    private String getKey(UseKey useKey, String name) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(this.getKey(useKey));
        keyBuilder.append("\t");
        keyBuilder.append(name != null ? name : "-");
        return keyBuilder.toString();
    }

    private void setSimpleStream(UseKey useKey, String name, EngineNumber value) {
        String unitsNeeded = this.getUnits(name);
        EngineNumber valueConverted = this.unitConverter.convert(value, unitsNeeded);
        String streamKey = this.getKey(useKey, name);
        this.streams.put(streamKey, valueConverted);
    }

    private void setStreamForSales(UseKey useKey, String name, EngineNumber value) {
        EngineNumber recycleAmountRaw;
        EngineNumber recycleAmount;
        BigDecimal recycleKg;
        EngineNumber valueConverted = this.unitConverter.convert(value, "kg");
        BigDecimal amountKg = valueConverted.getValue();
        BigDecimal virginMaterialKg = amountKg.subtract(recycleKg = (recycleAmount = this.unitConverter.convert(recycleAmountRaw = this.getStream(useKey, "recycle"), "kg")) != null ? recycleAmount.getValue() : BigDecimal.ZERO);
        if (virginMaterialKg.compareTo(BigDecimal.ZERO) < 0) {
            virginMaterialKg = BigDecimal.ZERO;
        }
        SalesStreamDistribution distribution = this.getDistribution(useKey);
        BigDecimal domesticPercent = distribution.getPercentDomestic();
        BigDecimal importPercent = distribution.getPercentImport();
        BigDecimal newDomesticAmount = virginMaterialKg.multiply(domesticPercent);
        BigDecimal newImportAmount = virginMaterialKg.multiply(importPercent);
        EngineNumber domesticAmountToSet = new EngineNumber(newDomesticAmount, "kg");
        EngineNumber importAmountToSet = new EngineNumber(newImportAmount, "kg");
        this.setSimpleStream(useKey, "domestic", domesticAmountToSet);
        this.setSimpleStream(useKey, "import", importAmountToSet);
    }

    private void setStreamForRecycle(UseKey useKey, String name, EngineNumber value) {
        BigDecimal newRecycleEolAmount;
        BigDecimal newRecycleRechargeAmount;
        boolean noExistingRecycling;
        EngineNumber valueConverted = this.unitConverter.convert(value, "kg");
        BigDecimal totalRecycleKg = valueConverted.getValue();
        EngineNumber recycleRechargeAmountRaw = this.getStream(useKey, "recycleRecharge");
        EngineNumber recycleEolAmountRaw = this.getStream(useKey, "recycleEol");
        EngineNumber recycleRechargeAmount = this.unitConverter.convert(recycleRechargeAmountRaw, "kg");
        EngineNumber recycleEolAmount = this.unitConverter.convert(recycleEolAmountRaw, "kg");
        BigDecimal recycleRechargeKg = recycleRechargeAmount != null ? recycleRechargeAmount.getValue() : BigDecimal.ZERO;
        BigDecimal recycleEolKg = recycleEolAmount != null ? recycleEolAmount.getValue() : BigDecimal.ZERO;
        BigDecimal totalExistingRecycle = recycleRechargeKg.add(recycleEolKg);
        boolean bl = noExistingRecycling = totalExistingRecycle.compareTo(BigDecimal.ZERO) == 0;
        if (noExistingRecycling) {
            newRecycleRechargeAmount = totalRecycleKg.divide(new BigDecimal("2"));
            newRecycleEolAmount = totalRecycleKg.divide(new BigDecimal("2"));
        } else {
            BigDecimal rechargePercent = recycleRechargeKg.divide(totalExistingRecycle, MathContext.DECIMAL128);
            BigDecimal eolPercent = recycleEolKg.divide(totalExistingRecycle, MathContext.DECIMAL128);
            newRecycleRechargeAmount = totalRecycleKg.multiply(rechargePercent);
            newRecycleEolAmount = totalRecycleKg.multiply(eolPercent);
        }
        EngineNumber recycleRechargeAmountToSet = new EngineNumber(newRecycleRechargeAmount, "kg");
        EngineNumber recycleEolAmountToSet = new EngineNumber(newRecycleEolAmount, "kg");
        this.setSimpleStream(useKey, "recycleRecharge", recycleRechargeAmountToSet);
        this.setSimpleStream(useKey, "recycleEol", recycleEolAmountToSet);
    }

    private void setStreamForSalesWithUnits(UseKey useKey, String name, EngineNumber value) {
        boolean noInitialCharge;
        OverridingConverterStateGetter overridingStateGetter = new OverridingConverterStateGetter(this.stateGetter);
        UnitConverter unitConverter = new UnitConverter(overridingStateGetter);
        EngineNumber initialCharge = this.getInitialCharge(useKey, name);
        boolean bl = noInitialCharge = initialCharge.getValue().compareTo(BigDecimal.ZERO) == 0;
        if (noInitialCharge) {
            throw new RuntimeException("Cannot set " + name + " stream with a zero initial charge.");
        }
        EngineNumber initialChargeConverted = unitConverter.convert(initialCharge, "kg / unit");
        overridingStateGetter.setAmortizedUnitVolume(initialChargeConverted);
        EngineNumber valueUnitsPlain = unitConverter.convert(value, "units");
        EngineNumber valueConverted = unitConverter.convert(valueUnitsPlain, "kg");
        BigDecimal amountKg = valueConverted.getValue();
        String streamKey = this.getKey(useKey, name);
        EngineNumber amountToSet = new EngineNumber(amountKg, "kg");
        this.streams.put(streamKey, amountToSet);
    }

    private void ensureSubstanceOrThrow(String key, String context) {
        if (key == null) {
            throw new IllegalStateException("Key cannot be null in " + context);
        }
        if (!this.substances.containsKey(key)) {
            this.throwSubstanceMissing(context, key.split("\t")[0], key.split("\t")[1]);
        }
    }

    private void throwSubstanceMissing(String context, String application, String substance) {
        StringBuilder message = new StringBuilder();
        message.append("Not a known application substance pair in ");
        message.append(context);
        message.append(": ");
        message.append(application);
        message.append(", ");
        message.append(substance);
        throw new IllegalStateException(message.toString());
    }

    private void ensureStreamKnown(String name) {
        if (EngineConstants.getBaseUnits(name) == null) {
            throw new IllegalArgumentException("Unknown stream: " + name);
        }
    }

    private void assertStreamEnabled(UseKey useKey, String streamName, EngineNumber value) {
        if (!("domestic".equals(streamName) || "import".equals(streamName) || "export".equals(streamName))) {
            return;
        }
        if (value.getValue().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        StreamParameterization parameterization = this.getParameterization(useKey);
        if (!parameterization.hasStreamBeenEnabled(streamName)) {
            throw new RuntimeException("Stream '" + streamName + "' has not been enabled for " + useKey.getApplication() + "/" + useKey.getSubstance() + ". Check if you still have a command on this stream which may be erroneous or enable the stream.");
        }
    }

    private String getUnits(String name) {
        this.ensureStreamKnown(name);
        return EngineConstants.getBaseUnits(name);
    }

    private boolean getIsSettingVolumeByUnits(String name, EngineNumber value) {
        boolean isSalesComponent = switch (name) {
            case "domestic", "import", "sales" -> true;
            default -> false;
        };
        boolean isUnits = value.getUnits().startsWith("unit");
        return isSalesComponent && isUnits;
    }

    private BigDecimal calculateCurrentRecyclingAmount(UseKey useKey) {
        EngineNumber priorPopulationRaw = this.getStream(useKey, "priorEquipment");
        if (priorPopulationRaw == null) {
            return BigDecimal.ZERO;
        }
        EngineNumber priorPopulation = this.unitConverter.convert(priorPopulationRaw, "units");
        StreamParameterization parameterization = this.getParameterization(useKey);
        EngineNumber retirementRate = parameterization.getRetirementRate();
        BigDecimal retirementRateRatio = retirementRate.getUnits().contains("%") ? retirementRate.getValue().divide(HUNDRED_PERCENT, MathContext.DECIMAL128) : retirementRate.getValue();
        BigDecimal retiredUnits = priorPopulation.getValue().multiply(retirementRateRatio);
        EngineNumber recoveryRate = parameterization.getRecoveryRate();
        BigDecimal recoveryRateRatio = recoveryRate.getUnits().contains("%") ? recoveryRate.getValue().divide(HUNDRED_PERCENT, MathContext.DECIMAL128) : recoveryRate.getValue();
        BigDecimal recoveredUnits = retiredUnits.multiply(recoveryRateRatio);
        EngineNumber yieldRate = parameterization.getYieldRate();
        BigDecimal yieldRateRatio = yieldRate.getUnits().contains("%") ? yieldRate.getValue().divide(HUNDRED_PERCENT, MathContext.DECIMAL128) : yieldRate.getValue();
        BigDecimal recycledUnits = recoveredUnits.multiply(yieldRateRatio);
        EngineNumber initialCharge = parameterization.getInitialCharge("import");
        EngineNumber initialChargeConverted = this.unitConverter.convert(initialCharge, "kg / unit");
        BigDecimal recycledKg = recycledUnits.multiply(initialChargeConverted.getValue());
        return recycledKg;
    }

    private void redistributeRecyclingToSales() {
        for (String key : this.substances.keySet()) {
            EngineNumber totalRecycling;
            EngineNumber recyclingKg;
            String substance;
            String[] keyPieces = key.split("\t");
            String application = keyPieces[0];
            SimpleUseKey useKey = new SimpleUseKey(application, substance = keyPieces[1]);
            if (!this.hasStreamsEnabled(useKey)) continue;
            StreamParameterization parameterization = this.getParameterization(useKey);
            boolean salesWasSet = parameterization.hasLastSpecifiedValue("sales");
            boolean domesticWasSet = parameterization.hasLastSpecifiedValue("domestic");
            boolean importWasSet = parameterization.hasLastSpecifiedValue("import");
            if (!salesWasSet && !domesticWasSet && !importWasSet || (recyclingKg = this.unitConverter.convert(totalRecycling = this.getStream(useKey, "recycle"), "kg")).getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
            SalesStreamDistribution distribution = this.getDistribution(useKey, false);
            BigDecimal domesticAdd = recyclingKg.getValue().multiply(distribution.getPercentDomestic());
            BigDecimal importAdd = recyclingKg.getValue().multiply(distribution.getPercentImport());
            EngineNumber currentDomestic = this.getStream(useKey, "domestic");
            EngineNumber currentImport = this.getStream(useKey, "import");
            EngineNumber domesticConverted = this.unitConverter.convert(currentDomestic, "kg");
            EngineNumber importConverted = this.unitConverter.convert(currentImport, "kg");
            BigDecimal newDomestic = domesticConverted.getValue().add(domesticAdd);
            BigDecimal newImport = importConverted.getValue().add(importAdd);
            this.setSimpleStream(useKey, "domestic", new EngineNumber(newDomestic, "kg"));
            this.setSimpleStream(useKey, "import", new EngineNumber(newImport, "kg"));
        }
    }

    private void redistributeInductionFromSales() {
        for (String key : this.substances.keySet()) {
            EngineNumber totalInduction;
            EngineNumber inductionKg;
            String substance;
            String[] keyPieces = key.split("\t");
            String application = keyPieces[0];
            SimpleUseKey useKey = new SimpleUseKey(application, substance = keyPieces[1]);
            if (!this.hasStreamsEnabled(useKey) || (inductionKg = this.unitConverter.convert(totalInduction = this.getTotalInductionStream(useKey), "kg")).getValue().compareTo(BigDecimal.ZERO) <= 0) continue;
            SalesStreamDistribution distribution = this.getDistribution(useKey, false);
            BigDecimal domesticSubtract = inductionKg.getValue().multiply(distribution.getPercentDomestic());
            BigDecimal importSubtract = inductionKg.getValue().multiply(distribution.getPercentImport());
            EngineNumber currentDomestic = this.getStream(useKey, "domestic");
            EngineNumber currentImport = this.getStream(useKey, "import");
            EngineNumber domesticConverted = this.unitConverter.convert(currentDomestic, "kg");
            EngineNumber importConverted = this.unitConverter.convert(currentImport, "kg");
            BigDecimal newDomestic = domesticConverted.getValue().subtract(domesticSubtract).max(BigDecimal.ZERO);
            BigDecimal newImport = importConverted.getValue().subtract(importSubtract).max(BigDecimal.ZERO);
            this.setSimpleStream(useKey, "domestic", new EngineNumber(newDomestic, "kg"));
            this.setSimpleStream(useKey, "import", new EngineNumber(newImport, "kg"));
        }
    }

    private void updatePriorEquipmentBase(UseKey useKey, String streamName, EngineNumber newValue) {
        boolean withinTolerance;
        BigDecimal newPriorValue;
        boolean nothingToUpdate;
        boolean noParameterizationYet;
        if (!"priorEquipment".equals(streamName)) {
            return;
        }
        String key = this.getKey(useKey);
        StreamParameterization param = this.substances.get(key);
        boolean bl = noParameterizationYet = param == null;
        if (noParameterizationYet) {
            return;
        }
        EngineNumber newPriorUnits = this.unitConverter.convert(newValue, "units");
        Optional<EngineNumber> retireBaseOpt = param.getRetirementBasePopulation();
        Optional<EngineNumber> rechargeBaseOpt = param.getRechargeBasePopulation();
        boolean retireBaseActive = retireBaseOpt.isPresent();
        boolean rechargeBaseActive = rechargeBaseOpt.isPresent();
        boolean bl2 = nothingToUpdate = !retireBaseActive && !rechargeBaseActive;
        if (nothingToUpdate) {
            return;
        }
        EngineNumber currentPriorRaw = this.getStream(useKey, "priorEquipment");
        EngineNumber currentPriorUnits = this.unitConverter.convert(currentPriorRaw, "units");
        BigDecimal currentPriorValue = currentPriorUnits.getValue();
        BigDecimal diff = currentPriorValue.subtract(newPriorValue = newPriorUnits.getValue()).abs();
        boolean bl3 = withinTolerance = diff.compareTo(BASE_CHANGE_TOLERANCE) <= 0;
        if (withinTolerance) {
            return;
        }
        if (retireBaseActive) {
            this.updateRetireBase(useKey, newValue, retireBaseOpt.get(), param);
        }
        if (rechargeBaseActive) {
            this.updateRechargeBase(useKey, newValue, rechargeBaseOpt.get(), param);
        }
    }

    private void updateRetireBase(UseKey useKey, EngineNumber newValue, EngineNumber retireBase, StreamParameterization param) {
        boolean noPriorBase;
        EngineNumber newPriorUnits = this.unitConverter.convert(newValue, "units");
        Optional<EngineNumber> appliedRetireOpt = param.getAppliedRetirementAmount();
        EngineNumber appliedRetire = appliedRetireOpt.orElse(new EngineNumber(BigDecimal.ZERO, "units"));
        boolean bl = noPriorBase = retireBase.getValue().compareTo(BigDecimal.ZERO) == 0;
        if (noPriorBase) {
            param.setRetirementBasePopulation(newPriorUnits);
            param.setAppliedRetirementAmount(new EngineNumber(BigDecimal.ZERO, "units"));
        } else {
            BigDecimal retirePercent = appliedRetire.getValue().divide(retireBase.getValue(), MathContext.DECIMAL128);
            BigDecimal newApplied = newPriorUnits.getValue().multiply(retirePercent);
            param.setRetirementBasePopulation(newPriorUnits);
            param.setAppliedRetirementAmount(new EngineNumber(newApplied, "units"));
        }
    }

    private void updateRechargeBase(UseKey useKey, EngineNumber newValue, EngineNumber rechargeBase, StreamParameterization param) {
        boolean noPriorBase;
        EngineNumber newPriorUnits = this.unitConverter.convert(newValue, "units");
        Optional<EngineNumber> appliedRechargeOpt = param.getAppliedRechargeAmount();
        EngineNumber appliedRecharge = appliedRechargeOpt.orElse(new EngineNumber(BigDecimal.ZERO, "kg"));
        boolean bl = noPriorBase = rechargeBase.getValue().compareTo(BigDecimal.ZERO) == 0;
        if (noPriorBase) {
            param.setRechargeBasePopulation(newPriorUnits);
            param.setAppliedRechargeAmount(new EngineNumber(BigDecimal.ZERO, "kg"));
        } else {
            BigDecimal baseRatio = newPriorUnits.getValue().divide(rechargeBase.getValue(), MathContext.DECIMAL128);
            BigDecimal newApplied = appliedRecharge.getValue().multiply(baseRatio);
            param.setRechargeBasePopulation(newPriorUnits);
            param.setAppliedRechargeAmount(new EngineNumber(newApplied, "kg"));
        }
    }
}

