/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.UseKey;

public final class SimulationStateUpdateBuilder {
    private UseKey useKey;
    private String name;
    private EngineNumber value;
    private boolean subtractRecycling = true;
    private Optional<SalesStreamDistribution> distribution = Optional.empty();
    private boolean invalidatePriorEquipment = true;

    public SimulationStateUpdateBuilder setUseKey(UseKey useKey) {
        this.useKey = useKey;
        return this;
    }

    public SimulationStateUpdateBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SimulationStateUpdateBuilder setValue(EngineNumber value) {
        this.value = value;
        return this;
    }

    public SimulationStateUpdateBuilder setSubtractRecycling(boolean subtractRecycling) {
        this.subtractRecycling = subtractRecycling;
        return this;
    }

    public SimulationStateUpdateBuilder setDistribution(SalesStreamDistribution distribution) {
        this.distribution = Optional.ofNullable(distribution);
        return this;
    }

    public SimulationStateUpdateBuilder clearDistribution() {
        this.distribution = Optional.empty();
        return this;
    }

    public SimulationStateUpdateBuilder setInvalidatePriorEquipment(boolean invalidatePriorEquipment) {
        this.invalidatePriorEquipment = invalidatePriorEquipment;
        return this;
    }

    private static boolean inferSalesDistributionRequired(String streamName) {
        if (streamName == null) {
            return false;
        }
        return switch (streamName) {
            case "sales", "domestic", "import", "export" -> true;
            default -> false;
        };
    }

    public SimulationStateUpdate build() {
        if (this.useKey == null) {
            throw new IllegalStateException("UseKey is required");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name is required");
        }
        if (this.value == null) {
            throw new IllegalStateException("Value is required");
        }
        return new SimulationStateUpdate(this.useKey, this.name, this.value, this.subtractRecycling, this.distribution, SimulationStateUpdateBuilder.inferSalesDistributionRequired(this.name), this.invalidatePriorEquipment);
    }
}

