/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.PriorEquipmentBases;
import org.kigalisim.engine.state.RechargeInformation;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.lang.operation.RecoverOperation;

public class StreamParameterization {
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    private EngineNumber ghgIntensity;
    private EngineNumber energyIntensity;
    private final Map<String, EngineNumber> initialCharge = new HashMap<String, EngineNumber>();
    private EngineNumber rechargePopulation;
    private EngineNumber rechargeIntensity;
    private EngineNumber recoveryRateRecharge;
    private EngineNumber yieldRateRecharge;
    private EngineNumber recoveryRateEol;
    private EngineNumber yieldRateEol;
    private EngineNumber retirementRate;
    private EngineNumber inductionRateRecharge;
    private EngineNumber inductionRateEol;
    private final Map<String, EngineNumber> lastSpecifiedValue;
    private final Set<String> enabledStreams = new HashSet<String>();
    private boolean salesIntentFreshlySet = false;
    private PriorEquipmentBases priorEquipmentBases;

    public StreamParameterization() {
        this.lastSpecifiedValue = new HashMap<String, EngineNumber>();
        this.ghgIntensity = new EngineNumber(BigDecimal.ZERO, "tCO2e / kg");
        this.energyIntensity = new EngineNumber(BigDecimal.ZERO, "kwh / kg");
        this.initialCharge.put("domestic", new EngineNumber(BigDecimal.ONE, "kg / unit"));
        this.initialCharge.put("import", new EngineNumber(BigDecimal.ONE, "kg / unit"));
        this.rechargePopulation = new EngineNumber(BigDecimal.ZERO, "%");
        this.rechargeIntensity = new EngineNumber(BigDecimal.ZERO, "kg / unit");
        this.recoveryRateRecharge = new EngineNumber(BigDecimal.ZERO, "%");
        this.yieldRateRecharge = new EngineNumber(BigDecimal.ZERO, "%");
        this.recoveryRateEol = new EngineNumber(BigDecimal.ZERO, "%");
        this.yieldRateEol = new EngineNumber(BigDecimal.ZERO, "%");
        this.retirementRate = new EngineNumber(BigDecimal.ZERO, "%");
        this.inductionRateRecharge = StreamParameterization.getDefaultInductionRate();
        this.inductionRateEol = StreamParameterization.getDefaultInductionRate();
        this.priorEquipmentBases = new PriorEquipmentBases();
        this.setLastSpecifiedValue("domestic", SimulationState.ZERO_VOLUME);
        this.setLastSpecifiedValue("import", SimulationState.ZERO_VOLUME);
        this.setLastSpecifiedValue("export", SimulationState.ZERO_VOLUME);
        this.setSalesIntentFreshlySet(false);
    }

    public void setGhgIntensity(EngineNumber newValue) {
        this.ghgIntensity = newValue;
    }

    public EngineNumber getGhgIntensity() {
        return this.ghgIntensity;
    }

    public void setEnergyIntensity(EngineNumber newValue) {
        this.energyIntensity = newValue;
    }

    public EngineNumber getEnergyIntensity() {
        return this.energyIntensity;
    }

    public void setInitialCharge(String stream, EngineNumber newValue) {
        this.ensureSalesStreamAllowed(stream);
        this.initialCharge.put(stream, newValue);
    }

    public EngineNumber getInitialCharge(String stream) {
        this.ensureSalesStreamAllowed(stream);
        return this.initialCharge.get(stream);
    }

    public void setRechargePopulation(EngineNumber newValue) {
        this.rechargePopulation = this.clampRate(newValue);
    }

    public EngineNumber getRechargePopulation() {
        return this.rechargePopulation;
    }

    public void setRechargeIntensity(EngineNumber newValue) {
        this.rechargeIntensity = newValue;
    }

    public EngineNumber getRechargeIntensity() {
        return this.rechargeIntensity;
    }

    public void setRecoveryRate(EngineNumber newValue) {
        this.recoveryRateRecharge = newValue;
    }

    public void setRecoveryRate(EngineNumber newValue, RecoverOperation.RecoveryStage stage) {
        switch (stage) {
            case EOL: {
                this.recoveryRateEol = newValue;
                break;
            }
            case RECHARGE: {
                this.recoveryRateRecharge = newValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery stage: " + String.valueOf((Object)stage));
            }
        }
    }

    public EngineNumber getRecoveryRate() {
        return this.recoveryRateRecharge;
    }

    public EngineNumber getRecoveryRate(RecoverOperation.RecoveryStage stage) {
        return switch (stage) {
            default -> throw new MatchException(null, null);
            case RecoverOperation.RecoveryStage.EOL -> this.recoveryRateEol;
            case RecoverOperation.RecoveryStage.RECHARGE -> this.recoveryRateRecharge;
        };
    }

    public void setYieldRate(EngineNumber newValue) {
        this.yieldRateRecharge = newValue;
    }

    public void setYieldRate(EngineNumber newValue, RecoverOperation.RecoveryStage stage) {
        switch (stage) {
            case EOL: {
                this.yieldRateEol = newValue;
                break;
            }
            case RECHARGE: {
                this.yieldRateRecharge = newValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery stage: " + String.valueOf((Object)stage));
            }
        }
    }

    public EngineNumber getYieldRate() {
        return this.yieldRateRecharge;
    }

    public EngineNumber getYieldRate(RecoverOperation.RecoveryStage stage) {
        return switch (stage) {
            default -> throw new MatchException(null, null);
            case RecoverOperation.RecoveryStage.EOL -> this.yieldRateEol;
            case RecoverOperation.RecoveryStage.RECHARGE -> this.yieldRateRecharge;
        };
    }

    public void setInductionRate(EngineNumber newValue) {
        this.inductionRateRecharge = newValue;
    }

    public void setInductionRate(EngineNumber newValue, RecoverOperation.RecoveryStage stage) {
        switch (stage) {
            case EOL: {
                this.inductionRateEol = newValue;
                break;
            }
            case RECHARGE: {
                this.inductionRateRecharge = newValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown recovery stage: " + String.valueOf((Object)stage));
            }
        }
    }

    public EngineNumber getInductionRate() {
        return this.inductionRateRecharge;
    }

    public EngineNumber getInductionRate(RecoverOperation.RecoveryStage stage) {
        return switch (stage) {
            default -> throw new MatchException(null, null);
            case RecoverOperation.RecoveryStage.EOL -> this.inductionRateEol;
            case RecoverOperation.RecoveryStage.RECHARGE -> this.inductionRateRecharge;
        };
    }

    private static EngineNumber getDefaultInductionRate() {
        return new EngineNumber(new BigDecimal("100"), "%");
    }

    public void setRetirementRate(EngineNumber newValue) {
        BigDecimal currentValue = this.retirementRate.getValue();
        BigDecimal newTotal = currentValue.add(newValue.getValue());
        EngineNumber candidateRetirementRate = new EngineNumber(newTotal, newValue.getUnits());
        this.retirementRate = this.clampRate(candidateRetirementRate);
    }

    public EngineNumber getRetirementRate() {
        return this.retirementRate;
    }

    public Optional<EngineNumber> getRetirementBasePopulation() {
        return this.priorEquipmentBases.getRetirementBasePopulation();
    }

    public void setRetirementBasePopulation(EngineNumber value) {
        this.priorEquipmentBases.setRetirementBasePopulation(value);
    }

    public Optional<EngineNumber> getAppliedRetirementAmount() {
        return this.priorEquipmentBases.getAppliedRetirementAmount();
    }

    public void setAppliedRetirementAmount(EngineNumber value) {
        this.priorEquipmentBases.setAppliedRetirementAmount(value);
    }

    public boolean getHasReplacementThisStep() {
        return this.priorEquipmentBases.getHasReplacementThisStep();
    }

    public void setHasReplacementThisStep(boolean value) {
        this.priorEquipmentBases.setHasReplacementThisStep(value);
    }

    public boolean getRetireCalculatedThisStep() {
        return this.priorEquipmentBases.getRetireCalculatedThisStep();
    }

    public void setRetireCalculatedThisStep(boolean calculated) {
        this.priorEquipmentBases.setRetireCalculatedThisStep(calculated);
    }

    public Optional<EngineNumber> getRechargeBasePopulation() {
        return this.priorEquipmentBases.getRechargeBasePopulation();
    }

    public void setRechargeBasePopulation(EngineNumber value) {
        this.priorEquipmentBases.setRechargeBasePopulation(value);
    }

    public Optional<EngineNumber> getAppliedRechargeAmount() {
        return this.priorEquipmentBases.getAppliedRechargeAmount();
    }

    public void setAppliedRechargeAmount(EngineNumber value) {
        this.priorEquipmentBases.setAppliedRechargeAmount(value);
    }

    public boolean isRecyclingCalculatedThisStep() {
        return this.priorEquipmentBases.getRecyclingCalculatedThisStep();
    }

    public void setRecyclingCalculatedThisStep(boolean calculated) {
        this.priorEquipmentBases.setRecyclingCalculatedThisStep(calculated);
    }

    public void accumulateRecharge(EngineNumber population, EngineNumber intensity) {
        RechargeInformation currentInfo = new RechargeInformation(this.rechargePopulation, this.rechargeIntensity);
        RechargeInformation result = currentInfo.add(population, intensity);
        this.rechargePopulation = this.clampRate(result.getPopulation());
        this.rechargeIntensity = result.getIntensity();
    }

    public void setLastSpecifiedValue(String streamName, EngineNumber value) {
        if (value != null && value.getUnits() != null && value.getUnits().contains("%")) {
            return;
        }
        this.lastSpecifiedValue.put(streamName, value);
        if ("sales".equals(streamName) || "import".equals(streamName) || "domestic".equals(streamName)) {
            this.salesIntentFreshlySet = true;
        }
    }

    public EngineNumber getLastSpecifiedValue(String streamName) {
        return this.lastSpecifiedValue.get(streamName);
    }

    public boolean hasLastSpecifiedValue(String streamName) {
        return this.lastSpecifiedValue.containsKey(streamName);
    }

    public void markStreamAsEnabled(String streamName) {
        this.enabledStreams.add(streamName);
    }

    public boolean hasStreamBeenEnabled(String streamName) {
        return this.enabledStreams.contains(streamName);
    }

    public boolean isSalesIntentFreshlySet() {
        return this.salesIntentFreshlySet;
    }

    public void setSalesIntentFreshlySet(boolean freshlySet) {
        this.salesIntentFreshlySet = freshlySet;
    }

    public void resetStateAtTimestep() {
        this.recoveryRateRecharge = new EngineNumber(BigDecimal.ZERO, "%");
        this.recoveryRateEol = new EngineNumber(BigDecimal.ZERO, "%");
        this.inductionRateRecharge = StreamParameterization.getDefaultInductionRate();
        this.inductionRateEol = StreamParameterization.getDefaultInductionRate();
        this.retirementRate = new EngineNumber(BigDecimal.ZERO, "%");
        this.rechargePopulation = new EngineNumber(BigDecimal.ZERO, "%");
        this.rechargeIntensity = new EngineNumber(BigDecimal.ZERO, "kg / unit");
        this.priorEquipmentBases.resetStateAtTimestep();
    }

    private boolean getIsSalesStreamAllowed(String name) {
        return switch (name) {
            case "domestic", "import", "export", "recycle", "recycleRecharge", "recycleEol" -> true;
            default -> false;
        };
    }

    private void ensureSalesStreamAllowed(String name) {
        if (!this.getIsSalesStreamAllowed(name)) {
            throw new IllegalArgumentException("Must address a sales substream.");
        }
    }

    private EngineNumber clampRate(EngineNumber target) {
        boolean isOver100;
        if (target.getValue().compareTo(BigDecimal.ZERO) < 0) {
            return new EngineNumber(BigDecimal.ZERO, target.getUnits());
        }
        boolean bl = isOver100 = target.getValue().compareTo(ONE_HUNDRED) > 0;
        if (isOver100 && target.getUnits().equals("%")) {
            return new EngineNumber(ONE_HUNDRED, target.getUnits());
        }
        return target;
    }
}

