/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.util.HashMap;
import java.util.Map;
import org.kigalisim.engine.number.EngineNumber;

public class VariableManager {
    private final Map<String, EngineNumber> globalContext;
    private final Map<String, EngineNumber> stanzaContext;
    private final Map<String, EngineNumber> applicationContext;
    private final Map<String, EngineNumber> substanceContext;
    private final int contextLevel;

    public VariableManager(int contextLevel, Map<String, EngineNumber> globalContext, Map<String, EngineNumber> stanzaContext, Map<String, EngineNumber> applicationContext, Map<String, EngineNumber> substanceContext) {
        this.globalContext = this.ensureContext(globalContext);
        this.stanzaContext = this.ensureContext(stanzaContext);
        this.applicationContext = this.ensureContext(applicationContext);
        this.substanceContext = this.ensureContext(substanceContext);
        this.contextLevel = contextLevel;
    }

    public VariableManager(int contextLevel) {
        this(contextLevel, null, null, null, null);
    }

    public VariableManager getWithLevel(int contextLevel) {
        if (contextLevel < 0 || contextLevel > 3) {
            throw new IllegalArgumentException("Unexpected context level: " + contextLevel);
        }
        Map<String, EngineNumber> newStanzaContext = this.stanzaContext;
        if (contextLevel <= 1) {
            newStanzaContext = new HashMap<String, EngineNumber>();
        }
        Map<String, EngineNumber> newApplicationContext = this.applicationContext;
        if (contextLevel <= 2) {
            newApplicationContext = new HashMap<String, EngineNumber>();
        }
        Map<String, EngineNumber> newSubstanceContext = this.substanceContext;
        if (contextLevel <= 3) {
            newSubstanceContext = new HashMap<String, EngineNumber>();
        }
        return new VariableManager(contextLevel, this.globalContext, newStanzaContext, newApplicationContext, newSubstanceContext);
    }

    public void defineVariable(String name) {
        Map<String, EngineNumber> context = this.getContextForLevel(this.contextLevel);
        if (context.containsKey(name)) {
            throw new IllegalStateException("Variable already defined in this scope: " + name);
        }
        context.put(name, null);
    }

    public void setVariable(String name, EngineNumber value) {
        for (int level = this.contextLevel; level >= 0; --level) {
            Map<String, EngineNumber> currentContext = this.getContextForLevel(level);
            if (!currentContext.containsKey(name)) continue;
            currentContext.put(name, value);
            return;
        }
        throw new IllegalStateException("Unable to find variable to set: " + name);
    }

    public EngineNumber getVariable(String name) {
        for (int level = this.contextLevel; level >= 0; --level) {
            Map<String, EngineNumber> currentContext = this.getContextForLevel(level);
            if (!currentContext.containsKey(name)) continue;
            return currentContext.get(name);
        }
        throw new IllegalStateException("Unable to find variable to read: " + name);
    }

    private Map<String, EngineNumber> getContextForLevel(int level) {
        return switch (level) {
            case 0 -> this.globalContext;
            case 1 -> this.stanzaContext;
            case 2 -> this.applicationContext;
            case 3 -> this.substanceContext;
            default -> throw new IllegalArgumentException("Invalid context level: " + level);
        };
    }

    private Map<String, EngineNumber> ensureContext(Map<String, EngineNumber> context) {
        return context == null ? new HashMap() : context;
    }
}

