/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.state;

import java.util.Optional;

public class YearMatcher {
    private final Optional<Integer> start;
    private final Optional<Integer> end;

    public YearMatcher(Optional<Integer> start, Optional<Integer> end) {
        boolean hasEmpty;
        boolean bl = hasEmpty = start.isEmpty() || end.isEmpty();
        if (hasEmpty) {
            this.start = start;
            this.end = end;
        } else {
            int startRearrange = Math.min(start.get(), end.get());
            int endRearrange = Math.max(start.get(), end.get());
            this.start = Optional.of(startRearrange);
            this.end = Optional.of(endRearrange);
        }
    }

    public YearMatcher(Integer start, Integer end) {
        this(Optional.ofNullable(start), Optional.ofNullable(end));
    }

    public static YearMatcher unbounded() {
        return new YearMatcher(Optional.empty(), Optional.empty());
    }

    public boolean getInRange(int year) {
        boolean meetsMin = this.start.isEmpty() || this.start.get() <= year;
        boolean meetsMax = this.end.isEmpty() || this.end.get() >= year;
        return meetsMin && meetsMax;
    }

    public Optional<Integer> getStart() {
        return this.start;
    }

    public Optional<Integer> getEnd() {
        return this.end;
    }
}

