/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.ChangeExecutorConfig;
import org.kigalisim.engine.support.ChangeExecutorConfigBuilder;
import org.kigalisim.engine.support.EngineSupportUtils;

public class ChangeExecutor {
    private final Engine engine;

    public ChangeExecutor(Engine engine) {
        this.engine = engine;
    }

    public void executeChange(String stream, EngineNumber amount, YearMatcher yearMatcher, UseKey useKeyEffective) {
        ChangeExecutorConfig config = new ChangeExecutorConfigBuilder().setStream(stream).setAmount(amount).setYearMatcher(yearMatcher).setUseKeyEffective(useKeyEffective).build();
        this.executeChange(config);
    }

    public void executeChange(ChangeExecutorConfig config) {
        boolean inRange = EngineSupportUtils.getIsInRange(config.getYearMatcher(), this.engine.getYear());
        if (!inRange) {
            return;
        }
        String stream = config.getStream();
        if ("sales".equals(stream)) {
            this.handleSalesChange(config);
        } else if (EngineSupportUtils.isSalesSubstream(stream) || "export".equals(stream)) {
            this.handleComponentStream(config);
        } else {
            this.handleDerivedStream(config);
        }
    }

    private void handleComponentStream(ChangeExecutorConfig config) {
        EngineNumber amount = config.getAmount();
        if (amount.getUnits() != null && amount.getUnits().contains("%")) {
            this.handlePercentageChange(config);
        } else if ("units".equals(amount.getUnits())) {
            this.handleUnitsChange(config);
        } else {
            this.handleVolumeChange(config);
        }
    }

    private void handleDerivedStream(ChangeExecutorConfig config) {
        String stream = config.getStream();
        EngineNumber amount = config.getAmount();
        UseKey useKeyEffective = config.getUseKeyEffective();
        EngineNumber currentValue = this.engine.getStream(stream, Optional.of(useKeyEffective), Optional.empty());
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber convertedDelta = unitConverter.convert(amount, currentValue.getUnits());
        BigDecimal newAmount = currentValue.getValue().add(convertedDelta.getValue());
        EngineNumber outputWithUnits = new EngineNumber(newAmount, currentValue.getUnits());
        StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(outputWithUnits).setKey(useKeyEffective).setUnitsToRecord(amount.getUnits()).build();
        this.engine.executeStreamUpdate(update);
    }

    private void handlePercentageChange(ChangeExecutorConfig config) {
        String stream = config.getStream();
        EngineNumber amount = config.getAmount();
        YearMatcher yearMatcher = config.getYearMatcher().orElse(null);
        UseKey useKeyEffective = config.getUseKeyEffective();
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber lastSpecified = simulationState.getLastSpecifiedValue(useKeyEffective, stream);
        if (lastSpecified == null) {
            return;
        }
        BigDecimal percentageValue = amount.getValue();
        BigDecimal changeAmount = lastSpecified.getValue().multiply(percentageValue).divide(new BigDecimal("100"));
        BigDecimal newTotalValue = lastSpecified.getValue().add(changeAmount);
        EngineNumber newTotal = new EngineNumber(newTotalValue, lastSpecified.getUnits());
        boolean subtractRecycling = "units".equals(lastSpecified.getUnits());
        StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(newTotal).setYearMatcher(Optional.ofNullable(yearMatcher)).setSubtractRecycling(subtractRecycling).build();
        this.engine.executeStreamUpdate(update);
    }

    private void handleSalesChange(ChangeExecutorConfig config) {
        EngineNumber amount = config.getAmount();
        YearMatcher yearMatcher = config.getYearMatcher().orElse(null);
        UseKey useKeyEffective = config.getUseKeyEffective();
        boolean inRange = EngineSupportUtils.getIsInRange(yearMatcher, this.engine.getYear());
        if (!inRange) {
            return;
        }
        SimulationState simulationState = this.engine.getStreamKeeper();
        SalesStreamDistribution distribution = simulationState.getDistribution(useKeyEffective);
        BigDecimal percentDomestic = distribution.getPercentDomestic();
        BigDecimal percentImport = distribution.getPercentImport();
        if (amount.getUnits() != null && amount.getUnits().contains("%")) {
            this.engine.changeStream("domestic", amount, yearMatcher, useKeyEffective);
            this.engine.changeStream("import", amount, yearMatcher, useKeyEffective);
        } else {
            BigDecimal domesticAmount = amount.getValue().multiply(percentDomestic);
            BigDecimal importAmount = amount.getValue().multiply(percentImport);
            EngineNumber domesticChange = new EngineNumber(domesticAmount, amount.getUnits());
            EngineNumber importChange = new EngineNumber(importAmount, amount.getUnits());
            this.engine.changeStream("domestic", domesticChange, yearMatcher, useKeyEffective);
            this.engine.changeStream("import", importChange, yearMatcher, useKeyEffective);
        }
    }

    private void handleUnitsChange(ChangeExecutorConfig config) {
        String stream = config.getStream();
        EngineNumber amount = config.getAmount();
        YearMatcher yearMatcher = config.getYearMatcher().orElse(null);
        UseKey useKeyEffective = config.getUseKeyEffective();
        boolean inRange = EngineSupportUtils.getIsInRange(yearMatcher, this.engine.getYear());
        if (!inRange) {
            return;
        }
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber lastSpecified = simulationState.getLastSpecifiedValue(useKeyEffective, stream);
        if (lastSpecified == null) {
            EngineNumber currentValue = this.engine.getStream(stream, Optional.of(useKeyEffective), Optional.empty());
            UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
            EngineNumber currentInUnits = unitConverter.convert(currentValue, "units");
            BigDecimal newUnits = currentInUnits.getValue().add(amount.getValue());
            EngineNumber newTotal = new EngineNumber(newUnits, "units");
            StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(newTotal).setYearMatcher(Optional.ofNullable(yearMatcher)).setSubtractRecycling(true).build();
            this.engine.executeStreamUpdate(update);
        } else {
            BigDecimal newTotalValue = lastSpecified.getValue().add(amount.getValue());
            EngineNumber newTotal = new EngineNumber(newTotalValue, lastSpecified.getUnits());
            boolean subtractRecycling = "units".equals(lastSpecified.getUnits());
            StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(newTotal).setYearMatcher(Optional.ofNullable(yearMatcher)).setSubtractRecycling(subtractRecycling).build();
            this.engine.executeStreamUpdate(update);
        }
    }

    private void handleVolumeChange(ChangeExecutorConfig config) {
        String stream = config.getStream();
        EngineNumber amount = config.getAmount();
        YearMatcher yearMatcher = config.getYearMatcher().orElse(null);
        UseKey useKeyEffective = config.getUseKeyEffective();
        EngineNumber currentValue = this.engine.getStream(stream, Optional.of(useKeyEffective), Optional.empty());
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber convertedDelta = unitConverter.convert(amount, "kg");
        BigDecimal newAmount = currentValue.getValue().add(convertedDelta.getValue());
        EngineNumber newTotal = new EngineNumber(newAmount, "kg");
        StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(newTotal).setYearMatcher(Optional.ofNullable(yearMatcher)).inferSubtractRecycling().build();
        this.engine.executeStreamUpdate(update);
    }
}

