/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.ChangeExecutorConfig;

public final class ChangeExecutorConfigBuilder {
    private Optional<String> stream = Optional.empty();
    private Optional<EngineNumber> amount = Optional.empty();
    private Optional<YearMatcher> yearMatcher = Optional.empty();
    private Optional<UseKey> useKeyEffective = Optional.empty();

    public ChangeExecutorConfigBuilder setStream(String stream) {
        this.stream = Optional.of(stream);
        return this;
    }

    public ChangeExecutorConfigBuilder setAmount(EngineNumber amount) {
        this.amount = Optional.of(amount);
        return this;
    }

    public ChangeExecutorConfigBuilder setYearMatcher(YearMatcher yearMatcher) {
        this.yearMatcher = Optional.ofNullable(yearMatcher);
        return this;
    }

    public ChangeExecutorConfigBuilder setUseKeyEffective(UseKey useKeyEffective) {
        this.useKeyEffective = Optional.of(useKeyEffective);
        return this;
    }

    public ChangeExecutorConfig build() {
        if (this.stream.isEmpty()) {
            throw new IllegalStateException("Stream is required");
        }
        if (this.amount.isEmpty()) {
            throw new IllegalStateException("Amount is required");
        }
        if (this.useKeyEffective.isEmpty()) {
            throw new IllegalStateException("UseKeyEffective is required");
        }
        return new ChangeExecutorConfig(this.stream.get(), this.amount.get(), this.yearMatcher, this.useKeyEffective.get());
    }
}

