/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.Scope;

public class ConsumptionCalculator {
    private Optional<EngineNumber> consumptionRaw = Optional.empty();
    private Optional<String> streamName = Optional.empty();

    public void setConsumptionRaw(EngineNumber consumptionRaw) {
        this.consumptionRaw = Optional.ofNullable(consumptionRaw);
    }

    public void setStreamName(String streamName) {
        this.streamName = Optional.ofNullable(streamName);
    }

    public void execute(Engine engine) {
        this.validateState();
        Scope scopeEffective = engine.getScope();
        OverridingConverterStateGetter stateGetter = new OverridingConverterStateGetter(engine.getStateGetter());
        UnitConverter unitConverter = new UnitConverter(stateGetter);
        EngineNumber salesRaw = engine.getStream("sales", Optional.of(scopeEffective), Optional.empty());
        EngineNumber sales = unitConverter.convert(salesRaw, "kg");
        stateGetter.setVolume(sales);
        String targetUnits = this.streamName.get().equals("consumption") ? "tCO2e" : "kwh";
        EngineNumber consumption = unitConverter.convert(this.consumptionRaw.get(), targetUnits);
        stateGetter.clearVolume();
        boolean isNegative = consumption.getValue().compareTo(BigDecimal.ZERO) < 0;
        EngineNumber consumptionAllowed = isNegative ? new EngineNumber(BigDecimal.ZERO, consumption.getUnits()) : consumption;
        StreamUpdate update = new StreamUpdateBuilder().setName(this.streamName.get()).setValue(consumptionAllowed).setKey(scopeEffective).setPropagateChanges(false).build();
        engine.executeStreamUpdate(update);
    }

    private void validateState() {
        if (!this.consumptionRaw.isPresent()) {
            throw new IllegalStateException("consumptionRaw must be set");
        }
        if (!this.streamName.isPresent()) {
            throw new IllegalStateException("streamName must be set");
        }
    }
}

