/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.ExceptionsGenerator;
import org.kigalisim.engine.support.StreamUpdateShortcuts;

public class DisplaceExecutor {
    private final Engine engine;
    private final StreamUpdateShortcuts shortcuts;

    public DisplaceExecutor(Engine engine) {
        this.engine = engine;
        this.shortcuts = new StreamUpdateShortcuts(engine);
    }

    public void execute(String stream, EngineNumber amount, BigDecimal changeAmount, String displaceTarget) {
        if (displaceTarget == null) {
            return;
        }
        if (stream.equals(displaceTarget)) {
            ExceptionsGenerator.raiseSelfDisplacement(stream);
        }
        boolean isStreamDisplacement = EngineSupportUtils.STREAM_NAMES.contains(displaceTarget);
        this.applyRecyclingBeforeDisplacement(stream, changeAmount, isStreamDisplacement);
        if (amount.hasEquipmentUnits()) {
            this.applyUnitsDisplacement(stream, changeAmount, displaceTarget, isStreamDisplacement);
        } else {
            this.applyVolumeDisplacement(stream, changeAmount, displaceTarget, isStreamDisplacement);
        }
    }

    private void applyRecyclingBeforeDisplacement(String stream, BigDecimal changeAmount, boolean isStreamDisplacement) {
        boolean displacementAutomatic;
        boolean bl = displacementAutomatic = isStreamDisplacement && "sales".equals(stream);
        if (displacementAutomatic) {
            EngineNumber recycledAddition = new EngineNumber(changeAmount, "kg");
            this.shortcuts.changeStreamWithoutReportingUnits("sales", recycledAddition, Optional.empty(), Optional.empty());
        }
    }

    private void applyUnitsDisplacement(String stream, BigDecimal changeAmount, String displaceTarget, boolean isStreamDisplacement) {
        UnitConverter currentUnitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber volumeChangeFlip = new EngineNumber(changeAmount.negate(), "kg");
        EngineNumber unitsChanged = currentUnitConverter.convert(volumeChangeFlip, "units");
        if (isStreamDisplacement) {
            this.applyUnitsDisplacementSameSubstance(stream, changeAmount, displaceTarget);
        } else {
            this.applyUnitsDisplacementDifferentSubstance(stream, unitsChanged, displaceTarget);
        }
    }

    private void applyUnitsDisplacementSameSubstance(String stream, BigDecimal changeAmount, String displaceTarget) {
        EngineNumber displaceChange = new EngineNumber(changeAmount.negate(), "kg");
        this.shortcuts.changeStreamWithoutReportingUnits(displaceTarget, displaceChange, Optional.empty(), Optional.empty());
    }

    private void applyUnitsDisplacementDifferentSubstance(String stream, EngineNumber unitsChanged, String displaceTarget) {
        Scope currentScope = this.engine.getScope();
        Scope destinationScope = currentScope.getWithSubstance(displaceTarget);
        String originalSubstance = currentScope.getSubstance();
        this.engine.setSubstance(displaceTarget);
        UnitConverter destinationUnitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber destinationVolumeChange = destinationUnitConverter.convert(unitsChanged, "kg");
        EngineNumber displaceChange = new EngineNumber(destinationVolumeChange.getValue(), "kg");
        this.shortcuts.changeStreamWithDisplacementContext(stream, displaceChange, destinationScope);
        this.engine.setSubstance(originalSubstance);
    }

    private void applyVolumeDisplacement(String stream, BigDecimal changeAmount, String displaceTarget, boolean isStreamDisplacement) {
        EngineNumber displaceChange = new EngineNumber(changeAmount.negate(), "kg");
        if (isStreamDisplacement) {
            this.shortcuts.changeStreamWithoutReportingUnits(displaceTarget, displaceChange, Optional.empty(), Optional.empty());
        } else {
            Scope currentScope = this.engine.getScope();
            Scope destinationScope = currentScope.getWithSubstance(displaceTarget);
            this.shortcuts.changeStreamWithDisplacementContext(stream, displaceChange, destinationScope);
        }
    }
}

