/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.state.ConverterStateGetter;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;

public final class EngineSupportUtils {
    public static final Set<String> STREAM_NAMES = new HashSet<String>();
    public static final String RECYCLE_RECOVER_STREAM = "sales";

    private EngineSupportUtils() {
    }

    public static boolean getIsInRange(YearMatcher yearMatcher, int currentYear) {
        return yearMatcher == null || yearMatcher.getInRange(currentYear);
    }

    public static boolean getIsInRange(Optional<YearMatcher> yearMatcher, int currentYear) {
        return EngineSupportUtils.getIsInRange(yearMatcher.orElse(null), currentYear);
    }

    public static boolean isSalesSubstream(String name) {
        return "domestic".equals(name) || "import".equals(name);
    }

    public static boolean getIsSalesStream(String stream, boolean includeExports) {
        boolean isCoreStream = RECYCLE_RECOVER_STREAM.equals(stream) || EngineSupportUtils.isSalesSubstream(stream);
        return isCoreStream || includeExports && "export".equals(stream);
    }

    public static UnitConverter createUnitConverterWithTotal(ConverterStateGetter stateGetter, String stream, EngineNumber currentValue, EngineNumber initialCharge) {
        OverridingConverterStateGetter overridingStateGetter = new OverridingConverterStateGetter(stateGetter);
        UnitConverter unitConverter = new UnitConverter(overridingStateGetter);
        overridingStateGetter.setTotal(stream, currentValue);
        if (EngineSupportUtils.isSalesSubstream(stream) && initialCharge != null) {
            overridingStateGetter.setAmortizedUnitVolume(initialCharge);
        }
        return unitConverter;
    }

    public static UnitConverter createUnitConverterWithTotal(Engine engine, String stream) {
        EngineNumber currentValue = engine.getStream(stream);
        EngineNumber initialCharge = null;
        if (EngineSupportUtils.isSalesSubstream(stream)) {
            initialCharge = engine.getInitialCharge(stream);
        }
        return EngineSupportUtils.createUnitConverterWithTotal(engine.getStateGetter(), stream, currentValue, initialCharge);
    }

    public static boolean hasUnitBasedSalesSpecifications(SimulationState simulationState, UseKey scope) {
        if (!simulationState.hasLastSpecifiedValue(scope, RECYCLE_RECOVER_STREAM)) {
            return false;
        }
        EngineNumber lastSpecifiedValue = simulationState.getLastSpecifiedValue(scope, RECYCLE_RECOVER_STREAM);
        return lastSpecifiedValue != null && lastSpecifiedValue.hasEquipmentUnits();
    }

    public static BigDecimal ensurePositive(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            System.err.println("WARNING: Negative stream value clamped to zero");
            return BigDecimal.ZERO;
        }
        return value;
    }

    public static BigDecimal getDistributedRecharge(String streamName, EngineNumber totalRecharge, UseKey useKey, SimulationState simulationState) {
        if (RECYCLE_RECOVER_STREAM.equals(streamName)) {
            return totalRecharge.getValue();
        }
        if (EngineSupportUtils.isSalesSubstream(streamName)) {
            SalesStreamDistribution distribution = simulationState.getDistribution(useKey);
            BigDecimal percentage = switch (streamName) {
                case "domestic" -> distribution.getPercentDomestic();
                case "import" -> distribution.getPercentImport();
                default -> throw new IllegalArgumentException("Unknown sales substream: " + streamName);
            };
            return totalRecharge.getValue().multiply(percentage);
        }
        return BigDecimal.ZERO;
    }

    static {
        STREAM_NAMES.add("priorEquipment");
        STREAM_NAMES.add("equipment");
        STREAM_NAMES.add("export");
        STREAM_NAMES.add("import");
        STREAM_NAMES.add("domestic");
        STREAM_NAMES.add(RECYCLE_RECOVER_STREAM);
    }
}

