/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcKitBuilder;
import org.kigalisim.engine.recalc.RecalcOperation;
import org.kigalisim.engine.recalc.RecalcOperationBuilder;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.SetExecutor;

public class EquipmentChangeUtil {
    private final Engine engine;

    public EquipmentChangeUtil(Engine engine) {
        this.engine = engine;
    }

    public void handleSet(EngineNumber targetEquipment) {
        UnitConverter unitConverter = this.createEquipmentUnitConverter();
        EngineNumber targetUnits = unitConverter.convert(targetEquipment, "units");
        EngineNumber priorEquipmentRaw = this.engine.getStream("priorEquipment");
        EngineNumber priorEquipment = unitConverter.convert(priorEquipmentRaw, "units");
        BigDecimal requiredSales = targetUnits.getValue().subtract(priorEquipment.getValue());
        BigDecimal delta = requiredSales;
        if (delta.compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber salesUnits = new EngineNumber(delta, "units");
            this.setSales(salesUnits, Optional.empty());
        } else if (delta.compareTo(BigDecimal.ZERO) < 0) {
            EngineNumber zeroSales = new EngineNumber(BigDecimal.ZERO, "units");
            this.setSales(zeroSales, Optional.empty());
            EngineNumber unitsToRetire = new EngineNumber(delta.abs(), "units");
            this.retireFromPriorEquipment(unitsToRetire, Optional.empty());
        }
    }

    public void handleChange(EngineNumber changeAmount) {
        BigDecimal delta;
        EngineNumber currentEquipmentRaw = this.engine.getStream("equipment");
        UnitConverter unitConverter = this.createEquipmentUnitConverter();
        EngineNumber currentEquipment = unitConverter.convert(currentEquipmentRaw, "units");
        if ("%".equals(changeAmount.getUnits())) {
            delta = this.calculatePercentageChange(currentEquipment, changeAmount);
        } else {
            EngineNumber changeUnits = unitConverter.convert(changeAmount, "units");
            delta = changeUnits.getValue();
        }
        if (delta.compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber deltaUnits = new EngineNumber(delta, "units");
            this.changeSales(deltaUnits, Optional.empty());
        } else if (delta.compareTo(BigDecimal.ZERO) < 0) {
            EngineNumber unitsToRetire = new EngineNumber(delta.abs(), "units");
            this.retireEquipment(unitsToRetire, Optional.empty());
        }
    }

    public void handleCap(EngineNumber capValue, String displaceTarget) {
        EngineNumber currentEquipmentRaw = this.engine.getStream("equipment");
        UnitConverter unitConverter = this.createEquipmentUnitConverter();
        EngineNumber currentEquipment = unitConverter.convert(currentEquipmentRaw, "units");
        EngineNumber capUnits = unitConverter.convert(capValue, "units");
        if (currentEquipment.getValue().compareTo(capUnits.getValue()) > 0) {
            BigDecimal totalReduction = currentEquipment.getValue().subtract(capUnits.getValue());
            EngineNumber totalReductionUnits = new EngineNumber(totalReduction, "units");
            this.retireFromPriorEquipment(totalReductionUnits, Optional.empty());
            EngineNumber priorAfterRetireRaw = this.engine.getStream("priorEquipment");
            EngineNumber priorAfterRetire = unitConverter.convert(priorAfterRetireRaw, "units");
            BigDecimal requiredSales = capUnits.getValue().subtract(priorAfterRetire.getValue());
            EngineNumber salesUnits = new EngineNumber(requiredSales.max(BigDecimal.ZERO), "units");
            this.setSales(salesUnits, Optional.empty());
            if (displaceTarget != null) {
                this.handleDisplacement(totalReductionUnits, displaceTarget, true);
            }
        }
    }

    public void handleFloor(EngineNumber floorValue, String displaceTarget) {
        EngineNumber currentEquipmentRaw = this.engine.getStream("equipment");
        UnitConverter unitConverter = this.createEquipmentUnitConverter();
        EngineNumber currentEquipment = unitConverter.convert(currentEquipmentRaw, "units");
        EngineNumber floorUnits = unitConverter.convert(floorValue, "units");
        if (currentEquipment.getValue().compareTo(floorUnits.getValue()) < 0) {
            BigDecimal deficit = floorUnits.getValue().subtract(currentEquipment.getValue());
            EngineNumber deficitUnits = new EngineNumber(deficit, "units");
            this.changeSales(deficitUnits, Optional.empty());
            if (displaceTarget != null) {
                this.handleDisplacement(deficitUnits, displaceTarget, false);
            }
        }
    }

    private void setSales(EngineNumber salesUnits, Optional<YearMatcher> yearMatcher) {
        Scope scope = this.engine.getScope();
        SimulationState simulationState = this.engine.getStreamKeeper();
        simulationState.setLastSpecifiedValue(scope, "sales", salesUnits);
        SetExecutor setExecutor = new SetExecutor(this.engine);
        setExecutor.handleSalesSet(scope, "sales", salesUnits, yearMatcher);
    }

    private void changeSales(EngineNumber salesDelta, Optional<YearMatcher> yearMatcher) {
        YearMatcher yearMatcherEffective = yearMatcher.orElse(null);
        this.engine.changeStream("sales", salesDelta, yearMatcherEffective);
    }

    private EngineNumber retireFromPriorEquipment(EngineNumber unitsToRetire, Optional<YearMatcher> yearMatcher) {
        Scope scope = this.engine.getScope();
        UnitConverter unitConverter = this.createEquipmentUnitConverter();
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber priorEquipmentRaw = this.engine.getStream("priorEquipment");
        EngineNumber priorEquipment = unitConverter.convert(priorEquipmentRaw, "units");
        BigDecimal actualRetirement = priorEquipment.getValue().min(unitsToRetire.getValue());
        if (actualRetirement.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal retirementPercentage = actualRetirement.divide(priorEquipment.getValue(), MathContext.DECIMAL128).multiply(BigDecimal.valueOf(100L));
            EngineNumber retirementRate = new EngineNumber(retirementPercentage, "%");
            simulationState.setRetirementRate(scope, retirementRate);
            RecalcKit recalcKit = new RecalcKitBuilder().setStreamKeeper(simulationState).setUnitConverter(this.engine.getUnitConverter()).setStateGetter(this.engine.getStateGetter()).build();
            RecalcOperation operation = new RecalcOperationBuilder().setRecalcKit(recalcKit).recalcRetire().thenPropagateToSales().build();
            operation.execute(this.engine);
        }
        return new EngineNumber(actualRetirement, "units");
    }

    private EngineNumber retireEquipment(EngineNumber unitsToRetire, Optional<YearMatcher> yearMatcher) {
        Scope scope = this.engine.getScope();
        UnitConverter unitConverter = this.createEquipmentUnitConverter();
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber priorEquipmentRaw = this.engine.getStream("priorEquipment");
        EngineNumber priorEquipment = unitConverter.convert(priorEquipmentRaw, "units");
        BigDecimal actualRetirement = priorEquipment.getValue().min(unitsToRetire.getValue());
        BigDecimal remainder = unitsToRetire.getValue().subtract(actualRetirement);
        if (remainder.compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber salesDecrease = new EngineNumber(remainder.negate(), "units");
            YearMatcher yearMatcherEffective = yearMatcher.orElse(null);
            this.engine.changeStream("sales", salesDecrease, yearMatcherEffective);
        }
        if (actualRetirement.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal retirementPercentage = actualRetirement.divide(priorEquipment.getValue(), MathContext.DECIMAL128).multiply(BigDecimal.valueOf(100L));
            EngineNumber retirementRate = new EngineNumber(retirementPercentage, "%");
            simulationState.setRetirementRate(scope, retirementRate);
            RecalcKit recalcKit = new RecalcKitBuilder().setStreamKeeper(simulationState).setUnitConverter(this.engine.getUnitConverter()).setStateGetter(this.engine.getStateGetter()).build();
            RecalcOperation operation = new RecalcOperationBuilder().setRecalcKit(recalcKit).recalcRetire().thenPropagateToSales().build();
            operation.execute(this.engine);
        }
        return new EngineNumber(actualRetirement, "units");
    }

    private BigDecimal calculatePercentageChange(EngineNumber currentValue, EngineNumber percentChange) {
        return currentValue.getValue().multiply(percentChange.getValue()).divide(BigDecimal.valueOf(100L), MathContext.DECIMAL128);
    }

    private UnitConverter createEquipmentUnitConverter() {
        return EngineSupportUtils.createUnitConverterWithTotal(this.engine, "equipment");
    }

    private void handleDisplacement(EngineNumber amount, String displaceTarget, boolean isCap) {
        if (displaceTarget == null) {
            return;
        }
        if (amount.getValue().abs().compareTo(new BigDecimal("1E-10")) < 0) {
            return;
        }
        Scope currentScope = this.engine.getScope();
        this.engine.setSubstance(displaceTarget, true);
        EngineNumber changeAmount = isCap ? amount : new EngineNumber(amount.getValue().negate(), "units");
        EngineNumber targetCurrentRaw = this.engine.getStream("equipment");
        UnitConverter targetConverter = this.createEquipmentUnitConverter();
        EngineNumber targetCurrent = targetConverter.convert(targetCurrentRaw, "units");
        BigDecimal newTargetLevel = targetCurrent.getValue().add(changeAmount.getValue());
        EngineNumber newTarget = new EngineNumber(newTargetLevel, "units");
        this.handleSet(newTarget);
        String originalSubstance = currentScope.getSubstance();
        if (originalSubstance != null) {
            this.engine.setSubstance(originalSubstance, true);
        }
    }
}

