/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.DisplaceExecutor;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.StreamUpdateShortcuts;

public class LimitExecutor {
    private final Engine engine;
    private final StreamUpdateShortcuts shortcuts;
    private final DisplaceExecutor displaceExecutor;

    public LimitExecutor(Engine engine) {
        this.engine = engine;
        this.shortcuts = new StreamUpdateShortcuts(engine);
        this.displaceExecutor = new DisplaceExecutor(engine);
    }

    private void checkIsNotEquipment(String stream) {
        if ("equipment".equals(stream)) {
            throw new IllegalStateException("Equipment stream operations should be handled by EquipmentChangeUtil");
        }
    }

    public void executeCap(String stream, EngineNumber amount, YearMatcher yearMatcher, String displaceTarget) {
        if (!EngineSupportUtils.getIsInRange(yearMatcher, this.engine.getYear())) {
            return;
        }
        this.checkIsNotEquipment(stream);
        if ("%".equals(amount.getUnits())) {
            this.capWithPercent(stream, amount, displaceTarget);
        } else {
            this.capWithValue(stream, amount, displaceTarget);
        }
    }

    public void executeFloor(String stream, EngineNumber amount, YearMatcher yearMatcher, String displaceTarget) {
        if (!EngineSupportUtils.getIsInRange(yearMatcher, this.engine.getYear())) {
            return;
        }
        this.checkIsNotEquipment(stream);
        if ("%".equals(amount.getUnits())) {
            this.floorWithPercent(stream, amount, displaceTarget);
        } else {
            this.floorWithValue(stream, amount, displaceTarget);
        }
    }

    private void capWithPercent(String stream, EngineNumber amount, String displaceTarget) {
        boolean hasPrior;
        Scope scope;
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber currentValueRaw = this.engine.getStream(stream);
        EngineNumber currentValue = unitConverter.convert(currentValueRaw, "kg");
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber lastSpecified = simulationState.getLastSpecifiedValue(scope = this.engine.getScope(), stream);
        boolean bl = hasPrior = lastSpecified != null;
        if (hasPrior) {
            boolean capSatisfied;
            BigDecimal capValue = lastSpecified.getValue().multiply(amount.getValue()).divide(new BigDecimal("100"));
            EngineNumber newCappedValue = new EngineNumber(capValue, lastSpecified.getUnits());
            EngineNumber currentInKg = unitConverter.convert(currentValueRaw, "kg");
            EngineNumber newCappedInKg = unitConverter.convert(newCappedValue, "kg");
            boolean bl2 = capSatisfied = currentInKg.getValue().compareTo(newCappedInKg.getValue()) <= 0;
            if (capSatisfied) {
                return;
            }
            StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(newCappedValue).setYearMatcher(Optional.empty()).inferSubtractRecycling().build();
            this.engine.executeStreamUpdate(update);
            if (displaceTarget != null) {
                EngineNumber finalInKg = this.engine.getStream(stream);
                BigDecimal changeInKg = finalInKg.getValue().subtract(currentInKg.getValue());
                this.displaceExecutor.execute(stream, amount, changeInKg, displaceTarget);
            }
        } else {
            boolean capSatisfied;
            EngineNumber convertedMax = unitConverter.convert(amount, "kg");
            BigDecimal changeAmountRaw = convertedMax.getValue().subtract(currentValue.getValue());
            BigDecimal changeAmount = changeAmountRaw.min(BigDecimal.ZERO);
            boolean bl3 = capSatisfied = changeAmount.compareTo(BigDecimal.ZERO) >= 0;
            if (capSatisfied) {
                return;
            }
            EngineNumber changeWithUnits = new EngineNumber(changeAmount, "kg");
            this.shortcuts.changeStreamWithoutReportingUnits(stream, changeWithUnits, Optional.empty(), Optional.empty());
            this.displaceExecutor.execute(stream, amount, changeAmount, displaceTarget);
        }
    }

    private void capWithValue(String stream, EngineNumber amount, String displaceTarget) {
        boolean capSatisfied;
        EngineNumber currentValueRaw;
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber currentValueInAmountUnits = unitConverter.convert(currentValueRaw = this.engine.getStream(stream), amount.getUnits());
        boolean bl = capSatisfied = currentValueInAmountUnits.getValue().compareTo(amount.getValue()) <= 0;
        if (capSatisfied) {
            return;
        }
        EngineNumber currentInKg = unitConverter.convert(currentValueRaw, "kg");
        StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(amount).setYearMatcher(Optional.empty()).inferSubtractRecycling().build();
        this.engine.executeStreamUpdate(update);
        if (displaceTarget != null) {
            EngineNumber cappedInKg = this.engine.getStream(stream);
            BigDecimal changeInKg = cappedInKg.getValue().subtract(currentInKg.getValue());
            this.displaceExecutor.execute(stream, amount, changeInKg, displaceTarget);
        }
    }

    private void floorWithPercent(String stream, EngineNumber amount, String displaceTarget) {
        boolean hasPrior;
        Scope scope;
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber currentValueRaw = this.engine.getStream(stream);
        EngineNumber currentValue = unitConverter.convert(currentValueRaw, "kg");
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber lastSpecified = simulationState.getLastSpecifiedValue(scope = this.engine.getScope(), stream);
        boolean bl = hasPrior = lastSpecified != null;
        if (hasPrior) {
            boolean floorSatisfied;
            BigDecimal floorValue = lastSpecified.getValue().multiply(amount.getValue()).divide(new BigDecimal("100"));
            EngineNumber newFloorValue = new EngineNumber(floorValue, lastSpecified.getUnits());
            EngineNumber currentInKg = unitConverter.convert(currentValueRaw, "kg");
            EngineNumber newFloorInKg = unitConverter.convert(newFloorValue, "kg");
            boolean bl2 = floorSatisfied = currentInKg.getValue().compareTo(newFloorInKg.getValue()) >= 0;
            if (floorSatisfied) {
                return;
            }
            StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(newFloorValue).setYearMatcher(Optional.empty()).inferSubtractRecycling().build();
            this.engine.executeStreamUpdate(update);
            if (displaceTarget != null) {
                EngineNumber finalInKg = this.engine.getStream(stream);
                BigDecimal changeInKg = finalInKg.getValue().subtract(currentInKg.getValue());
                this.displaceExecutor.execute(stream, amount, changeInKg, displaceTarget);
            }
        } else {
            boolean floorSatisfied;
            EngineNumber convertedMin = unitConverter.convert(amount, "kg");
            BigDecimal changeAmountRaw = convertedMin.getValue().subtract(currentValue.getValue());
            BigDecimal changeAmount = changeAmountRaw.max(BigDecimal.ZERO);
            boolean bl3 = floorSatisfied = changeAmount.compareTo(BigDecimal.ZERO) <= 0;
            if (floorSatisfied) {
                return;
            }
            EngineNumber changeWithUnits = new EngineNumber(changeAmount, "kg");
            this.shortcuts.changeStreamWithoutReportingUnits(stream, changeWithUnits, Optional.empty(), Optional.empty());
            this.displaceExecutor.execute(stream, amount, changeAmount, displaceTarget);
        }
    }

    private void floorWithValue(String stream, EngineNumber amount, String displaceTarget) {
        boolean floorSatisfied;
        EngineNumber currentValueRaw;
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber currentValueInAmountUnits = unitConverter.convert(currentValueRaw = this.engine.getStream(stream), amount.getUnits());
        boolean bl = floorSatisfied = currentValueInAmountUnits.getValue().compareTo(amount.getValue()) >= 0;
        if (floorSatisfied) {
            return;
        }
        EngineNumber currentInKg = unitConverter.convert(currentValueRaw, "kg");
        StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(amount).setYearMatcher(Optional.empty()).inferSubtractRecycling().build();
        this.engine.executeStreamUpdate(update);
        if (displaceTarget != null) {
            EngineNumber newInKg = this.engine.getStream(stream);
            BigDecimal changeInKg = newInKg.getValue().subtract(currentInKg.getValue());
            this.displaceExecutor.execute(stream, amount, changeInKg, displaceTarget);
        }
    }
}

