/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.StateGetter;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.support.ExceptionsGenerator;

public class RechargeVolumeCalculator {
    public static EngineNumber calculateRechargeVolume(UseKey scope, StateGetter stateGetter, SimulationState simulationState, Engine engine) {
        OverridingConverterStateGetter overridingStateGetter = new OverridingConverterStateGetter(stateGetter);
        UnitConverter unitConverter = new UnitConverter(overridingStateGetter);
        Optional<String> application = Optional.ofNullable(scope.getApplication());
        Optional<String> substance = Optional.ofNullable(scope.getSubstance());
        if (!application.isPresent() || !substance.isPresent()) {
            ExceptionsGenerator.raiseNoAppOrSubstance("calculating recharge volume", "");
        }
        EngineNumber priorPopulationRaw = engine.getStream("priorEquipment");
        EngineNumber priorPopulation = unitConverter.convert(priorPopulationRaw, "units");
        overridingStateGetter.setPopulation(engine.getStream("priorEquipment"));
        EngineNumber rechargePopRaw = simulationState.getRechargePopulation(scope);
        EngineNumber rechargePop = unitConverter.convert(rechargePopRaw, "units");
        overridingStateGetter.clearPopulation();
        overridingStateGetter.setPopulation(rechargePop);
        EngineNumber rechargeIntensityRaw = simulationState.getRechargeIntensity(scope);
        EngineNumber rechargeVolume = unitConverter.convert(rechargeIntensityRaw, "kg");
        overridingStateGetter.setPopulation(priorPopulation);
        return rechargeVolume;
    }
}

