/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.state.ConverterStateGetter;
import org.kigalisim.engine.state.OverridingConverterStateGetter;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimpleUseKey;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.ExceptionsGenerator;
import org.kigalisim.engine.support.StreamUpdateShortcuts;

public class ReplaceExecutor {
    private final Engine engine;
    private final StreamUpdateShortcuts shortcuts;

    public ReplaceExecutor(Engine engine) {
        this.engine = engine;
        this.shortcuts = new StreamUpdateShortcuts(engine);
    }

    public void execute(EngineNumber amountRaw, String stream, String destinationSubstance, YearMatcher yearMatcher) {
        boolean isInRange = EngineSupportUtils.getIsInRange(yearMatcher, this.engine.getStreamKeeper().getCurrentYear());
        if (!isInRange) {
            return;
        }
        Scope currentScope = this.engine.getScope();
        String application = currentScope.getApplication();
        String currentSubstance = currentScope.getSubstance();
        if (application == null || currentSubstance == null) {
            ExceptionsGenerator.raiseNoAppOrSubstance("setting stream", " specified");
        }
        if (currentSubstance.equals(destinationSubstance)) {
            ExceptionsGenerator.raiseSelfReplacement(currentSubstance);
        }
        this.updateLastSpecified(currentScope, application, destinationSubstance, stream, amountRaw);
        EngineNumber effectiveAmount = this.getEffectiveAmount(currentScope, stream, amountRaw);
        if (effectiveAmount.hasEquipmentUnits()) {
            this.applyReplaceWithUnits(currentScope, stream, destinationSubstance, effectiveAmount);
        } else {
            this.applyReplaceWithVolume(currentScope, stream, destinationSubstance, effectiveAmount);
        }
    }

    private void updateLastSpecified(Scope currentScope, String application, String destinationSubstance, String stream, EngineNumber amountRaw) {
        boolean isSalesStream = EngineSupportUtils.getIsSalesStream(stream, true);
        if (!isSalesStream) {
            return;
        }
        SimulationState simulationState = this.engine.getStreamKeeper();
        simulationState.setLastSpecifiedValue(currentScope, stream, amountRaw);
        SimpleUseKey destKey = new SimpleUseKey(application, destinationSubstance);
        simulationState.setLastSpecifiedValue(destKey, stream, amountRaw);
    }

    private EngineNumber getEffectiveAmount(Scope scope, String stream, EngineNumber amountRaw) {
        boolean hasPrior;
        boolean isPercent = amountRaw.getUnits().equals("%");
        if (!isPercent) {
            return amountRaw;
        }
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber lastSpecified = simulationState.getLastSpecifiedValue(scope, stream);
        boolean bl = hasPrior = lastSpecified != null;
        if (hasPrior) {
            BigDecimal percentageValue = lastSpecified.getValue().multiply(amountRaw.getValue()).divide(new BigDecimal("100"));
            return new EngineNumber(percentageValue, lastSpecified.getUnits());
        }
        EngineNumber currentValue = this.engine.getStream(stream);
        BigDecimal percentageValue = currentValue.getValue().multiply(amountRaw.getValue()).divide(new BigDecimal("100"));
        return new EngineNumber(percentageValue, currentValue.getUnits());
    }

    private void applyReplaceWithUnits(Scope currentScope, String stream, String destinationSubstance, EngineNumber effectiveAmount) {
        UnitConverter sourceUnitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber unitsToReplace = sourceUnitConverter.convert(effectiveAmount, "units");
        EngineNumber sourceVolumeChange = sourceUnitConverter.convert(unitsToReplace, "kg");
        EngineNumber sourceAmountNegative = new EngineNumber(sourceVolumeChange.getValue().negate(), sourceVolumeChange.getUnits());
        this.shortcuts.changeStreamWithoutReportingUnits(stream, sourceAmountNegative, Optional.empty(), Optional.empty());
        Scope destinationScope = currentScope.getWithSubstance(destinationSubstance);
        Scope originalScope = this.engine.getScope();
        this.engine.setStanza(destinationScope.getStanza());
        this.engine.setApplication(destinationScope.getApplication());
        this.engine.setSubstance(destinationScope.getSubstance());
        EngineNumber destinationInitialCharge = this.engine.getInitialCharge("sales");
        this.engine.setStanza(originalScope.getStanza());
        this.engine.setApplication(originalScope.getApplication());
        this.engine.setSubstance(originalScope.getSubstance());
        ConverterStateGetter baseStateGetter = this.engine.getStateGetter();
        OverridingConverterStateGetter destinationStateGetter = new OverridingConverterStateGetter(baseStateGetter);
        destinationStateGetter.setAmortizedUnitVolume(destinationInitialCharge);
        UnitConverter destinationUnitConverter = new UnitConverter(destinationStateGetter);
        EngineNumber destinationVolumeChange = destinationUnitConverter.convert(unitsToReplace, "kg");
        this.shortcuts.changeStreamWithDisplacementContext(stream, destinationVolumeChange, destinationScope);
    }

    private void applyReplaceWithVolume(Scope currentScope, String stream, String destinationSubstance, EngineNumber effectiveAmount) {
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber amount = unitConverter.convert(effectiveAmount, "kg");
        EngineNumber amountNegative = new EngineNumber(amount.getValue().negate(), amount.getUnits());
        this.shortcuts.changeStreamWithoutReportingUnits(stream, amountNegative, Optional.empty(), Optional.empty());
        Scope destinationScope = currentScope.getWithSubstance(destinationSubstance);
        this.shortcuts.changeStreamWithDisplacementContext(stream, amount, destinationScope);
    }
}

