/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.recalc.SalesStreamDistribution;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;

public class SetExecutor {
    private final Engine engine;

    public SetExecutor(Engine engine) {
        this.engine = engine;
    }

    public void handleSalesSet(UseKey useKey, String stream, EngineNumber value, Optional<YearMatcher> yearMatcher) {
        StreamUpdate update;
        boolean inRange;
        boolean hasYearMatch = yearMatcher.isPresent();
        boolean bl = inRange = hasYearMatch && !EngineSupportUtils.getIsInRange(yearMatcher.get(), this.engine.getYear());
        if (inRange) {
            return;
        }
        SimulationState simulationState = this.engine.getStreamKeeper();
        simulationState.setLastSpecifiedValue(useKey, "sales", value);
        SalesStreamDistribution distribution = simulationState.getDistribution(useKey);
        BigDecimal domesticAmount = value.getValue().multiply(distribution.getPercentDomestic());
        BigDecimal importAmount = value.getValue().multiply(distribution.getPercentImport());
        if (distribution.getPercentDomestic().compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber domesticValue = new EngineNumber(domesticAmount, value.getUnits());
            update = new StreamUpdateBuilder().setName("domestic").setValue(domesticValue).setYearMatcher(yearMatcher).inferSubtractRecycling().build();
            this.engine.executeStreamUpdate(update);
        }
        if (distribution.getPercentImport().compareTo(BigDecimal.ZERO) > 0) {
            EngineNumber importValue = new EngineNumber(importAmount, value.getUnits());
            update = new StreamUpdateBuilder().setName("import").setValue(importValue).setYearMatcher(yearMatcher).inferSubtractRecycling().build();
            this.engine.executeStreamUpdate(update);
        }
    }
}

