/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcOperation;
import org.kigalisim.engine.recalc.RecalcOperationBuilder;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.SimulationStateUpdate;
import org.kigalisim.engine.state.SimulationStateUpdateBuilder;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.engine.support.ImplicitRechargeUpdate;
import org.kigalisim.engine.support.RechargeVolumeCalculator;

public class StreamUpdateExecutor {
    private final Engine engine;

    public StreamUpdateExecutor(Engine engine) {
        this.engine = engine;
    }

    public void execute(StreamUpdate update) {
        String name = update.getName();
        EngineNumber value = update.getValue();
        Optional<YearMatcher> yearMatcher = update.getYearMatcher();
        Optional<UseKey> key = update.getKey();
        boolean propagateChanges = update.getPropagateChanges();
        boolean subtractRecycling = update.getSubtractRecycling();
        boolean isInRange = EngineSupportUtils.getIsInRange(yearMatcher.orElse(null), this.engine.getStreamKeeper().getCurrentYear());
        if (!isInRange) {
            return;
        }
        UseKey keyEffective = key.orElse(this.engine.getScope());
        boolean isSales = EngineSupportUtils.getIsSalesStream(name, true);
        boolean isUnits = value.hasEquipmentUnits();
        boolean isSalesSubstream = EngineSupportUtils.isSalesSubstream(name);
        ImplicitRechargeUpdate rechargeUpdate = this.handleImplicitRecharge(keyEffective, name, value, isSales, isUnits, isSalesSubstream);
        EngineNumber valueToSet = rechargeUpdate.getValueToSet();
        rechargeUpdate.getImplicitRechargeStateUpdate().ifPresent(this.engine.getStreamKeeper()::update);
        SimulationStateUpdate simulationStateUpdate = new SimulationStateUpdateBuilder().setUseKey(keyEffective).setName(name).setValue(valueToSet).setSubtractRecycling(subtractRecycling).setDistribution(update.getDistribution().orElse(null)).build();
        this.engine.getStreamKeeper().update(simulationStateUpdate);
        if (!propagateChanges) {
            return;
        }
        if (isSales) {
            this.engine.getStreamKeeper().setLastSpecifiedValue(keyEffective, name, value);
            this.updateUnitsTarget(keyEffective, name, value);
        }
        this.propagateChanges(keyEffective, name, isSales, isUnits);
    }

    private EngineNumber getOtherValue(UseKey useKey, String streamName) {
        String otherStream = "domestic".equals(streamName) ? "import" : "domestic";
        return this.engine.getStreamKeeper().getLastSpecifiedValue(useKey, otherStream);
    }

    private void updateUnitsTarget(UseKey useKey, String streamName, EngineNumber value) {
        boolean otherHasUnitsTarget;
        boolean hasUnitsTarget;
        boolean hasEquipmentUnitsTarget = value.hasEquipmentUnits();
        boolean userSetSales = EngineSupportUtils.isSalesSubstream(streamName);
        boolean bl = hasUnitsTarget = hasEquipmentUnitsTarget && userSetSales;
        if (!hasUnitsTarget) {
            return;
        }
        SimulationState simulationState = this.engine.getStreamKeeper();
        EngineNumber otherValue = this.getOtherValue(useKey, streamName);
        boolean otherGiven = otherValue != null;
        boolean bl2 = otherHasUnitsTarget = otherGiven && otherValue.hasEquipmentUnits();
        if (otherHasUnitsTarget) {
            String targetUnits = value.getUnits();
            UnitConverter converter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, streamName);
            EngineNumber otherConverted = converter.convert(otherValue, targetUnits);
            BigDecimal combinedValue = value.getValue().add(otherConverted.getValue());
            EngineNumber salesIntent = new EngineNumber(combinedValue, targetUnits);
            simulationState.setLastSpecifiedValue(useKey, "sales", salesIntent);
        } else {
            simulationState.setLastSpecifiedValue(useKey, "sales", value);
        }
    }

    public ImplicitRechargeUpdate handleImplicitRecharge(UseKey useKey, String streamName, EngineNumber value, boolean isSales, boolean isUnits, boolean isSalesSubstream) {
        boolean isSalesWithUnitsTarget;
        boolean bl = isSalesWithUnitsTarget = isSales && isUnits;
        if (isSalesWithUnitsTarget) {
            return this.updateAndApplyImplicitRecharge(useKey, streamName, value, isSalesSubstream);
        }
        return this.clearImplicitRecharge(useKey, isSales, value);
    }

    private ImplicitRechargeUpdate updateAndApplyImplicitRecharge(UseKey useKey, String streamName, EngineNumber value, boolean isSalesSubstream) {
        SimulationState simulationState = this.engine.getStreamKeeper();
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, streamName);
        EngineNumber valueInKg = unitConverter.convert(value, "kg");
        EngineNumber rechargeVolume = RechargeVolumeCalculator.calculateRechargeVolume(useKey, this.engine.getStateGetter(), simulationState, this.engine);
        SimulationStateUpdate implicitRechargeStream = new SimulationStateUpdateBuilder().setUseKey(useKey).setName("implicitRecharge").setValue(rechargeVolume).setSubtractRecycling(false).build();
        BigDecimal rechargeToAdd = isSalesSubstream ? EngineSupportUtils.getDistributedRecharge(streamName, rechargeVolume, useKey, this.engine.getStreamKeeper()) : rechargeVolume.getValue();
        BigDecimal totalWithRecharge = valueInKg.getValue().add(rechargeToAdd);
        EngineNumber valueToSet = new EngineNumber(totalWithRecharge, "kg");
        return new ImplicitRechargeUpdate(valueToSet, Optional.of(implicitRechargeStream));
    }

    private ImplicitRechargeUpdate clearImplicitRecharge(UseKey useKey, boolean isSales, EngineNumber value) {
        if (isSales) {
            SimulationStateUpdate clearImplicitRechargeStream = new SimulationStateUpdateBuilder().setUseKey(useKey).setName("implicitRecharge").setValue(new EngineNumber(BigDecimal.ZERO, "kg")).setSubtractRecycling(false).build();
            return new ImplicitRechargeUpdate(value, Optional.of(clearImplicitRechargeStream));
        }
        return new ImplicitRechargeUpdate(value, Optional.empty());
    }

    public void propagateChanges(UseKey useKey, String streamName, boolean isSales, boolean isUnits) {
        if (EngineSupportUtils.getIsSalesStream(streamName, false)) {
            boolean useImplicitRecharge = isSales && isUnits;
            this.propagateChangesFromSales(useKey, useImplicitRecharge);
            return;
        }
        switch (streamName) {
            case "consumption": {
                this.propagateChangesFromConsumption(useKey);
                break;
            }
            case "equipment": {
                this.propagateChangesFromEquipment(useKey);
                break;
            }
            case "priorEquipment": {
                this.propagateChangesFromPriorEquipment(useKey);
                break;
            }
        }
    }

    private void propagateChangesFromSales(UseKey useKey, boolean useImplicitRecharge) {
        RecalcKit recalcKit = this.createRecalcKit();
        RecalcOperationBuilder builder = new RecalcOperationBuilder().setScopeEffective(useKey).setUseExplicitRecharge(!useImplicitRecharge).setRecalcKit(recalcKit).recalcPopulationChange().thenPropagateToConsumption();
        if (!this.engine.getOptimizeRecalcs()) {
            builder = builder.thenPropagateToSales();
        }
        RecalcOperation operation = builder.build();
        operation.execute(this.engine);
    }

    private void propagateChangesFromConsumption(UseKey useKey) {
        RecalcKit recalcKit = this.createRecalcKit();
        RecalcOperationBuilder builder = new RecalcOperationBuilder().setScopeEffective(useKey).setRecalcKit(recalcKit).recalcSales().thenPropagateToPopulationChange();
        if (!this.engine.getOptimizeRecalcs()) {
            builder = builder.thenPropagateToConsumption();
        }
        RecalcOperation operation = builder.build();
        operation.execute(this.engine);
    }

    private void propagateChangesFromEquipment(UseKey useKey) {
        RecalcKit recalcKit = this.createRecalcKit();
        RecalcOperationBuilder builder = new RecalcOperationBuilder().setScopeEffective(useKey).setRecalcKit(recalcKit).recalcSales().thenPropagateToConsumption();
        if (!this.engine.getOptimizeRecalcs()) {
            builder = builder.thenPropagateToPopulationChange();
        }
        RecalcOperation operation = builder.build();
        operation.execute(this.engine);
    }

    private void propagateChangesFromPriorEquipment(UseKey useKey) {
        RecalcKit recalcKit = this.createRecalcKit();
        RecalcOperation operation = new RecalcOperationBuilder().setScopeEffective(useKey).setRecalcKit(recalcKit).recalcRetire().build();
        operation.execute(this.engine);
    }

    private RecalcKit createRecalcKit() {
        return new RecalcKit(this.engine.getStreamKeeper(), this.engine.getUnitConverter(), this.engine.getStateGetter());
    }
}

