/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.engine.support;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.recalc.RecalcKit;
import org.kigalisim.engine.recalc.RecalcKitBuilder;
import org.kigalisim.engine.recalc.RecalcOperation;
import org.kigalisim.engine.recalc.RecalcOperationBuilder;
import org.kigalisim.engine.recalc.StreamUpdate;
import org.kigalisim.engine.recalc.StreamUpdateBuilder;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimpleUseKey;
import org.kigalisim.engine.state.UseKey;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;

public class StreamUpdateShortcuts {
    private static final boolean OPTIMIZE_RECALCS = true;
    private final Engine engine;

    public StreamUpdateShortcuts(Engine engine) {
        this.engine = engine;
    }

    public void changeStreamWithoutReportingUnits(String stream, EngineNumber amount, Optional<YearMatcher> yearMatcher, Optional<UseKey> scope) {
        this.changeStreamWithoutReportingUnits(stream, amount, yearMatcher, scope, false);
    }

    public void changeStreamWithoutReportingUnits(String stream, EngineNumber amount, Optional<YearMatcher> yearMatcher, Optional<UseKey> scope, boolean negativeAllowed) {
        boolean isInRange = EngineSupportUtils.getIsInRange(yearMatcher, this.engine.getYear());
        if (!isInRange) {
            return;
        }
        EngineNumber currentValue = this.engine.getStream(stream, scope, Optional.empty());
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber convertedDelta = unitConverter.convert(amount, currentValue.getUnits());
        BigDecimal newAmount = currentValue.getValue().add(convertedDelta.getValue());
        BigDecimal newAmountBound = negativeAllowed ? newAmount : EngineSupportUtils.ensurePositive(newAmount);
        EngineNumber outputWithUnits = new EngineNumber(newAmountBound, currentValue.getUnits());
        StreamUpdateBuilder builder = new StreamUpdateBuilder().setName(stream).setValue(outputWithUnits).setSubtractRecycling(false);
        if (scope.isPresent()) {
            builder.setKey(scope.get());
        }
        StreamUpdate update = builder.build();
        this.engine.executeStreamUpdate(update);
    }

    public void changeStreamWithDisplacementContext(String stream, EngineNumber amount, Scope destinationScope) {
        this.changeStreamWithDisplacementContext(stream, amount, destinationScope, false);
    }

    public void changeStreamWithDisplacementContext(String stream, EngineNumber amount, Scope destinationScope, boolean negativeAllowed) {
        Scope originalScope = this.engine.getScope();
        this.engine.setStanza(destinationScope.getStanza());
        this.engine.setApplication(destinationScope.getApplication());
        this.engine.setSubstance(destinationScope.getSubstance());
        EngineNumber outputWithUnits = this.applyDelta(stream, amount, negativeAllowed);
        StreamUpdate update = new StreamUpdateBuilder().setName(stream).setValue(outputWithUnits).setPropagateChanges(false).setSubtractRecycling(false).build();
        this.engine.executeStreamUpdate(update);
        this.forceSetLastSpecifiedValue(stream, outputWithUnits, destinationScope);
        if (!EngineSupportUtils.getIsSalesStream(stream, false)) {
            this.engine.setStanza(originalScope.getStanza());
            this.engine.setApplication(originalScope.getApplication());
            this.engine.setSubstance(originalScope.getSubstance());
            return;
        }
        boolean useImplicitRecharge = false;
        RecalcOperationBuilder builder = new RecalcOperationBuilder().setRecalcKit(this.createRecalcKit()).setUseExplicitRecharge(!useImplicitRecharge).recalcPopulationChange().thenPropagateToConsumption();
        if (!this.engine.getOptimizeRecalcs()) {
            builder = builder.thenPropagateToSales();
        }
        RecalcOperation operation = builder.build();
        operation.execute(this.engine);
        this.engine.setStanza(originalScope.getStanza());
        this.engine.setApplication(originalScope.getApplication());
        this.engine.setSubstance(originalScope.getSubstance());
    }

    private EngineNumber applyDelta(String stream, EngineNumber amount, boolean negativeAllowed) {
        EngineNumber currentValue = this.engine.getStream(stream);
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(this.engine, stream);
        EngineNumber convertedDelta = unitConverter.convert(amount, currentValue.getUnits());
        BigDecimal newAmount = currentValue.getValue().add(convertedDelta.getValue());
        BigDecimal newAmountBound = negativeAllowed ? newAmount : EngineSupportUtils.ensurePositive(newAmount);
        return new EngineNumber(newAmountBound, currentValue.getUnits());
    }

    private void forceSetLastSpecifiedValue(String stream, EngineNumber value, Scope destinationScope) {
        if (EngineSupportUtils.getIsSalesStream(stream, false)) {
            SimpleUseKey destKey = new SimpleUseKey(destinationScope.getApplication(), destinationScope.getSubstance());
            this.engine.getStreamKeeper().setLastSpecifiedValue(destKey, stream, value);
        }
    }

    private RecalcKit createRecalcKit() {
        return new RecalcKitBuilder().setStreamKeeper(this.engine.getStreamKeeper()).setUnitConverter(this.engine.getUnitConverter()).setStateGetter(this.engine.getStateGetter()).build();
    }
}

