/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.lang.QubecTalkBaseVisitor;
import org.kigalisim.lang.QubecTalkParser;
import org.kigalisim.lang.fragment.AboutStanzaFragment;
import org.kigalisim.lang.fragment.ApplicationFragment;
import org.kigalisim.lang.fragment.DuringFragment;
import org.kigalisim.lang.fragment.Fragment;
import org.kigalisim.lang.fragment.OperationFragment;
import org.kigalisim.lang.fragment.PolicyFragment;
import org.kigalisim.lang.fragment.ProgramFragment;
import org.kigalisim.lang.fragment.ScenarioFragment;
import org.kigalisim.lang.fragment.ScenariosFragment;
import org.kigalisim.lang.fragment.StringFragment;
import org.kigalisim.lang.fragment.SubstanceFragment;
import org.kigalisim.lang.fragment.UnitFragment;
import org.kigalisim.lang.localization.FlexibleNumberParseResult;
import org.kigalisim.lang.localization.NumberParseUtil;
import org.kigalisim.lang.operation.AdditionOperation;
import org.kigalisim.lang.operation.CapOperation;
import org.kigalisim.lang.operation.ChangeOperation;
import org.kigalisim.lang.operation.ChangeUnitsOperation;
import org.kigalisim.lang.operation.ConditionalOperation;
import org.kigalisim.lang.operation.DefineVariableOperation;
import org.kigalisim.lang.operation.DivisionOperation;
import org.kigalisim.lang.operation.DrawNormalOperation;
import org.kigalisim.lang.operation.DrawUniformOperation;
import org.kigalisim.lang.operation.EnableOperation;
import org.kigalisim.lang.operation.EqualityOperation;
import org.kigalisim.lang.operation.EqualsOperation;
import org.kigalisim.lang.operation.FloorOperation;
import org.kigalisim.lang.operation.GetStreamOperation;
import org.kigalisim.lang.operation.GetVariableOperation;
import org.kigalisim.lang.operation.InitialChargeOperation;
import org.kigalisim.lang.operation.LogicalOperation;
import org.kigalisim.lang.operation.MultiplicationOperation;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.operation.PowerOperation;
import org.kigalisim.lang.operation.PreCalculatedOperation;
import org.kigalisim.lang.operation.RechargeOperation;
import org.kigalisim.lang.operation.RecoverOperation;
import org.kigalisim.lang.operation.ReplaceOperation;
import org.kigalisim.lang.operation.RetireOperation;
import org.kigalisim.lang.operation.RetireWithReplacementOperation;
import org.kigalisim.lang.operation.SetOperation;
import org.kigalisim.lang.operation.SubtractionOperation;
import org.kigalisim.lang.program.ParsedApplication;
import org.kigalisim.lang.program.ParsedPolicy;
import org.kigalisim.lang.program.ParsedProgram;
import org.kigalisim.lang.program.ParsedScenario;
import org.kigalisim.lang.program.ParsedScenarios;
import org.kigalisim.lang.program.ParsedSubstance;
import org.kigalisim.lang.time.CalculatedTimePointFuture;
import org.kigalisim.lang.time.DynamicCapFuture;
import org.kigalisim.lang.time.ParsedDuring;

public class QubecTalkEngineVisitor
extends QubecTalkBaseVisitor<Fragment> {
    private final NumberParseUtil numberParser = new NumberParseUtil();
    private static final String BEGINNING = "beginning";
    private static final String ONWARDS = "onwards";
    private static final int SUBSTANCE_BODY_START = 3;
    private static final int SUBSTANCE_BODY_END = 2;

    @Override
    public Fragment visitNumber(QubecTalkParser.NumberContext ctx) {
        String rawText = ctx.getText();
        FlexibleNumberParseResult parseResult = this.numberParser.parseFlexibleNumber(rawText);
        if (parseResult.isError()) {
            throw new RuntimeException("Failed to parse number in QubecTalk expression: " + parseResult.getError().get());
        }
        BigDecimal numberRaw = parseResult.getParsedNumber().get();
        EngineNumber number = new EngineNumber(numberRaw, "");
        PreCalculatedOperation calculation = new PreCalculatedOperation(number);
        return new OperationFragment(calculation);
    }

    @Override
    public Fragment visitString(QubecTalkParser.StringContext ctx) {
        String text = ctx.getText().replaceAll("\"", "");
        return new StringFragment(text);
    }

    @Override
    public Fragment visitUnitValue(QubecTalkParser.UnitValueContext ctx) {
        Operation futureCalculation = ((Fragment)this.visit(ctx.expression())).getOperation();
        String unit = ((Fragment)this.visit(ctx.unitOrRatio())).getUnit();
        ChangeUnitsOperation calculation = new ChangeUnitsOperation(futureCalculation, unit);
        return new OperationFragment(calculation);
    }

    @Override
    public Fragment visitUnitOrRatio(QubecTalkParser.UnitOrRatioContext ctx) {
        String unit = ctx.getText();
        unit = unit.replaceAll(" each ", " / ");
        return new UnitFragment(unit);
    }

    @Override
    public Fragment visitConditionExpression(QubecTalkParser.ConditionExpressionContext ctx) {
        Operation left = ((Fragment)this.visit(ctx.pos)).getOperation();
        Operation right = ((Fragment)this.visit(ctx.neg)).getOperation();
        String operatorStr = ctx.op.getText();
        EqualityOperation operation = new EqualityOperation(left, right, operatorStr);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitAdditionExpression(QubecTalkParser.AdditionExpressionContext ctx) {
        String operatorStr;
        Operation left = ((Fragment)this.visit(ctx.expression(0))).getOperation();
        Operation right = ((Fragment)this.visit(ctx.expression(1))).getOperation();
        Operation calculation = switch (operatorStr = ctx.op.getText()) {
            case "+" -> new AdditionOperation(left, right);
            case "-" -> new SubtractionOperation(left, right);
            default -> throw new RuntimeException("Unknown addition operation");
        };
        return new OperationFragment(calculation);
    }

    @Override
    public Fragment visitPowExpression(QubecTalkParser.PowExpressionContext ctx) {
        Operation left = ((Fragment)this.visit(ctx.expression(0))).getOperation();
        Operation right = ((Fragment)this.visit(ctx.expression(1))).getOperation();
        return new OperationFragment(new PowerOperation(left, right));
    }

    @Override
    public Fragment visitConditionalExpression(QubecTalkParser.ConditionalExpressionContext ctx) {
        Operation condition = ((Fragment)this.visit(ctx.cond)).getOperation();
        Operation trueCase = ((Fragment)this.visit(ctx.pos)).getOperation();
        Operation falseCase = ((Fragment)this.visit(ctx.neg)).getOperation();
        ConditionalOperation operation = new ConditionalOperation(condition, trueCase, falseCase);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitGetStreamConversion(QubecTalkParser.GetStreamConversionContext ctx) {
        String streamName = ((Fragment)this.visit(ctx.target)).getString();
        UnitFragment unitFragment = (UnitFragment)this.visit(ctx.conversion);
        String unitConversion = unitFragment.getUnit();
        GetStreamOperation operation = new GetStreamOperation(streamName, unitConversion);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLimitMinExpression(QubecTalkParser.LimitMinExpressionContext ctx) {
        return (Fragment)this.visitChildren(ctx);
    }

    @Override
    public Fragment visitGetStreamIndirectConversion(QubecTalkParser.GetStreamIndirectConversionContext ctx) {
        String streamName = ((Fragment)this.visit(ctx.target)).getString();
        String targetSubstance = ((Fragment)this.visit(ctx.rescope)).getString();
        UnitFragment unitFragment = (UnitFragment)this.visit(ctx.conversion);
        String unitConversion = unitFragment.getUnit();
        GetStreamOperation operation = new GetStreamOperation(streamName, targetSubstance, unitConversion);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLimitMaxExpression(QubecTalkParser.LimitMaxExpressionContext ctx) {
        return (Fragment)this.visitChildren(ctx);
    }

    @Override
    public Fragment visitMultiplyExpression(QubecTalkParser.MultiplyExpressionContext ctx) {
        String operatorStr;
        Operation left = ((Fragment)this.visit(ctx.expression(0))).getOperation();
        Operation right = ((Fragment)this.visit(ctx.expression(1))).getOperation();
        Operation calculation = switch (operatorStr = ctx.op.getText()) {
            case "*" -> new MultiplicationOperation(left, right);
            case "/" -> new DivisionOperation(left, right);
            default -> throw new RuntimeException("Unknown multiplication operation");
        };
        return new OperationFragment(calculation);
    }

    @Override
    public Fragment visitDrawNormalExpression(QubecTalkParser.DrawNormalExpressionContext ctx) {
        Fragment meanFragment = (Fragment)this.visit(ctx.mean);
        Operation mean = meanFragment.getOperation();
        Fragment stdFragment = (Fragment)this.visit(ctx.std);
        Operation std = stdFragment.getOperation();
        DrawNormalOperation operation = new DrawNormalOperation(mean, std);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLogicalExpression(QubecTalkParser.LogicalExpressionContext ctx) {
        Fragment leftFragment = (Fragment)this.visit(ctx.left);
        Operation left = leftFragment.getOperation();
        Fragment rightFragment = (Fragment)this.visit(ctx.right);
        Operation right = rightFragment.getOperation();
        String operatorStr = ctx.op.getText();
        LogicalOperation operation = new LogicalOperation(left, right, operatorStr);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitGetStreamIndirect(QubecTalkParser.GetStreamIndirectContext ctx) {
        String streamName = ((Fragment)this.visit(ctx.target)).getString();
        String targetSubstance = ((Fragment)this.visit(ctx.rescope)).getString();
        GetStreamOperation operation = new GetStreamOperation(streamName, targetSubstance, null);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitDrawUniformExpression(QubecTalkParser.DrawUniformExpressionContext ctx) {
        Fragment lowFragment = (Fragment)this.visit(ctx.low);
        Operation low = lowFragment.getOperation();
        Fragment highFragment = (Fragment)this.visit(ctx.high);
        Operation high = highFragment.getOperation();
        DrawUniformOperation operation = new DrawUniformOperation(low, high);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitSimpleIdentifier(QubecTalkParser.SimpleIdentifierContext ctx) {
        String identifier = ctx.getChild(0).getText();
        GetVariableOperation operation = new GetVariableOperation(identifier);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitGetStream(QubecTalkParser.GetStreamContext ctx) {
        String streamName = ((Fragment)this.visit(ctx.target)).getString();
        GetStreamOperation operation = new GetStreamOperation(streamName);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLimitBoundExpression(QubecTalkParser.LimitBoundExpressionContext ctx) {
        return (Fragment)this.visitChildren(ctx);
    }

    @Override
    public Fragment visitStream(QubecTalkParser.StreamContext ctx) {
        return new StringFragment(this.applyStreamSugar(ctx.getText().replaceAll("\"", "")));
    }

    @Override
    public Fragment visitIdentifierAsVar(QubecTalkParser.IdentifierAsVarContext ctx) {
        String identifier = ctx.getChild(0).getText();
        GetVariableOperation operation = new GetVariableOperation(identifier);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitDuringRange(QubecTalkParser.DuringRangeContext ctx) {
        CalculatedTimePointFuture start = new CalculatedTimePointFuture(((Fragment)this.visit(ctx.expression(0))).getOperation());
        CalculatedTimePointFuture end = new CalculatedTimePointFuture(((Fragment)this.visit(ctx.expression(1))).getOperation());
        ParsedDuring during = new ParsedDuring(Optional.of(start), Optional.of(end));
        return new DuringFragment(during);
    }

    @Override
    public Fragment visitDuringStart(QubecTalkParser.DuringStartContext ctx) {
        DynamicCapFuture start = new DynamicCapFuture(BEGINNING);
        ParsedDuring during = new ParsedDuring(Optional.of(start), Optional.of(start));
        return new DuringFragment(during);
    }

    @Override
    public Fragment visitDuringSingleYear(QubecTalkParser.DuringSingleYearContext ctx) {
        CalculatedTimePointFuture point = new CalculatedTimePointFuture(((Fragment)this.visit(ctx.expression())).getOperation());
        ParsedDuring during = new ParsedDuring(Optional.of(point), Optional.of(point));
        return new DuringFragment(during);
    }

    @Override
    public Fragment visitDuringAll(QubecTalkParser.DuringAllContext ctx) {
        DynamicCapFuture start = new DynamicCapFuture(BEGINNING);
        DynamicCapFuture end = new DynamicCapFuture(ONWARDS);
        ParsedDuring during = new ParsedDuring(Optional.of(start), Optional.of(end));
        return new DuringFragment(during);
    }

    @Override
    public Fragment visitDuringWithMax(QubecTalkParser.DuringWithMaxContext ctx) {
        DynamicCapFuture start = new DynamicCapFuture(BEGINNING);
        CalculatedTimePointFuture end = new CalculatedTimePointFuture(((Fragment)this.visit(ctx.expression())).getOperation());
        ParsedDuring during = new ParsedDuring(Optional.of(start), Optional.of(end));
        return new DuringFragment(during);
    }

    @Override
    public Fragment visitDuringWithMin(QubecTalkParser.DuringWithMinContext ctx) {
        CalculatedTimePointFuture start = new CalculatedTimePointFuture(((Fragment)this.visit(ctx.expression())).getOperation());
        DynamicCapFuture end = new DynamicCapFuture(ONWARDS);
        ParsedDuring during = new ParsedDuring(Optional.of(start), Optional.of(end));
        return new DuringFragment(during);
    }

    @Override
    public Fragment visitDefaultStanza(QubecTalkParser.DefaultStanzaContext ctx) {
        ArrayList<ParsedApplication> applications = new ArrayList<ParsedApplication>();
        for (QubecTalkParser.ApplicationDefContext appCtx : ctx.applicationDef()) {
            Fragment appFragment = (Fragment)this.visit(appCtx);
            applications.add(appFragment.getApplication());
        }
        ParsedPolicy policy = new ParsedPolicy("default", applications);
        return new PolicyFragment(policy);
    }

    @Override
    public Fragment visitAboutStanza(QubecTalkParser.AboutStanzaContext ctx) {
        return new AboutStanzaFragment();
    }

    @Override
    public Fragment visitSimulationsStanza(QubecTalkParser.SimulationsStanzaContext ctx) {
        ArrayList<ParsedScenario> scenarios = new ArrayList<ParsedScenario>();
        for (int i = 2; i < ctx.getChildCount() - 2; ++i) {
            if (!(ctx.getChild(i) instanceof QubecTalkParser.SimulateContext)) continue;
            QubecTalkParser.SimulateContext simCtx = (QubecTalkParser.SimulateContext)ctx.getChild(i);
            Fragment simFragment = (Fragment)this.visit(simCtx);
            scenarios.add(simFragment.getScenario());
        }
        ParsedScenarios parsedScenarios = new ParsedScenarios(scenarios);
        return new ScenariosFragment(parsedScenarios);
    }

    @Override
    public Fragment visitPolicyStanza(QubecTalkParser.PolicyStanzaContext ctx) {
        ArrayList<ParsedApplication> applications = new ArrayList<ParsedApplication>();
        String policyName = ((Fragment)this.visit(ctx.name)).getString();
        for (QubecTalkParser.ApplicationModContext appCtx : ctx.applicationMod()) {
            Fragment appFragment = (Fragment)this.visit(appCtx);
            applications.add(appFragment.getApplication());
        }
        ParsedPolicy policy = new ParsedPolicy(policyName, applications);
        return new PolicyFragment(policy);
    }

    @Override
    public Fragment visitApplicationDef(QubecTalkParser.ApplicationDefContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        ArrayList<ParsedSubstance> substances = new ArrayList<ParsedSubstance>();
        for (QubecTalkParser.SubstanceDefContext subCtx : ctx.substanceDef()) {
            Fragment substanceFragment = (Fragment)this.visit(subCtx);
            substances.add(substanceFragment.getSubstance());
        }
        ParsedApplication application = new ParsedApplication(name, substances);
        return new ApplicationFragment(application);
    }

    @Override
    public Fragment visitSubstanceDef(QubecTalkParser.SubstanceDefContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (int i = 3; i < ctx.getChildCount() - 2; ++i) {
            Fragment statementFragment = (Fragment)this.visit(ctx.getChild(i));
            if (statementFragment == null) continue;
            try {
                Operation operation = statementFragment.getOperation();
                if (operation == null) continue;
                operations.add(operation);
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        ParsedSubstance substance = new ParsedSubstance(name, operations);
        return new SubstanceFragment(substance);
    }

    @Override
    public Fragment visitApplicationMod(QubecTalkParser.ApplicationModContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        ArrayList<ParsedSubstance> substances = new ArrayList<ParsedSubstance>();
        for (QubecTalkParser.SubstanceModContext subCtx : ctx.substanceMod()) {
            Fragment substanceFragment = (Fragment)this.visit(subCtx);
            substances.add(substanceFragment.getSubstance());
        }
        ParsedApplication application = new ParsedApplication(name, substances);
        return new ApplicationFragment(application);
    }

    @Override
    public Fragment visitSubstanceMod(QubecTalkParser.SubstanceModContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (int i = 3; i < ctx.getChildCount() - 2; ++i) {
            Fragment statementFragment = (Fragment)this.visit(ctx.getChild(i));
            if (statementFragment == null) continue;
            try {
                Operation operation = statementFragment.getOperation();
                if (operation == null) continue;
                operations.add(operation);
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        ParsedSubstance substance = new ParsedSubstance(name, operations);
        return new SubstanceFragment(substance);
    }

    @Override
    public Fragment visitLimitCommandAllYears(QubecTalkParser.LimitCommandAllYearsContext ctx) {
        Operation operation;
        String stream = this.applyStreamSugar(ctx.target.getText());
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        if (ctx.getText().startsWith("cap")) {
            operation = new CapOperation(stream, valueOperation);
        } else if (ctx.getText().startsWith("floor")) {
            operation = new FloorOperation(stream, valueOperation);
        } else {
            throw new RuntimeException("Unknown limit operation: expected 'cap' or 'floor'");
        }
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLimitCommandDisplacingAllYears(QubecTalkParser.LimitCommandDisplacingAllYearsContext ctx) {
        Operation operation;
        String stream = this.applyStreamSugar(ctx.target.getText());
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        String displaceTarget = ctx.getChild(5).accept(this).getString();
        if (ctx.getText().startsWith("cap")) {
            operation = new CapOperation(stream, valueOperation, displaceTarget);
        } else if (ctx.getText().startsWith("floor")) {
            operation = new FloorOperation(stream, valueOperation, displaceTarget);
        } else {
            throw new RuntimeException("Unknown limit operation: expected 'cap' or 'floor'");
        }
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLimitCommandDuration(QubecTalkParser.LimitCommandDurationContext ctx) {
        Operation operation;
        String stream = this.applyStreamSugar(ctx.target.getText());
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        if (ctx.getText().startsWith("cap")) {
            operation = new CapOperation(stream, valueOperation, during);
        } else if (ctx.getText().startsWith("floor")) {
            operation = new FloorOperation(stream, valueOperation, during);
        } else {
            throw new RuntimeException("Unknown limit operation: expected 'cap' or 'floor'");
        }
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitLimitCommandDisplacingDuration(QubecTalkParser.LimitCommandDisplacingDurationContext ctx) {
        Operation operation;
        String stream = this.applyStreamSugar(ctx.target.getText());
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        String displaceTarget = ctx.getChild(5).accept(this).getString();
        if (ctx.getText().startsWith("cap")) {
            operation = new CapOperation(stream, valueOperation, displaceTarget, during);
        } else if (ctx.getText().startsWith("floor")) {
            operation = new FloorOperation(stream, valueOperation, displaceTarget, during);
        } else {
            throw new RuntimeException("Unknown limit operation: expected 'cap' or 'floor'");
        }
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitChangeAllYears(QubecTalkParser.ChangeAllYearsContext ctx) {
        String stream = this.applyStreamSugar(ctx.target.getText());
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        ChangeOperation operation = new ChangeOperation(stream, valueOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitChangeDuration(QubecTalkParser.ChangeDurationContext ctx) {
        String stream = this.applyStreamSugar(ctx.target.getText());
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        ChangeOperation operation = new ChangeOperation(stream, valueOperation, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitDefineVarStatement(QubecTalkParser.DefineVarStatementContext ctx) {
        String identifier = ctx.target.getText();
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        DefineVariableOperation operation = new DefineVariableOperation(identifier, valueOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitEqualsAllYears(QubecTalkParser.EqualsAllYearsContext ctx) {
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        EqualsOperation operation = new EqualsOperation(valueOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitEqualsDuration(QubecTalkParser.EqualsDurationContext ctx) {
        return (Fragment)this.visitChildren(ctx);
    }

    @Override
    public Fragment visitInitialChargeAllYears(QubecTalkParser.InitialChargeAllYearsContext ctx) {
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        String stream = this.applyStreamSugar(ctx.target.getText());
        String unitString = ctx.value.unitOrRatio().getText();
        this.validateInitialChargeUnits(unitString, stream);
        InitialChargeOperation operation = new InitialChargeOperation(stream, valueOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitInitialChargeDuration(QubecTalkParser.InitialChargeDurationContext ctx) {
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        String stream = this.applyStreamSugar(ctx.target.getText());
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        String unitString = ctx.value.unitOrRatio().getText();
        this.validateInitialChargeUnits(unitString, stream);
        InitialChargeOperation operation = new InitialChargeOperation(stream, valueOperation, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRechargeAllYears(QubecTalkParser.RechargeAllYearsContext ctx) {
        Operation populationOperation = ((Fragment)this.visit(ctx.population)).getOperation();
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        RechargeOperation operation = new RechargeOperation(populationOperation, volumeOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRechargeDuration(QubecTalkParser.RechargeDurationContext ctx) {
        Operation populationOperation = ((Fragment)this.visit(ctx.population)).getOperation();
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RechargeOperation operation = new RechargeOperation(populationOperation, volumeOperation, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverAllYears(QubecTalkParser.RecoverAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverDuration(QubecTalkParser.RecoverDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverStageAllYears(QubecTalkParser.RecoverStageAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        RecoverOperation.RecoveryStage stage = this.parseRecoveryStage(ctx.stage);
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, stage);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverStageDuration(QubecTalkParser.RecoverStageDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RecoverOperation.RecoveryStage stage = this.parseRecoveryStage(ctx.stage);
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, during, stage);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverInductionAllYears(QubecTalkParser.RecoverInductionAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        Operation inductionOperation = ((Fragment)this.visit(ctx.inductionVal)).getOperation();
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, Optional.of(inductionOperation));
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverInductionDuration(QubecTalkParser.RecoverInductionDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        Operation inductionOperation = ((Fragment)this.visit(ctx.inductionVal)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, during, Optional.of(inductionOperation));
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverInductionStageAllYears(QubecTalkParser.RecoverInductionStageAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        Operation inductionOperation = ((Fragment)this.visit(ctx.inductionVal)).getOperation();
        RecoverOperation.RecoveryStage stage = this.parseRecoveryStage(ctx.stage);
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, stage, Optional.of(inductionOperation));
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverInductionStageDuration(QubecTalkParser.RecoverInductionStageDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        Operation inductionOperation = ((Fragment)this.visit(ctx.inductionVal)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RecoverOperation.RecoveryStage stage = this.parseRecoveryStage(ctx.stage);
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, during, stage, Optional.of(inductionOperation));
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverDefaultInductionAllYears(QubecTalkParser.RecoverDefaultInductionAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, Optional.empty());
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverDefaultInductionDuration(QubecTalkParser.RecoverDefaultInductionDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, during, Optional.empty());
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverDefaultInductionStageAllYears(QubecTalkParser.RecoverDefaultInductionStageAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        RecoverOperation.RecoveryStage stage = this.parseRecoveryStage(ctx.stage);
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, stage, Optional.empty());
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRecoverDefaultInductionStageDuration(QubecTalkParser.RecoverDefaultInductionStageDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        Operation yieldOperation = ((Fragment)this.visit(ctx.yieldVal)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        RecoverOperation.RecoveryStage stage = this.parseRecoveryStage(ctx.stage);
        RecoverOperation operation = new RecoverOperation(volumeOperation, yieldOperation, during, stage, Optional.empty());
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitReplaceAllYears(QubecTalkParser.ReplaceAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        String stream = this.applyStreamSugar(ctx.target.getText());
        String destinationSubstance = ((Fragment)this.visit(ctx.destination)).getString();
        ReplaceOperation operation = new ReplaceOperation(volumeOperation, stream, destinationSubstance);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitReplaceDuration(QubecTalkParser.ReplaceDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        String stream = this.applyStreamSugar(ctx.target.getText());
        String destinationSubstance = ((Fragment)this.visit(ctx.destination)).getString();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        ReplaceOperation operation = new ReplaceOperation(volumeOperation, stream, destinationSubstance, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRetireAllYears(QubecTalkParser.RetireAllYearsContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        boolean withReplacement = this.hasWithReplacement(ctx);
        Operation operation = withReplacement ? new RetireWithReplacementOperation(volumeOperation) : new RetireOperation(volumeOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitRetireDuration(QubecTalkParser.RetireDurationContext ctx) {
        Operation volumeOperation = ((Fragment)this.visit(ctx.volume)).getOperation();
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        boolean withReplacement = this.hasWithReplacement(ctx);
        Operation operation = withReplacement ? new RetireWithReplacementOperation(volumeOperation, during) : new RetireOperation(volumeOperation, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitSetAllYears(QubecTalkParser.SetAllYearsContext ctx) {
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        String stream = this.applyStreamSugar(ctx.target.getText());
        SetOperation operation = new SetOperation(stream, valueOperation);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitSetDuration(QubecTalkParser.SetDurationContext ctx) {
        Operation valueOperation = ((Fragment)this.visit(ctx.value)).getOperation();
        String stream = this.applyStreamSugar(ctx.target.getText());
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        SetOperation operation = new SetOperation(stream, valueOperation, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitEnableAllYears(QubecTalkParser.EnableAllYearsContext ctx) {
        String stream = this.applyStreamSugar(ctx.target.getText());
        EnableOperation operation = new EnableOperation(stream);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitEnableDuration(QubecTalkParser.EnableDurationContext ctx) {
        String stream = this.applyStreamSugar(ctx.target.getText());
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        EnableOperation operation = new EnableOperation(stream, during);
        return new OperationFragment(operation);
    }

    @Override
    public Fragment visitAssumeNoAllYears(QubecTalkParser.AssumeNoAllYearsContext ctx) {
        return this.processAssumeStatement("no", ctx.target, Optional.empty());
    }

    @Override
    public Fragment visitAssumeNoDuration(QubecTalkParser.AssumeNoDurationContext ctx) {
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        return this.processAssumeStatement("no", ctx.target, Optional.of(during));
    }

    @Override
    public Fragment visitAssumeOnlyRechargeAllYears(QubecTalkParser.AssumeOnlyRechargeAllYearsContext ctx) {
        return this.processAssumeStatement("onlyrecharge", ctx.target, Optional.empty());
    }

    @Override
    public Fragment visitAssumeOnlyRechargeDuration(QubecTalkParser.AssumeOnlyRechargeDurationContext ctx) {
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        return this.processAssumeStatement("onlyrecharge", ctx.target, Optional.of(during));
    }

    @Override
    public Fragment visitAssumeContinuedAllYears(QubecTalkParser.AssumeContinuedAllYearsContext ctx) {
        return this.processAssumeStatement("continued", ctx.target, Optional.empty());
    }

    @Override
    public Fragment visitAssumeContinuedDuration(QubecTalkParser.AssumeContinuedDurationContext ctx) {
        ParsedDuring during = ((Fragment)this.visit(ctx.duration)).getDuring();
        return this.processAssumeStatement("continued", ctx.target, Optional.of(during));
    }

    @Override
    public Fragment visitBaseSimulation(QubecTalkParser.BaseSimulationContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        int startYear = Integer.parseInt(ctx.start.getText());
        int endYear = Integer.parseInt(ctx.end.getText());
        ParsedScenario scenario = new ParsedScenario(name, new ArrayList<String>(), startYear, endYear, 1);
        return new ScenarioFragment(scenario);
    }

    @Override
    public Fragment visitPolicySim(QubecTalkParser.PolicySimContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        int startYear = Integer.parseInt(ctx.start.getText());
        int endYear = Integer.parseInt(ctx.end.getText());
        ArrayList<String> policies = new ArrayList<String>();
        for (int i = 0; i < ctx.string().size() - 1; ++i) {
            policies.add(((Fragment)this.visit(ctx.string(i + 1))).getString());
        }
        ParsedScenario scenario = new ParsedScenario(name, policies, startYear, endYear, 1);
        return new ScenarioFragment(scenario);
    }

    @Override
    public Fragment visitBaseSimulationTrials(QubecTalkParser.BaseSimulationTrialsContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        int startYear = Integer.parseInt(ctx.start.getText());
        int endYear = Integer.parseInt(ctx.end.getText());
        int trials = Integer.parseInt(ctx.trials.getText());
        ParsedScenario scenario = new ParsedScenario(name, new ArrayList<String>(), startYear, endYear, trials);
        return new ScenarioFragment(scenario);
    }

    @Override
    public Fragment visitPolicySimTrials(QubecTalkParser.PolicySimTrialsContext ctx) {
        String name = ((Fragment)this.visit(ctx.name)).getString();
        int startYear = Integer.parseInt(ctx.start.getText());
        int endYear = Integer.parseInt(ctx.end.getText());
        int trials = Integer.parseInt(ctx.trials.getText());
        ArrayList<String> policies = new ArrayList<String>();
        for (int i = 0; i < ctx.string().size() - 1; ++i) {
            policies.add(((Fragment)this.visit(ctx.string(i + 1))).getString());
        }
        ParsedScenario scenario = new ParsedScenario(name, policies, startYear, endYear, trials);
        return new ScenarioFragment(scenario);
    }

    @Override
    public Fragment visitGlobalStatement(QubecTalkParser.GlobalStatementContext ctx) {
        return (Fragment)this.visitChildren(ctx);
    }

    @Override
    public Fragment visitSubstanceStatement(QubecTalkParser.SubstanceStatementContext ctx) {
        return (Fragment)this.visitChildren(ctx);
    }

    @Override
    public Fragment visitParenExpression(QubecTalkParser.ParenExpressionContext ctx) {
        return (Fragment)this.visit(ctx.getChild(1));
    }

    @Override
    public Fragment visitProgram(QubecTalkParser.ProgramContext ctx) {
        ArrayList<ParsedPolicy> policies = new ArrayList<ParsedPolicy>();
        ArrayList<ParsedScenario> scenarios = new ArrayList<ParsedScenario>();
        for (QubecTalkParser.StanzaContext stanzaCtx : ctx.stanza()) {
            Fragment stanzaFragment = (Fragment)this.visit(stanzaCtx);
            if (stanzaFragment.getIsStanzaScenarios()) {
                ParsedScenarios parsedScenarios = stanzaFragment.getScenarios();
                for (String scenarioName : parsedScenarios.getScenarios()) {
                    scenarios.add(parsedScenarios.getScenario(scenarioName));
                }
                continue;
            }
            if (!stanzaFragment.getIsStanzaPolicyOrDefault()) continue;
            policies.add(stanzaFragment.getPolicy());
        }
        ParsedProgram program = new ParsedProgram(policies, scenarios);
        return new ProgramFragment(program);
    }

    private RecoverOperation.RecoveryStage parseRecoveryStage(Token stageToken) {
        String stageText;
        return switch (stageText = stageToken.getText()) {
            case "eol" -> RecoverOperation.RecoveryStage.EOL;
            case "recharge" -> RecoverOperation.RecoveryStage.RECHARGE;
            default -> throw new IllegalArgumentException("Invalid recovery stage: " + stageText);
        };
    }

    private boolean hasWithReplacement(ParserRuleContext ctx) {
        return ctx.getText().toLowerCase().contains("withreplacement");
    }

    private void validateInitialChargeUnits(String unitString, String stream) {
        String normalized = unitString.trim().toLowerCase();
        if (!normalized.endsWith("unit") && !normalized.endsWith("units")) {
            throw new RuntimeException(String.format("Initial charge for %s stream must be specified per unit (e.g., 'kg / unit' or 'kg / units'), but found '%s'. Equipment-based calculations require initial charges to be rates per unit.", stream, unitString));
        }
    }

    private String applyStreamSugar(String streamName) {
        return switch (streamName) {
            case "bank" -> "equipment";
            case "priorBank" -> "priorEquipment";
            default -> streamName;
        };
    }

    private Operation makeSet(String stream, Operation valueOperation, Optional<ParsedDuring> duringMaybe) {
        if (duringMaybe.isPresent()) {
            return new SetOperation(stream, valueOperation, duringMaybe.get());
        }
        return new SetOperation(stream, valueOperation);
    }

    private Fragment processAssumeStatement(String modeText, QubecTalkParser.StreamContext targetContext, Optional<ParsedDuring> duringMaybe) {
        String stream = this.applyStreamSugar(targetContext.getText());
        return switch (modeText) {
            case "no" -> {
                EngineNumber zeroKg = new EngineNumber(BigDecimal.ZERO, "kg");
                PreCalculatedOperation valueOperation = new PreCalculatedOperation(zeroKg);
                yield new OperationFragment(this.makeSet(stream, valueOperation, duringMaybe));
            }
            case "onlyrecharge" -> {
                EngineNumber zeroUnits = new EngineNumber(BigDecimal.ZERO, "units");
                PreCalculatedOperation valueOperation = new PreCalculatedOperation(zeroUnits);
                yield new OperationFragment(this.makeSet(stream, valueOperation, duringMaybe));
            }
            case "continued" -> new OperationFragment(null);
            default -> throw new RuntimeException("Unknown assume mode: " + modeText);
        };
    }
}

