/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.localization;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.kigalisim.lang.localization.FlexibleNumberParseResult;
import org.kigalisim.lang.localization.NumberParseUtilStrategy;

public class MixedParseStrategy
implements NumberParseUtilStrategy {
    @Override
    public boolean canHandle(String numberStr, int commaCount, int periodCount) {
        return commaCount > 0 && periodCount > 0;
    }

    @Override
    public FlexibleNumberParseResult parseNumber(String numberStr, int commaCount, int periodCount) {
        if (!this.canHandle(numberStr, commaCount, periodCount)) {
            return new FlexibleNumberParseResult("MixedParseStrategy cannot handle this pattern");
        }
        return this.handleMixedSeparators(numberStr);
    }

    private FlexibleNumberParseResult handleMixedSeparators(String numberStr) {
        int lastPeriodIndex;
        int lastCommaIndex = numberStr.lastIndexOf(44);
        if (lastCommaIndex < (lastPeriodIndex = numberStr.lastIndexOf(46))) {
            String withoutThousands = numberStr.replace(",", "");
            FlexibleNumberParseResult decimalValidation = this.validateSingleDecimalSeparator(withoutThousands, '.');
            if (decimalValidation.isError()) {
                return decimalValidation;
            }
            FlexibleNumberParseResult thousandsValidation = this.validateThousandsSeparatorPositions(numberStr.substring(0, lastPeriodIndex), ',');
            if (thousandsValidation.isError()) {
                return thousandsValidation;
            }
            return new FlexibleNumberParseResult(new BigDecimal(withoutThousands));
        }
        String suggestion = this.convertEuropeanToUk(numberStr);
        return new FlexibleNumberParseResult(String.format("Unsupported number format: '%s'. Please use: '%s'. Kigali Sim requires comma for thousands separator and period for decimal point.", numberStr, suggestion));
    }

    private FlexibleNumberParseResult validateThousandsSeparatorPositions(String numberStr, char separator) {
        if (numberStr == null || numberStr.isEmpty() || !numberStr.contains(String.valueOf(separator))) {
            return new FlexibleNumberParseResult(new BigDecimal("0"));
        }
        String[] parts = numberStr.split(Pattern.quote(String.valueOf(separator)));
        if (parts.length < 2) {
            return new FlexibleNumberParseResult(new BigDecimal("0"));
        }
        if (parts[0].isEmpty() || parts[0].length() > 3) {
            return new FlexibleNumberParseResult("Invalid thousands separator format: '" + numberStr + "'");
        }
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].length() == 3 && parts[i].matches("\\d{3}")) continue;
            return new FlexibleNumberParseResult("Invalid thousands separator format: '" + numberStr + "'");
        }
        return new FlexibleNumberParseResult(new BigDecimal("0"));
    }

    private FlexibleNumberParseResult validateSingleDecimalSeparator(String numberStr, char decimalSeparator) {
        int count = this.countOccurrences(numberStr, decimalSeparator);
        if (count > 1) {
            return new FlexibleNumberParseResult("Invalid number format: multiple decimal separators in '" + numberStr + "'");
        }
        return new FlexibleNumberParseResult(new BigDecimal("0"));
    }

    private int countOccurrences(String str, char ch) {
        String target = String.valueOf(ch);
        int originalLength = str.length();
        int lengthWithoutTarget = str.replaceAll(Pattern.quote(target), "").length();
        return originalLength - lengthWithoutTarget;
    }

    private String convertEuropeanToUk(String europeanNumber) {
        int lastCommaIndex = europeanNumber.lastIndexOf(44);
        if (lastCommaIndex == -1) {
            return europeanNumber.replace(".", ",");
        }
        String thousandsPart = europeanNumber.substring(0, lastCommaIndex);
        String decimalPart = europeanNumber.substring(lastCommaIndex + 1);
        String ukThousands = thousandsPart.replace(".", ",");
        return ukThousands + "." + decimalPart;
    }
}

