/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.localization;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.kigalisim.lang.localization.FlexibleNumberParseResult;
import org.kigalisim.lang.localization.MixedParseStrategy;
import org.kigalisim.lang.localization.NumberParseUtilStrategy;
import org.kigalisim.lang.localization.OnlyCommasParseStrategy;
import org.kigalisim.lang.localization.OnlyPeriodsParseStrategy;

public class NumberParseUtil {
    private final List<NumberParseUtilStrategy> strategies = Arrays.asList(new OnlyCommasParseStrategy(), new OnlyPeriodsParseStrategy(), new MixedParseStrategy());

    public FlexibleNumberParseResult parseFlexibleNumber(String numberString) {
        int periodCount;
        boolean noPeriod;
        if (numberString == null || numberString.trim().isEmpty()) {
            return new FlexibleNumberParseResult("Number string cannot be null or empty");
        }
        String cleanedInput = numberString.trim();
        boolean isNegative = cleanedInput.startsWith("-");
        boolean hasPositiveSign = cleanedInput.startsWith("+");
        if (isNegative || hasPositiveSign) {
            cleanedInput = cleanedInput.substring(1);
        }
        if (cleanedInput.startsWith(",") || cleanedInput.endsWith(",") || cleanedInput.endsWith(".")) {
            return new FlexibleNumberParseResult("Invalid number format: '" + numberString + "'");
        }
        boolean noComma = !cleanedInput.contains(",");
        boolean bl = noPeriod = !cleanedInput.contains(".");
        if (noComma && noPeriod) {
            try {
                BigDecimal result = new BigDecimal(cleanedInput);
                return new FlexibleNumberParseResult(isNegative ? result.negate() : result);
            }
            catch (NumberFormatException e) {
                return new FlexibleNumberParseResult("Invalid number format: '" + numberString + "'");
            }
        }
        int commaCount = this.countOccurrences(cleanedInput, ',');
        NumberParseUtilStrategy strategy = this.sniffStrategy(cleanedInput, commaCount, periodCount = this.countOccurrences(cleanedInput, '.'));
        FlexibleNumberParseResult parseResult = strategy.parseNumber(cleanedInput, commaCount, periodCount);
        if (parseResult.isError()) {
            return parseResult;
        }
        try {
            BigDecimal result = parseResult.getParsedNumber().get();
            return new FlexibleNumberParseResult(isNegative ? result.negate() : result);
        }
        catch (NumberFormatException e) {
            return new FlexibleNumberParseResult("Invalid number format: '" + numberString + "'");
        }
    }

    private NumberParseUtilStrategy sniffStrategy(String numberStr, int commaCount, int periodCount) {
        for (NumberParseUtilStrategy strategy : this.strategies) {
            if (!strategy.canHandle(numberStr, commaCount, periodCount)) continue;
            return strategy;
        }
        return new MixedParseStrategy();
    }

    private int countOccurrences(String str, char ch) {
        String target = String.valueOf(ch);
        int originalLength = str.length();
        int lengthWithoutTarget = str.replaceAll(Pattern.quote(target), "").length();
        return originalLength - lengthWithoutTarget;
    }
}

