/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.localization;

import java.math.BigDecimal;
import org.kigalisim.lang.localization.FlexibleNumberParseResult;
import org.kigalisim.lang.localization.SingleDelimiterTemplate;

public class OnlyCommasParseStrategy
extends SingleDelimiterTemplate {
    @Override
    public boolean canHandle(String numberStr, int commaCount, int periodCount) {
        return commaCount > 0 && periodCount == 0;
    }

    @Override
    protected char getSeparator() {
        return ',';
    }

    @Override
    protected String getStrategyName() {
        return "OnlyCommasParseStrategy";
    }

    @Override
    protected int getSeparatorCount(int commaCount, int periodCount) {
        return commaCount;
    }

    @Override
    protected FlexibleNumberParseResult handleMultipleSeparators(String numberStr, char separator) {
        FlexibleNumberParseResult validationResult = this.validateThousandsSeparatorPositions(numberStr, separator);
        if (validationResult.isError()) {
            return validationResult;
        }
        return new FlexibleNumberParseResult(new BigDecimal(numberStr.replace(String.valueOf(separator), "")));
    }

    @Override
    protected FlexibleNumberParseResult handleLeadingSeparator(String numberStr) {
        String suggestion = this.generateUkFormatSuggestion(numberStr);
        return new FlexibleNumberParseResult(String.format("Unsupported number format: '%s'. Please use: '%s'. Kigali Sim requires comma for thousands separator and period for decimal point.", numberStr, suggestion));
    }

    @Override
    protected FlexibleNumberParseResult handleAmbiguousCase(String numberStr, char separator, int separatorIndex, int digitsBefore) {
        if (digitsBefore >= 4) {
            String suggestion = this.generateUkFormatSuggestion(numberStr);
            return new FlexibleNumberParseResult(String.format("Unsupported format detected: '%s'. Please use format: '%s'. Kigali Sim requires comma for thousands and period for decimal.", numberStr, suggestion));
        }
        if (this.isLikelyThousandsSeparator(numberStr, separatorIndex)) {
            return new FlexibleNumberParseResult(new BigDecimal(numberStr.replace(String.valueOf(separator), "")));
        }
        if (numberStr.startsWith("0,")) {
            String suggestion = this.generateUkFormatSuggestion(numberStr);
            return new FlexibleNumberParseResult(String.format("Unsupported format detected: '%s'. Please use format: '%s'. Kigali Sim requires comma for thousands and period for decimal.", numberStr, suggestion));
        }
        return new FlexibleNumberParseResult(new BigDecimal(numberStr.replace(String.valueOf(separator), "")));
    }

    @Override
    protected FlexibleNumberParseResult handleSingleNonAmbiguous(String numberStr) {
        String suggestion = this.generateUkFormatSuggestion(numberStr);
        return new FlexibleNumberParseResult(String.format("Unsupported number format: '%s'. Please use: '%s'. Kigali Sim requires comma for thousands separator and period for decimal point.", numberStr, suggestion));
    }

    private boolean isEuropeanDecimalPattern(String numberStr, int separatorIndex) {
        return false;
    }

    private String generateUkFormatSuggestion(String europeanInput) {
        return europeanInput.replace(",", ".");
    }
}

