/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.localization;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.kigalisim.lang.localization.FlexibleNumberParseResult;
import org.kigalisim.lang.localization.SingleDelimiterTemplate;

public class OnlyPeriodsParseStrategy
extends SingleDelimiterTemplate {
    @Override
    public boolean canHandle(String numberStr, int commaCount, int periodCount) {
        return periodCount > 0 && commaCount == 0;
    }

    @Override
    protected char getSeparator() {
        return '.';
    }

    @Override
    protected String getStrategyName() {
        return "OnlyPeriodsParseStrategy";
    }

    @Override
    protected int getSeparatorCount(int commaCount, int periodCount) {
        return periodCount;
    }

    @Override
    protected FlexibleNumberParseResult handleMultipleSeparators(String numberStr, char separator) {
        if (this.isEuropeanThousandsPattern(numberStr)) {
            String suggestion = this.generateUkFormatSuggestion(numberStr);
            return new FlexibleNumberParseResult(String.format("Unsupported number format: '%s'. Please use: '%s'. Kigali Sim requires comma for thousands separator and period for decimal point.", numberStr, suggestion));
        }
        FlexibleNumberParseResult validationResult = this.validateThousandsSeparatorPositions(numberStr, separator);
        if (validationResult.isError()) {
            return validationResult;
        }
        return new FlexibleNumberParseResult(new BigDecimal(numberStr.replace(String.valueOf(separator), "")));
    }

    @Override
    protected FlexibleNumberParseResult handleLeadingSeparator(String numberStr) {
        return new FlexibleNumberParseResult(new BigDecimal(numberStr));
    }

    @Override
    protected FlexibleNumberParseResult handleAmbiguousCase(String numberStr, char separator, int separatorIndex, int digitsBefore) {
        if (digitsBefore >= 4) {
            return new FlexibleNumberParseResult(new BigDecimal(numberStr));
        }
        if (this.isLikelyThousandsSeparator(numberStr, separatorIndex)) {
            return new FlexibleNumberParseResult(new BigDecimal(numberStr.replace(String.valueOf(separator), "")));
        }
        if (numberStr.startsWith("0.")) {
            return new FlexibleNumberParseResult(new BigDecimal(numberStr));
        }
        return new FlexibleNumberParseResult(new BigDecimal(numberStr));
    }

    @Override
    protected FlexibleNumberParseResult handleSingleNonAmbiguous(String numberStr) {
        return new FlexibleNumberParseResult(new BigDecimal(numberStr));
    }

    private boolean isEuropeanThousandsPattern(String numberStr) {
        return numberStr.contains(".") && this.countOccurrences(numberStr, '.') > 1;
    }

    private String generateUkFormatSuggestion(String europeanInput) {
        return europeanInput.replace(".", ",");
    }

    private int countOccurrences(String str, char ch) {
        String target = String.valueOf(ch);
        int originalLength = str.length();
        int lengthWithoutTarget = str.replaceAll(Pattern.quote(target), "").length();
        return originalLength - lengthWithoutTarget;
    }
}

