/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.localization;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.kigalisim.lang.localization.FlexibleNumberParseResult;
import org.kigalisim.lang.localization.NumberParseUtilStrategy;

public abstract class SingleDelimiterTemplate
implements NumberParseUtilStrategy {
    @Override
    public FlexibleNumberParseResult parseNumber(String numberStr, int commaCount, int periodCount) {
        if (!this.canHandle(numberStr, commaCount, periodCount)) {
            return new FlexibleNumberParseResult(this.getStrategyName() + " cannot handle this pattern");
        }
        return this.handleSingleSeparatorType(numberStr, this.getSeparator(), this.getSeparatorCount(commaCount, periodCount));
    }

    protected abstract char getSeparator();

    protected abstract String getStrategyName();

    protected abstract int getSeparatorCount(int var1, int var2);

    protected abstract FlexibleNumberParseResult handleMultipleSeparators(String var1, char var2);

    protected abstract FlexibleNumberParseResult handleLeadingSeparator(String var1);

    protected abstract FlexibleNumberParseResult handleSingleNonAmbiguous(String var1);

    protected abstract FlexibleNumberParseResult handleAmbiguousCase(String var1, char var2, int var3, int var4);

    protected final FlexibleNumberParseResult handleSingleSeparatorType(String numberStr, char separator, int count) {
        if (count > 1) {
            return this.handleMultipleSeparators(numberStr, separator);
        }
        int separatorIndex = numberStr.indexOf(separator);
        int digitsAfter = numberStr.length() - separatorIndex - 1;
        int digitsBefore = separatorIndex;
        if (digitsBefore == 0) {
            return this.handleLeadingSeparator(numberStr);
        }
        if (digitsAfter == 3) {
            return this.handleAmbiguousCase(numberStr, separator, separatorIndex, digitsBefore);
        }
        return this.handleSingleNonAmbiguous(numberStr);
    }

    protected final boolean isLikelyThousandsSeparator(String numberStr, int separatorIndex) {
        int digitsBefore = separatorIndex;
        String leadingPattern = "0" + this.getSeparator();
        if (numberStr.startsWith(leadingPattern)) {
            return false;
        }
        return digitsBefore >= 4;
    }

    protected final FlexibleNumberParseResult validateThousandsSeparatorPositions(String numberStr, char separator) {
        if (numberStr == null || numberStr.isEmpty() || !numberStr.contains(String.valueOf(separator))) {
            return new FlexibleNumberParseResult(new BigDecimal("0"));
        }
        String[] parts = numberStr.split(Pattern.quote(String.valueOf(separator)));
        if (parts.length < 2) {
            return new FlexibleNumberParseResult(new BigDecimal("0"));
        }
        if (parts[0].isEmpty() || parts[0].length() > 3) {
            return new FlexibleNumberParseResult("Invalid thousands separator format: '" + numberStr + "'");
        }
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].length() == 3 && parts[i].matches("\\d{3}")) continue;
            return new FlexibleNumberParseResult("Invalid thousands separator format: '" + numberStr + "'");
        }
        return new FlexibleNumberParseResult(new BigDecimal("0"));
    }
}

