/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.machine;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Optional;
import java.util.Random;
import java.util.Stack;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.lang.machine.PushDownMachine;

public class SingleThreadPushDownMachine
implements PushDownMachine {
    private final Engine engine;
    private final Stack<EngineNumber> stack;
    private Optional<String> expectedUnitsMaybe;
    private final Random random;

    public SingleThreadPushDownMachine(Engine engine) {
        this.engine = engine;
        this.stack = new Stack();
        this.expectedUnitsMaybe = Optional.empty();
        this.random = new Random();
    }

    @Override
    public void push(EngineNumber value) {
        this.stack.push(value);
    }

    @Override
    public EngineNumber getResult() {
        if (this.stack.size() != 1) {
            throw new RuntimeException("Expected exactly one result on the stack. Saw: " + this.stack.size());
        }
        return this.pop();
    }

    @Override
    public void add() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        BigDecimal resultValue = left.getValue().add(right.getValue());
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void subtract() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        BigDecimal resultValue = left.getValue().subtract(right.getValue());
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void multiply() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        BigDecimal resultValue = left.getValue().multiply(right.getValue());
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void power() {
        EngineNumber right = this.pop();
        EngineNumber left = this.pop();
        this.setExpectedUnits(left.getUnits());
        BigDecimal resultValue = BigDecimal.valueOf(Math.pow(left.getValue().doubleValue(), right.getValue().doubleValue()));
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void divide() {
        EngineNumber right = this.pop();
        if (right.getValue().compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("Division by zero");
        }
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        BigDecimal resultValue = left.getValue().divide(right.getValue(), MathContext.DECIMAL128);
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void changeUnits(String units) {
        boolean allowed;
        EngineNumber top = this.pop();
        boolean bl = allowed = top.getUnits().isEmpty() || top.getUnits().equals(units);
        if (!allowed) {
            String message = String.format("Unexpected units for top value. Anticipated empty or %s but got %s.", units, top.getUnits());
            throw new RuntimeException(message);
        }
        EngineNumber topWithUnits = new EngineNumber(top.getValue(), units);
        this.push(topWithUnits);
    }

    @Override
    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public void and() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean leftBool = !left.getValue().equals(BigDecimal.ZERO);
        boolean rightBool = !right.getValue().equals(BigDecimal.ZERO);
        BigDecimal resultValue = leftBool && rightBool ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void or() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean leftBool = !left.getValue().equals(BigDecimal.ZERO);
        boolean rightBool = !right.getValue().equals(BigDecimal.ZERO);
        BigDecimal resultValue = leftBool || rightBool ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void xor() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean leftBool = !left.getValue().equals(BigDecimal.ZERO);
        boolean rightBool = !right.getValue().equals(BigDecimal.ZERO);
        BigDecimal resultValue = leftBool ^ rightBool ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void equals() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean result = left.getValue().compareTo(right.getValue()) == 0;
        BigDecimal resultValue = result ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber resultNumber = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(resultNumber);
        this.clearExpectedUnits();
    }

    @Override
    public void notEquals() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean result = left.getValue().compareTo(right.getValue()) != 0;
        BigDecimal resultValue = result ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber resultNumber = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(resultNumber);
        this.clearExpectedUnits();
    }

    @Override
    public void greaterThan() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean result = left.getValue().compareTo(right.getValue()) > 0;
        BigDecimal resultValue = result ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber resultNumber = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(resultNumber);
        this.clearExpectedUnits();
    }

    @Override
    public void lessThan() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean result = left.getValue().compareTo(right.getValue()) < 0;
        BigDecimal resultValue = result ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber resultNumber = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(resultNumber);
        this.clearExpectedUnits();
    }

    @Override
    public void greaterThanOrEqual() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean result = left.getValue().compareTo(right.getValue()) >= 0;
        BigDecimal resultValue = result ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber resultNumber = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(resultNumber);
        this.clearExpectedUnits();
    }

    @Override
    public void lessThanOrEqual() {
        EngineNumber right = this.pop();
        this.setExpectedUnits(right.getUnits());
        EngineNumber left = this.pop();
        boolean result = left.getValue().compareTo(right.getValue()) <= 0;
        BigDecimal resultValue = result ? BigDecimal.ONE : BigDecimal.ZERO;
        EngineNumber resultNumber = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(resultNumber);
        this.clearExpectedUnits();
    }

    private EngineNumber pop() {
        EngineNumber result = this.stack.pop();
        if (this.expectedUnitsMaybe.isPresent()) {
            boolean unitsOk;
            String expectedUnits = this.expectedUnitsMaybe.get();
            String actualUnits = result.getUnits();
            boolean haveBlank = expectedUnits.isEmpty() || actualUnits.isEmpty();
            boolean haveSameUnits = expectedUnits.equals(actualUnits);
            boolean bl = unitsOk = haveBlank || haveSameUnits;
            if (!unitsOk) {
                String message = String.format("Unexpected units for popped value. Anticipated %s but got %s.", expectedUnits, result.getUnits());
                throw new RuntimeException(message);
            }
        }
        return result;
    }

    private void setExpectedUnits(String units) {
        this.expectedUnitsMaybe = Optional.of(units);
    }

    private void clearExpectedUnits() {
        this.expectedUnitsMaybe = Optional.empty();
    }

    private String getExpectedUnits() {
        return this.expectedUnitsMaybe.orElseThrow();
    }

    @Override
    public void drawNormal() {
        EngineNumber std = this.pop();
        this.setExpectedUnits(std.getUnits());
        EngineNumber mean = this.pop();
        double meanValue = mean.getValue().doubleValue();
        double stdValue = std.getValue().doubleValue();
        double sampledValue = this.random.nextGaussian() * stdValue + meanValue;
        BigDecimal resultValue = BigDecimal.valueOf(sampledValue);
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }

    @Override
    public void drawUniform() {
        EngineNumber high = this.pop();
        this.setExpectedUnits(high.getUnits());
        EngineNumber low = this.pop();
        double lowValue = low.getValue().doubleValue();
        double highValue = high.getValue().doubleValue();
        double sampledValue = lowValue + (highValue - lowValue) * this.random.nextDouble();
        BigDecimal resultValue = BigDecimal.valueOf(sampledValue);
        EngineNumber result = new EngineNumber(resultValue, this.getExpectedUnits());
        this.push(result);
        this.clearExpectedUnits();
    }
}

