/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.math.BigDecimal;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;

public class ConditionalOperation
implements Operation {
    private final Operation condition;
    private final Operation trueCase;
    private final Operation falseCase;

    public ConditionalOperation(Operation condition, Operation trueCase, Operation falseCase) {
        this.condition = condition;
        this.trueCase = trueCase;
        this.falseCase = falseCase;
    }

    @Override
    public void execute(PushDownMachine machine) {
        Operation simpleOp = new Operation(){

            @Override
            public void execute(PushDownMachine m) {
                boolean conditionBool;
                ConditionalOperation.this.condition.execute(m);
                EngineNumber conditionResult = m.getResult();
                boolean bl = conditionBool = !conditionResult.getValue().equals(BigDecimal.ZERO);
                if (conditionBool) {
                    ConditionalOperation.this.trueCase.execute(m);
                } else {
                    ConditionalOperation.this.falseCase.execute(m);
                }
            }
        };
        simpleOp.execute(machine);
    }
}

